/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.struc.MolAtom;
import java.awt.event.ActionEvent;

class IsotopeAction
extends AbstractStateAction {
    private SketchPanel panel;
    private int isotope;
    private MolAtom atom;

    public IsotopeAction(SketchPanel panel, MolAtom atom, String name, int isotope) {
        super(name);
        this.panel = panel;
        this.isotope = isotope;
        this.setRadio(true);
        this.atom = atom;
        this.update();
    }

    private void update() {
        this.setEnabled(AbstractSketchAction.isNormalAtom(this.atom));
        int a = this.atom.getMassno();
        boolean spec1 = (this.isotope & 0x1000) != 0;
        boolean spec2 = this.atom.isSpecIsotopeSymbolPreferred();
        this.setSelected(this.isEnabled() && a == (this.isotope & 0xFFFFEFFF) && spec1 == spec2);
    }

    void setAtom(MolAtom atom) {
        this.atom = atom;
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.panel.getCanvas().setIsotope(this.atom, this.isotope);
    }
}

