/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.struc.MolAtom;
import java.awt.event.ActionEvent;

class LinkNodeAction
extends AbstractStateAction {
    private SketchPanel panel;
    private int value;
    private MolAtom atom;
    private boolean middleAtom;

    public LinkNodeAction(SketchPanel panel, String name, MolAtom atom, boolean middleAtom, int value) {
        super(name);
        this.panel = panel;
        this.value = value;
        this.atom = atom;
        this.middleAtom = middleAtom;
        this.setRadio(true);
        this.update();
    }

    private void update() {
        this.setEnabled(LinkNodeAction.isEnabledFor(this.atom));
        this.setSelected(this.isEnabled() && this.atom.getMaxRepetitions() == this.value);
    }

    static boolean isEnabledFor(MolAtom atom) {
        return atom != null && atom.getBondCount() != 0 && !AbstractSketchAction.isLP(atom);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MolAtom a = this.middleAtom ? null : this.atom;
        this.panel.getCanvas().setLinkNodeMaxRepetition(a, this.value);
    }
}

