/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.sketch.swing.actions.atom.MenuUtil;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

class RGroupAction
extends AbstractStateAction {
    static final int CUSTOM = Integer.MIN_VALUE;
    private static final ResourceBundle bundle = ResourceBundle.getBundle(RGroupAction.class.getName());
    private SketchPanel panel;
    private MolAtom atom;
    private final int value;

    public RGroupAction(SketchPanel panel, int value) {
        this.panel = panel;
        this.value = value;
        this.init();
        this.update();
    }

    private void init() {
        if (this.value == Integer.MIN_VALUE) {
            this.putValue("Name", "R...");
        } else if (this.value == 0) {
            this.putValue("Name", "R");
        } else {
            this.putValue("Name", "R" + this.value);
        }
    }

    private boolean isEnabled(MolAtom atom) {
        return atom != null && (AbstractSketchAction.isRGroup(atom) || this.panel.getEditor().isAllowed(new Molecule(null, new MolAtom(134)))) && !AbstractSketchAction.isLP(atom) && !(atom instanceof SgroupAtom);
    }

    void setAtom(MolAtom atom) {
        this.atom = atom;
        this.update();
    }

    private void update() {
        this.setEnabled(this.isEnabled(this.atom));
        this.setSelected(this.isEnabled() && this.atom.getAtno() == 134 && this.atom.getRgroup() == this.value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int number = this.value;
        if (this.value == Integer.MIN_VALUE) {
            Integer input = MenuUtil.showIntegerInputDialog(this.panel, bundle.getString("custom.message"), bundle.getString("title"), "R");
            if (input == null) {
                return;
            }
            number = input;
        }
        this.panel.getCanvas().setRGroup(this.atom, number);
    }
}

