/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.lang.ref.WeakReference;
import javax.swing.Action;

public class RSAction
extends AbstractSelectionToggleAction
implements PopupActionProvider,
EnumeratedAction<Integer> {
    private int value;
    private WeakReference ref;
    private int calculatedValue;

    public RSAction() {
        super(true);
    }

    public Integer[] getValues() {
        return new Integer[]{24, 8, 16};
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    public RSAction(SketchPanel panel, int value) {
        super(panel, true);
        this.value = value;
        this.stateChanged();
    }

    @Override
    protected void actionPerformed(Object selection) {
        MolAtom atom = (MolAtom)selection;
        this.getCanvas().setStereo(atom, this.value);
    }

    @Override
    protected Object getSelection() {
        MolAtom atom = this.getSelectedAtom();
        return RSAction.isNormalAtom(atom) ? atom : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isEnabledFor(Object o) {
        if (o == null) {
            return false;
        }
        int c = this.getChirality((MolAtom)o);
        RSAction rSAction = this;
        synchronized (rSAction) {
            this.ref = new WeakReference<Object>(o);
            this.calculatedValue = c;
        }
        return c != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getChirality(MolAtom atom) {
        int c;
        Molecule mol = this.getEditor().getMol();
        try {
            mol.setGUIContracted(false);
            MoleculeGraph m = mol.getGraphUnion();
            int i = m.indexOf(atom);
            if (!(m instanceof Molecule) && i >= 0 && mol.getSgroupCount() > 0) {
                MoleculeGraph m1 = (MoleculeGraph)m.clone();
                MolAtom a1 = m1.getAtom(i);
                m = (Molecule)mol.newInstance();
                m.fuse(m1);
                i = m.indexOf(a1);
                m1 = null;
            }
            c = i >= 0 ? m.getChirality(i) : 0;
            m = null;
        }
        finally {
            mol.setGUIContracted(true);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isSelected(Object o) {
        int c = -1;
        RSAction rSAction = this;
        synchronized (rSAction) {
            if (o == this.ref.get()) {
                c = this.calculatedValue;
            }
        }
        if (c == -1) {
            c = this.getChirality((MolAtom)o);
        }
        return c == this.value;
    }

    @Override
    public Action createLocalInstance(Context context) {
        return this.createLocalInstanceIfEnabled(RSAction.lookupAtom(context));
    }
}

