/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.sketch.swing.actions.atom.MenuUtil;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.struc.MolAtom;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

public class ValenceAction
extends AbstractStateAction {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(ValenceAction.class.getName());
    private SketchPanel panel;
    private MolAtom atom;
    private int valence;

    public ValenceAction(SketchPanel panel, int valence) {
        this.panel = panel;
        this.valence = valence;
        this.setRadio(true);
        this.init();
        this.update();
    }

    private void init() {
        if (this.valence == Integer.MAX_VALUE) {
            this.putValue("Name", "Valence...");
        } else if (this.valence == -1) {
            this.putValue("Name", bundle.getString("noneLabel"));
        } else {
            this.putValue("Name", "" + this.valence);
        }
    }

    private void update() {
        this.setEnabled(AbstractSketchAction.isNormalAtom(this.atom));
        this.setSelected(this.isEnabled() && this.atom != null && this.atom.getValenceProp() == this.valence);
    }

    void setAtom(MolAtom atom) {
        this.atom = atom;
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent ignored) {
        if (this.valence == Integer.MAX_VALUE) {
            Integer result = MenuUtil.showIntegerInputDialog(this.panel, bundle.getString("message"), bundle.getString("title"));
            if (result == null) {
                return;
            }
            this.valence = result;
        }
        if (this.atom.getValenceProp() != this.valence) {
            this.panel.getCanvas().setValence(this.atom, this.valence);
        }
    }
}

