/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.bond;

import chemaxon.marvin.sketch.swing.actions.AbstractSelectionToggleAction;
import chemaxon.marvin.sketch.swing.actions.bond.BitUtil;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import javax.swing.Action;

public final class BondReactingCenterAction
extends AbstractSelectionToggleAction
implements PopupActionProvider,
EnumeratedAction<Integer> {
    private int type;

    public BondReactingCenterAction() {
        super(true);
    }

    public Integer[] getValues() {
        return new Integer[]{4096, 8192, 12288, 16384, 20480, 0};
    }

    @Override
    public void setValue(Integer value) {
        this.type = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object value) {
        MoleculeGraph molecule = (MoleculeGraph)value;
        boolean l = this.getEditor().setHistorizeEnabled(false);
        try {
            for (int i = 0; i < molecule.getBondCount(); ++i) {
                MolBond bond = molecule.getBond(i);
                int flags = BitUtil.setInt(bond.getFlags(), 61440, this.type);
                this.getCanvas().setBondFlags(bond, flags);
            }
        }
        finally {
            this.getEditor().setHistorizeEnabled(l);
            this.getEditor().historize();
        }
    }

    @Override
    protected boolean isSelected(Object value) {
        if (!this.isEnabledFor(value)) {
            return false;
        }
        MoleculeGraph molecule = (MoleculeGraph)value;
        if (molecule.getBondCount() == 0) {
            return false;
        }
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            if (BitUtil.getInt(molecule.getBond(i).getFlags(), 61440) == this.type) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getSelection() {
        return this.getSelectionMolecule();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return o instanceof MoleculeGraph && ((MoleculeGraph)o).getBondCount() > 0;
    }

    @Override
    public Action createLocalInstance(Context context) {
        MSelectionDocument document = context.lookup(MSelectionDocument.class);
        if (document == null) {
            return null;
        }
        return this.createLocalInstance(document.getMainMoleculeGraph());
    }
}

