/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.bond;

import chemaxon.marvin.sketch.swing.SketchCanvas;
import chemaxon.marvin.sketch.swing.actions.AbstractDynamicAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import chemaxon.marvin.uif.util.swing.NullAction;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class LigandOrderAction
extends AbstractDynamicAction
implements PopupActionProvider {
    private static final Action[] EMPTY_ARRAY = new Action[]{new NullAction("(none applicable)", false)};

    @Override
    protected Action[] createActions(Object selection) {
        MolBond bond = (MolBond)selection;
        if (bond == null || !this.hasRGroup(bond)) {
            return EMPTY_ARRAY;
        }
        MolAtom firstAtom = bond.getAtom1().getRgroup() < bond.getAtom2().getRgroup() ? bond.getAtom1() : bond.getAtom2();
        ArrayList<Action> result = new ArrayList<Action>();
        this.addActions(firstAtom, bond, result);
        this.addActions(bond.getOtherAtom(firstAtom), bond, result);
        return result.toArray(new Action[result.size()]);
    }

    @Override
    protected Action[] updateActions(Action[] actions, Object selection) {
        return this.createActions(selection);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedBond();
    }

    @Override
    public Action createLocalInstance(Context context) {
        if (!this.getSelectionDocument().isEmpty() && this.getSelectedBond() != null && this.hasRGroup(this.getSelectedBond())) {
            return this;
        }
        MolBond aBond = LigandOrderAction.lookupBond(context);
        return aBond != null && this.hasRGroup(aBond) ? this.createLocalInstance(aBond) : null;
    }

    private void addActions(MolAtom atom, MolBond bond, List<Action> result) {
        if (!LigandOrderAction.isRGroup(atom)) {
            return;
        }
        LigandOrderAction.addSeparator(result);
        for (int i = 1; i <= atom.getBondCount(); ++i) {
            result.add(new Delegate(this.getCanvas(), atom, bond, i));
        }
    }

    private static void addSeparator(List<Action> result) {
        if (!result.isEmpty()) {
            result.add(null);
        }
    }

    private boolean hasRGroup(MolBond bond) {
        return LigandOrderAction.isRGroup(bond.getAtom1()) || LigandOrderAction.isRGroup(bond.getAtom2());
    }

    private static class Delegate
    extends AbstractAction {
        private final SketchCanvas canvas;
        private final MolBond bond;
        private final MolAtom atom;
        private final int order;

        public Delegate(SketchCanvas canvas, MolAtom atom, MolBond bond, int order) {
            this.atom = atom;
            this.bond = bond;
            this.order = order;
            this.canvas = canvas;
            this.putValue("Name", Delegate.getLabel(atom, order));
            AbstractExtendedAction.setRadio(this, true);
            AbstractExtendedAction.setSelected(this, atom.getLigandOrder(bond.getOtherAtom(atom)) == order);
        }

        private static String getLabel(MolAtom atom, int order) {
            String rNum = atom.getRgroup() == 0 ? "" : Integer.toString(atom.getRgroup());
            return "R" + rNum + " - " + order;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.canvas.setLigandOrder(this.atom, this.bond, this.order);
        }
    }
}

