/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.calculation;

import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.NMRPrediction;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.SketchPanelAware;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class HNMRAction
extends AbstractAction
implements SketchPanelAware {
    private SketchPanel parent;

    public HNMRAction(SketchPanel panel) {
        super("HNMR Prediction");
        this.parent = panel;
        this.putValue("MnemonicKey", 72);
        this.putValue("SwingLargeIconKey", new ImageIcon(HNMRAction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/h_24.png")));
        this.putValue("SmallIcon", new ImageIcon(HNMRAction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/h_16.png")));
    }

    public HNMRAction() {
        this((SketchPanel)null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NMRPrediction prediction = new NMRPrediction(this.parent.getMol(), NMRSpectrum.Nucleus.H1);
        if (prediction.getFrame() != null) {
            prediction.getFrame().setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.parent, "Cannot predict HNMR. Target molecule does not contain H atom.", "Warning", 2);
        }
    }

    @Override
    public void setSketchPanel(SketchPanel panel) {
        this.parent = panel;
    }
}

