/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.group;

import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MObject;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MRectanglePoint;
import javax.swing.Action;

public class EditSGroupAction
extends AbstractSelectionAction
implements PopupActionProvider {
    public EditSGroupAction() {
    }

    public EditSGroupAction(SketchPanel panel) {
        super(panel);
        this.stateChanged();
    }

    @Override
    protected void actionPerformed(Object selection) {
        if (selection instanceof MRectanglePoint) {
            Sgroup sgroup = this.getPanel().getEditor().findContainingSgroup((MBracket)((MRectanglePoint)selection).getParentRect());
            this.getPanel().openEditGroup(sgroup);
        } else if (selection instanceof MBracket) {
            MBracket bracket = (MBracket)selection;
            Sgroup sgroup = this.getPanel().getEditor().findContainingSgroup(bracket);
            if (sgroup != null) {
                this.getPanel().openEditGroup(sgroup);
            }
        } else if (selection instanceof MSelectionDocument) {
            MSelectionDocument document = (MSelectionDocument)selection;
            SgroupPO group = this.getEditor().getSgroupPO(document.getMainMoleculeGraph());
            if (group != null) {
                this.getPanel().doEditSgroup(group);
            }
        }
    }

    @Override
    protected Object getSelection() {
        if (this.getSelectedMObject() != null) {
            return this.getSelectedMObject();
        }
        return this.getSelectionDocument();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        if (o instanceof MObject) {
            return this.isEnabled((MObject)o);
        }
        if (o instanceof MSelectionDocument) {
            MSelectionDocument document = (MSelectionDocument)o;
            return this.isEnabled(document);
        }
        return false;
    }

    private boolean isEnabled(MObject object) {
        return object instanceof MRectanglePoint ? ((MRectanglePoint)object).getParentRect() instanceof MBracket && this.getPanel().getEditor().findContainingSgroup((MBracket)((MRectanglePoint)object).getParentRect()) != null : object instanceof MBracket;
    }

    private boolean isEnabled(MSelectionDocument document) {
        Sgroup sg;
        SgroupPO group = this.getEditor().getSgroupPO(document.getMainMoleculeGraph());
        Object obj = group == null ? null : group.getContainedObject();
        int id = -1;
        if (obj != null && obj instanceof Sgroup && (id = (sg = (Sgroup)obj).getType()) == 10) {
            id = sg.getParentSgroup() == null ? -1 : sg.getParentSgroup().getType();
        }
        return id != -1;
    }

    @Override
    public Action createLocalInstance(Context context) {
        MObject result = this.lookupContainedMObject(context);
        if (result != null) {
            return this.createLocalInstance(result);
        }
        MSelectionDocument selection = EditSGroupAction.lookupSelectionDocument(context);
        return EditSGroupAction.filterAction(this.createLocalInstance(selection));
    }
}

