/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.object;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSelectionAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MObject;
import chemaxon.struc.MolBond;
import java.io.Serializable;
import javax.swing.Action;

public class MoveObjectToBackAction
extends AbstractSelectionAction
implements PopupActionProvider {
    public MoveObjectToBackAction() {
    }

    public MoveObjectToBackAction(SketchPanel panel) {
        super(panel);
        this.stateChanged();
    }

    @Override
    protected void actionPerformed(Object selection) {
        if (selection instanceof MObject) {
            this.getCanvas().moveObjectToBack((MObject)selection);
        } else if (selection instanceof MolBond) {
            MolBond bond = (MolBond)selection;
            if (this.getEditor().canArrangeCrossingBond(bond, MolEditor.ARRANGE_BACK)) {
                this.getEditor().arrangeCrossingBond(bond, MolEditor.ARRANGE_BACK);
            }
        }
    }

    @Override
    protected Object getSelection() {
        if (this.getSelectedMObject() != null) {
            return this.getSelectedMObject();
        }
        return this.getSelectedBond();
    }

    @Override
    protected boolean isEnabledFor(Object o) {
        return o instanceof MObject || o instanceof MolBond && this.getEditor().getMolDim() == 2;
    }

    @Override
    public Action createLocalInstance(Context context) {
        Serializable result = this.lookupContainedMObject(context);
        if (result == null) {
            result = MoveObjectToBackAction.lookupBond(context);
        }
        return result != null ? this.createLocalInstance(result) : null;
    }
}

