/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.property;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractPropertyAction;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import java.awt.event.ActionEvent;

public abstract class AbstractImplicitHAction
extends AbstractPropertyAction {
    private static final String RENDERING = "rendering";
    private static final String IMPLICIT_H = "implicitH";
    private static final String CARBON_VISIBILITY = "carbonVisibility";
    private static final String[] PROPERTIES = new String[]{"rendering", "implicitH", "carbonVisibility"};
    private String level;

    public AbstractImplicitHAction(String level) {
        super(PROPERTIES);
        this.init(level);
    }

    public AbstractImplicitHAction(SketchPanel panel, String level) {
        super(panel, PROPERTIES);
        this.init(level);
        this.propertyChanged();
    }

    private void init(String level) {
        this.level = level;
        AbstractExtendedAction.setRadio(this, true);
    }

    protected boolean needVisibleCarbon() {
        return false;
    }

    private boolean isSelected() {
        return this.level.equals(this.getImplicitH());
    }

    private String getImplicitH() {
        String implicitH = this.getPanel().getImplicitH();
        if (this.isCarbonVisible() && ("all".equals(implicitH) || "heteroterm".equals(implicitH))) {
            return "hetero";
        }
        return implicitH;
    }

    @Override
    protected void propertyChanged() {
        this.setEnabled(this.getPanel().isImplicitHEnabled() && (!this.needVisibleCarbon() || !this.isCarbonVisible()));
        AbstractExtendedAction.setSelected(this, this.isEnabled() && this.isSelected());
    }

    private boolean isCarbonVisible() {
        return "off".equals(this.getPanel().getCarbonVisibility());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getPanel().setImplicitH(this.level);
    }
}

