/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.property;

import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractPropertyAction;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import java.awt.event.ActionEvent;

public abstract class AbstractRenderModeAction
extends AbstractPropertyAction {
    private static final String RENDERING = "rendering";
    private int mode;

    public AbstractRenderModeAction(SketchPanel panel, String modeStr) {
        super(panel, RENDERING);
        this.init(modeStr);
        this.propertyChanged();
    }

    public AbstractRenderModeAction(String modeStr) {
        super(RENDERING);
        this.init(modeStr);
    }

    private void init(String modeStr) {
        this.mode = AbstractRenderModeAction.findMode(modeStr);
        AbstractExtendedAction.setRadio(this, true);
    }

    private static int findMode(String modeStr) {
        for (int i = 0; i < DispOptConsts.RENDERING_STYLES.length; ++i) {
            if (!DispOptConsts.RENDERING_STYLES[i].equals(modeStr)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void propertyChanged() {
        AbstractExtendedAction.setSelected(this, this.mode != -1 && AbstractRenderModeAction.findMode(this.getPanel().getRendering()) == this.mode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getPanel().doSetRendering(this.mode);
    }
}

