/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.structure;

import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class CreateRgroupAttachmentAction
extends AbstractSketchModeAction {
    private MolAtom atom = new MolAtom(138);
    private Molecule mol;

    public CreateRgroupAttachmentAction() {
        this.atom.setRgroupAttachmentPointOrder(-1);
        this.mol = new Molecule();
        this.mol.add(this.atom);
    }

    @Override
    protected SketchMode createSketchMode() {
        return new AtomSM(this.getEditor(), this.atom);
    }

    @Override
    protected void update() {
        super.update();
        this.setEnabled(this.isAllowed());
    }

    private boolean isAllowed() {
        return this.getEditor().isAllowed(this.mol);
    }

    @Override
    protected boolean isModeSelected() {
        SketchMode editorMode = this.getEditor().getSketchMode();
        if (!(editorMode instanceof AtomSM)) {
            return false;
        }
        MolAtom smAtom = ((AtomSM)editorMode).getAtom();
        return Utils.equals(smAtom, this.atom) && this.atom.getRgroupAttachmentPointOrder() == smAtom.getRgroupAttachmentPointOrder();
    }
}

