/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.template;

import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.sketch.swing.actions.template.Utils;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class RadicalAction
extends AbstractSketchModeAction
implements EnumeratedAction<int[]> {
    protected MolAtom atom;
    protected Molecule mol;

    public int[][] getValues() {
        return new int[][]{{1, -2}, {0, -3}, {1, -3}};
    }

    @Override
    public void setValue(int[] value) {
        this.atom = RadicalAction.createRadical(value[0]);
        this.atom.setElectronProp(value[1]);
        this.mol = new Molecule();
        this.mol.add(this.atom);
    }

    protected static MolAtom createRadical(int flags) {
        MolAtom atom = new MolAtom(0);
        atom.setRadical(flags);
        return atom;
    }

    @Override
    protected SketchMode createSketchMode() {
        return new AtomSM(this.getEditor(), this.atom);
    }

    @Override
    protected void update() {
        super.update();
        this.setEnabled(this.isAllowed());
    }

    private boolean isAllowed() {
        return this.getEditor().isAllowed(this.mol);
    }

    @Override
    protected boolean isModeSelected() {
        SketchMode editorMode = this.getEditor().getSketchMode();
        if (!(editorMode instanceof AtomSM)) {
            return false;
        }
        MolAtom atom2 = ((AtomSM)editorMode).getAtom();
        return Utils.equals(atom2, this.atom) && this.atom.getValenceProp() == atom2.getValenceProp() && this.atom.hasQProps() == atom2.hasQProps() && this.atom.getRadical() == atom2.getRadical() && this.atom.getElectronProp() == atom2.getElectronProp();
    }
}

