/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.DocumentSettingsConstants;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.PagesActions;
import chemaxon.marvin.sketch.swing.SketchCanvas;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class DocumentSettings
implements CallbackIface,
ActionListener,
FocusListener,
ItemListener {
    private JDialog dialog = null;
    private SketchPanel sketchPanel;
    private Action okAction = this.createAction("ok");
    private Action cancelAction = this.createAction("cancel");
    private String timerTask = null;
    private JTextField rowCountTextField;
    private JTextField columnCountTextField;
    private JTextField leftTextField;
    private JTextField rightTextField;
    private JTextField topTextField;
    private JTextField bottomTextField;
    private boolean isValueProper = true;
    private MDocument document;
    private Molecule molecule = null;
    private PageSettings pageSettings = null;
    private SketchCanvas sketchCanvas = null;
    private JComboBox comboBox;
    private JCheckBox checkBox;
    private JTextField titleTextField;
    private static final ResourceBundle RESOURCES;
    public static final LookAndFeel DEFAULT_LOOKANDFEEL;

    private Action createAction(String id) {
        DelegatingAction result = new DelegatingAction(id, MolPanel.GRESOURCES.getString(id));
        result.addActionListener(this);
        return result;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)arg;
        } else if (method.equals("show")) {
            this.init();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.sketchPanel);
            this.timerTask = "show";
            Timer tmr = new Timer(20, this);
            tmr.setRepeats(false);
            tmr.start();
        } else if (method.equals("setMol")) {
            this.molecule = (Molecule)arg;
            this.document = this.molecule.getDocument();
            this.pageSettings = (PageSettings)this.document.getPageSettings().clone();
        } else if (method.equals("setDocument")) {
            this.document = (MDocument)arg;
            this.molecule = (Molecule)this.document.getMainMoleculeGraph();
            this.pageSettings = (PageSettings)this.document.getPageSettings().clone();
        } else if (method.equals("setSketchCanvas")) {
            this.sketchCanvas = (SketchCanvas)arg;
        }
        return null;
    }

    private void init() {
        this.dialog = this.sketchPanel.isParentWindowDialog() ? new JDialog(this.sketchPanel.getParentDialog()) : new JDialog(this.sketchPanel.getParentFrame());
        ResourceBundle rc = RESOURCES;
        this.dialog.setTitle(rc.getString("documentSettings"));
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.insets.bottom = 0;
        ++gbc.gridy;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbl.setConstraints(this.addSettingsPanel(), gbc);
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets.top = 2;
        gbc.insets.bottom = 1;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbl.setConstraints(this.addOkCancelPanel(), gbc);
    }

    private JPanel addSettingsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets.right = 10;
        gbc.insets.left = 10;
        JPanel sizePanel = this.createDocumentSizePanel();
        JPanel titlePanel = this.createTitlePanel();
        JPanel pageTypePanel = this.createDocumentTypePanel();
        JPanel gridPanel = this.createDocumentGridPanel();
        JPanel marginsPanel = this.createMarginsPanel();
        ++gbc.gridy;
        panel.add(titlePanel);
        gbl.setConstraints(titlePanel, gbc);
        ++gbc.gridy;
        panel.add(pageTypePanel);
        gbl.setConstraints(pageTypePanel, gbc);
        ++gbc.gridy;
        panel.add(gridPanel);
        gbl.setConstraints(gridPanel, gbc);
        ++gbc.gridy;
        panel.add(sizePanel);
        gbl.setConstraints(sizePanel, gbc);
        ++gbc.gridy;
        panel.add(marginsPanel);
        gbl.setConstraints(marginsPanel, gbc);
        this.dialog.getContentPane().add(panel);
        return panel;
    }

    private JPanel createTitlePanel() {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("documentTitle"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 5;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("title") + ":")), gbc);
        this.titleTextField = new JTextField(15);
        panel.add(this.titleTextField);
        if (this.molecule != null) {
            this.titleTextField.setText(this.molecule.getName());
        }
        this.titleTextField.addFocusListener(this);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.titleTextField, gbc);
        return panel;
    }

    private JPanel createMarginsPanel() {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("margins"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 5;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("left") + ":")), gbc);
        this.leftTextField = new JTextField(5);
        panel.add(this.leftTextField);
        this.leftTextField.setText(String.valueOf(this.pageSettings.getLeftMargin() / 4.2));
        this.leftTextField.addFocusListener(this);
        this.leftTextField.setEditable(this.pageSettings.isEnabled());
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.leftTextField, gbc);
        ++gbc.gridx;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("right") + ":")), gbc);
        this.rightTextField = new JTextField(5);
        panel.add(this.rightTextField);
        this.rightTextField.setText(String.valueOf(this.pageSettings.getRightMargin() / 4.2));
        this.rightTextField.addFocusListener(this);
        this.rightTextField.setEditable(this.pageSettings.isEnabled());
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.rightTextField, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("top") + ":")), gbc);
        this.topTextField = new JTextField(5);
        panel.add(this.topTextField);
        this.topTextField.setText(String.valueOf(this.pageSettings.getTopMargin() / -4.2));
        this.topTextField.addFocusListener(this);
        this.topTextField.setEditable(this.pageSettings.isEnabled());
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.topTextField, gbc);
        ++gbc.gridx;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("bottom") + ":")), gbc);
        this.bottomTextField = new JTextField(5);
        panel.add(this.bottomTextField);
        this.bottomTextField.setText(String.valueOf(this.pageSettings.getBottomMargin() / -4.2));
        this.bottomTextField.addFocusListener(this);
        this.bottomTextField.setEditable(this.pageSettings.isEnabled());
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.bottomTextField, gbc);
        return panel;
    }

    private Component addOkCancelPanel() {
        JPanel panel = new JPanel();
        this.dialog.getContentPane().add(panel);
        panel.add(new JButton(this.okAction));
        panel.add(new JButton(this.cancelAction));
        return panel;
    }

    private JPanel createDocumentTypePanel() {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("documentType"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 5;
        this.checkBox = new JCheckBox();
        this.checkBox.setText(rc.getString("multipageDocument"));
        this.checkBox.addItemListener(this);
        this.checkBox.setActionCommand("checkBox");
        this.checkBox.setSelected(this.pageSettings.isEnabled());
        panel.add(this.checkBox);
        gbl.setConstraints(this.checkBox, gbc);
        return panel;
    }

    private JPanel createDocumentGridPanel() {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("documentGrid"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 5;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("height") + ":")), gbc);
        this.rowCountTextField = new JTextField(5);
        panel.add(this.rowCountTextField);
        this.rowCountTextField.setText(String.valueOf(this.pageSettings.getRowCount()));
        this.rowCountTextField.addFocusListener(this);
        this.rowCountTextField.setEditable(this.pageSettings.isEnabled());
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.rowCountTextField, gbc);
        ++gbc.gridx;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("Settings.pages"))), gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("width") + ":")), gbc);
        this.columnCountTextField = new JTextField(5);
        panel.add(this.columnCountTextField);
        this.columnCountTextField.setText(String.valueOf(this.pageSettings.getColumnCount()));
        this.columnCountTextField.addFocusListener(this);
        this.columnCountTextField.setEditable(this.pageSettings.isEnabled());
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.columnCountTextField, gbc);
        ++gbc.gridx;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("Settings.pages"))), gbc);
        return panel;
    }

    private JPanel createDocumentSizePanel() {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("documentSize"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        gbl.setConstraints(panel.add(new JLabel(rc.getString("pageSize") + ":")), gbc);
        String[] sizeStrings = new String[]{rc.getString("LETTER"), rc.getString("A0"), rc.getString("A1"), rc.getString("A2"), rc.getString("A3"), rc.getString("A4"), rc.getString("A5"), rc.getString("B5")};
        this.comboBox = new JComboBox<String>(sizeStrings);
        if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[0]) {
            this.comboBox.setSelectedItem(rc.getString("LETTER"));
        } else if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[1]) {
            this.comboBox.setSelectedItem(rc.getString("A0"));
        } else if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[2]) {
            this.comboBox.setSelectedItem(rc.getString("A1"));
        } else if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[3]) {
            this.comboBox.setSelectedItem(rc.getString("A2"));
        } else if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[4]) {
            this.comboBox.setSelectedItem(rc.getString("A3"));
        } else if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[5]) {
            this.comboBox.setSelectedItem(rc.getString("A4"));
        } else if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[6]) {
            this.comboBox.setSelectedItem(rc.getString("A5"));
        } else if (this.pageSettings.getWidth() == DocumentSettingsConstants.MOL_XPOS[7]) {
            this.comboBox.setSelectedItem(rc.getString("B5"));
        }
        this.comboBox.addActionListener(this);
        panel.add(this.comboBox);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridx;
        gbl.setConstraints(this.comboBox, gbc);
        return panel;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        Object src = event.getSource();
        this.isValueProper = true;
        if (src instanceof JTextField) {
            JTextField t = (JTextField)src;
            double x = -1.0;
            if (t == this.rowCountTextField || t == this.columnCountTextField) {
                try {
                    x = Integer.valueOf(t.getText()).intValue();
                }
                catch (NumberFormatException ex) {}
            } else if (t == this.leftTextField || t == this.rightTextField || t == this.topTextField || t == this.bottomTextField) {
                try {
                    x = Double.valueOf(t.getText());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (t == this.rowCountTextField || t == this.columnCountTextField || t == this.leftTextField || t == this.rightTextField || t == this.topTextField || t == this.bottomTextField) {
                if (x >= 0.0) {
                    if (t == this.rowCountTextField) {
                        this.pageSettings.setRowCount((int)x);
                        this.rowCountTextField.setText(String.valueOf((int)x));
                    } else if (t == this.columnCountTextField) {
                        this.pageSettings.setColumnCount((int)x);
                        this.columnCountTextField.setText(String.valueOf((int)x));
                    } else if (t == this.leftTextField) {
                        this.pageSettings.setLeftMargin(x * 4.2);
                        this.leftTextField.setText(String.valueOf(x));
                    } else if (t == this.rightTextField) {
                        this.pageSettings.setRightMargin(x * 4.2);
                        this.rightTextField.setText(String.valueOf(x));
                    } else if (t == this.topTextField) {
                        this.pageSettings.setTopMargin(x * -4.2);
                        this.topTextField.setText(String.valueOf(x));
                    } else if (t == this.bottomTextField) {
                        this.pageSettings.setBottomMargin(x * -4.2);
                        this.bottomTextField.setText(String.valueOf(x));
                    }
                } else {
                    this.isValueProper = false;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object t = ev.getSource();
        if (t instanceof Timer) {
            if (this.timerTask.equals("show")) {
                this.dialog.setVisible(true);
            }
        } else if (t instanceof Action) {
            String cmd = ev.getActionCommand();
            if (cmd.equals("ok")) {
                MoleculeGraph m;
                if (this.titleTextField.getText() != null && (m = this.document.getMainMoleculeGraph()) != null && m instanceof Molecule) {
                    ((Molecule)m).setName(this.titleTextField.getText());
                }
                if (this.isValueProper) {
                    ResourceBundle rc;
                    String selectedPaper = (String)this.comboBox.getSelectedItem();
                    if (selectedPaper.equals((rc = RESOURCES).getString("LETTER"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[0]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[0]);
                    } else if (selectedPaper.equals(rc.getString("A0"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[1]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[1]);
                    } else if (selectedPaper.equals(rc.getString("A1"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[2]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[2]);
                    } else if (selectedPaper.equals(rc.getString("A2"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[3]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[3]);
                    } else if (selectedPaper.equals(rc.getString("A3"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[4]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[4]);
                    } else if (selectedPaper.equals(rc.getString("A4"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[5]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[5]);
                    } else if (selectedPaper.equals(rc.getString("A5"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[6]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[6]);
                    } else if (selectedPaper.equals(rc.getString("B5"))) {
                        this.pageSettings.setWidth(DocumentSettingsConstants.MOL_XPOS[7]);
                        this.pageSettings.setHeight(DocumentSettingsConstants.MOL_YPOS[7]);
                    }
                    this.document.setPageSettings(this.pageSettings);
                    this.dialog.setVisible(false);
                    this.sketchCanvas.repaint();
                    this.sketchPanel.setScrollbars();
                    this.sketchPanel.updateStatusBar();
                    this.sketchPanel.updatePagesMenu();
                } else {
                    PagesActions.showErrorMessageDialog(this.dialog);
                }
            } else if (cmd.equals("cancel")) {
                this.dialog.setVisible(false);
            } else if (cmd.equals("pageSetup")) {
                // empty if block
            }
            this.isValueProper = true;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.checkBox) {
            if (e.getStateChange() == 2) {
                this.pageSettings.setEnabled(false);
                if (this.rowCountTextField != null) {
                    this.rowCountTextField.setEditable(false);
                }
                if (this.columnCountTextField != null) {
                    this.columnCountTextField.setEditable(false);
                }
                if (this.leftTextField != null) {
                    this.leftTextField.setEditable(false);
                }
                if (this.rightTextField != null) {
                    this.rightTextField.setEditable(false);
                }
                if (this.topTextField != null) {
                    this.topTextField.setEditable(false);
                }
                if (this.bottomTextField != null) {
                    this.bottomTextField.setEditable(false);
                }
            }
            if (e.getStateChange() == 1) {
                this.pageSettings.setEnabled(true);
                if (this.pageSettings.getColumnCount() == 0) {
                    this.pageSettings.setColumnCount(1);
                }
                if (this.pageSettings.getRowCount() == 0) {
                    this.pageSettings.setRowCount(1);
                }
                this.setField(this.rowCountTextField, String.valueOf(this.pageSettings.getRowCount()));
                this.setField(this.columnCountTextField, String.valueOf(this.pageSettings.getColumnCount()));
                this.setField(this.leftTextField, String.valueOf(this.pageSettings.getLeftMargin() / 4.2));
                this.setField(this.rightTextField, String.valueOf(this.pageSettings.getRightMargin() / 4.2));
                this.setField(this.topTextField, String.valueOf(this.pageSettings.getTopMargin() / -4.2));
                this.setField(this.bottomTextField, String.valueOf(this.pageSettings.getBottomMargin() / -4.2));
            }
        }
    }

    private void setField(JTextField textField, String text) {
        if (textField != null) {
            textField.setText(text);
            textField.setEditable(true);
        }
    }

    static {
        DEFAULT_LOOKANDFEEL = UIManager.getLookAndFeel();
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(DocumentSettings.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("DocumentSettings.properties not found");
        }
        RESOURCES = rc;
    }
}

