/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.sketch.swing.modules.FilteredTreeModel;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class FilterUtil
implements DocumentListener {
    private JTextComponent component;
    private JTree tree;
    private FilteredTreeModel filteredModel;
    private FilterList filterList;

    public FilterUtil(JTextComponent component, JTree tree) {
        this.component = component;
        this.tree = tree;
        this.filterList = new FilterList(tree.getModel());
        this.filteredModel = new FilteredTreeModel(tree.getModel());
        component.getDocument().addDocumentListener(this);
        tree.setModel(this.filteredModel);
    }

    public static FilteredTreeModel.Filter createTextFilter(String text) {
        return new TextFilter(text);
    }

    public static void bind(JTree tree, JTextComponent component) {
        FilterUtil util = new FilterUtil(component, tree);
        component.getDocument().addDocumentListener(util);
        tree.setModel(util.filteredModel);
        tree.putClientProperty(FilterUtil.class, util);
    }

    public static void release(JTree tree) {
        FilterUtil util = (FilterUtil)tree.getClientProperty(FilterUtil.class);
        if (util == null) {
            return;
        }
        tree.putClientProperty(FilterUtil.class, null);
        util.component.getDocument().removeDocumentListener(util);
        tree.setModel(util.filterList.getDefaultModel());
    }

    private void updateFilter() {
        TreePath path = this.tree.getSelectionPath();
        this.filterList.setFilter(this.component.getText());
        this.filteredModel.setDelegate(this.filterList.getModel());
        if (this.component.getText().length() != 0) {
            this.expandTree();
        }
        if (!(path != null && this.isPathExists(path) || this.component.getText().length() <= 0)) {
            path = FilterUtil.firstNode(this.tree.getModel());
        }
        if (path != null && this.isPathExists(path)) {
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    private void expandTree() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private boolean isPathExists(TreePath path) {
        if (!path.getPathComponent(0).equals(this.filteredModel.getRoot())) {
            return false;
        }
        for (int i = 1; i < path.getPathCount(); ++i) {
            if (this.filteredModel.getIndexOfChild(path.getPathComponent(i - 1), path.getPathComponent(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private static TreePath firstNode(TreeModel model) {
        if (model.getRoot() == null) {
            return null;
        }
        LinkedList<TreePath> list = new LinkedList<TreePath>();
        list.add(new TreePath(model.getRoot()));
        while (!list.isEmpty()) {
            TreePath path = (TreePath)list.getFirst();
            if (model.isLeaf(path.getLastPathComponent())) {
                return path;
            }
            int n = model.getChildCount(path.getLastPathComponent());
            for (int i = n - 1; i >= 0; --i) {
                list.addFirst(path.pathByAddingChild(model.getChild(path.getLastPathComponent(), i)));
            }
        }
        return null;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateFilter();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateFilter();
    }

    private static class TextFilter
    implements FilteredTreeModel.Filter {
        private String text;

        public TextFilter(String text) {
            if (text == null) {
                throw new NullPointerException();
            }
            this.text = text;
        }

        @Override
        public boolean include(Object o) {
            return this.startsWithIgnoreCase(o);
        }

        private boolean startsWithIgnoreCase(Object o) {
            String str = o.toString();
            if (str.length() < this.text.length()) {
                return false;
            }
            int i = this.text.length();
            while (--i >= 0) {
                if (Character.toLowerCase(str.charAt(i)) == Character.toLowerCase(this.text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TextFilter)) {
                return false;
            }
            TextFilter filter = (TextFilter)o;
            return this.text.equals(filter.text);
        }
    }

    private static class FilterList {
        private LinkedList models = new LinkedList();
        private String lastFilter = "";

        private FilterList(TreeModel model) {
            this.models.add(model);
        }

        private void setFilter(String newFilter) {
            while (!newFilter.startsWith(this.lastFilter)) {
                this.removeLastFilter();
            }
            for (int i = this.lastFilter.length(); i < newFilter.length(); ++i) {
                this.addFilter(newFilter.substring(0, i + 1));
            }
        }

        private TreeModel getDefaultModel() {
            return (TreeModel)this.models.getFirst();
        }

        private TreeModel getModel() {
            return (TreeModel)this.models.getLast();
        }

        private void removeLastFilter() {
            this.lastFilter = this.lastFilter.substring(0, this.lastFilter.length() - 1);
            this.models.removeLast();
        }

        private void addFilter(String newFilter) {
            this.lastFilter = newFilter;
            FilteredTreeModel model = new FilteredTreeModel((TreeModel)this.models.getLast());
            model.setFilter(new TextFilter(newFilter));
            this.models.add(model);
        }
    }
}

