/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class FilteredTreeModel
implements TreeModel {
    private Filter filter;
    private TreeModel delegate;
    private DefaultMutableTreeNode rootNode;
    private Map modelToFilteredMap;
    private EventListenerList listenerList;

    public FilteredTreeModel(TreeModel delegate) {
        this.delegate = delegate;
        this.listenerList = new EventListenerList();
    }

    public void setDelegate(TreeModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.delegate = model;
        this.filter();
        this.fireTreeStructureChanged();
    }

    private void fireTreeStructureChanged() {
        if (this.getRoot() == null) {
            this.fireTreeStructureChanged(null);
        } else {
            this.fireTreeStructureChanged(new TreePath(this.getRoot()));
        }
    }

    public void setFilter(Filter filter) {
        if (this.filter == filter || this.filter != null && this.filter.equals(filter)) {
            return;
        }
        this.filter = filter;
        this.filter();
        this.fireTreeStructureChanged();
    }

    private void filter() {
        if (this.filter == null || this.delegate.getRoot() == null) {
            this.rootNode = null;
            if (this.modelToFilteredMap != null) {
                this.modelToFilteredMap.clear();
            }
            this.modelToFilteredMap = null;
            return;
        }
        this.modelToFilteredMap = new HashMap();
        this.visit(new TreePath(this.delegate.getRoot()));
        this.rootNode = this.nodeForObject(this.delegate.getRoot());
    }

    private void visit(TreePath path) {
        Object o = path.getLastPathComponent();
        if (this.filter.include(o)) {
            this.ensurePathExists(path);
        }
        for (int i = 0; i < this.delegate.getChildCount(o); ++i) {
            this.visit(path.pathByAddingChild(this.delegate.getChild(o, i)));
        }
    }

    private DefaultMutableTreeNode ensurePathExists(TreePath path) {
        DefaultMutableTreeNode result;
        Object o = path.getLastPathComponent();
        if (!this.hasNode(o)) {
            result = this.createNode(o);
            if (path.getParentPath() != null) {
                this.ensurePathExists(path.getParentPath()).add(result);
            }
        } else {
            result = this.nodeForObject(o);
        }
        return result;
    }

    private boolean hasNode(Object o) {
        return this.modelToFilteredMap.containsKey(o);
    }

    private DefaultMutableTreeNode createNode(Object o) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(o);
        this.modelToFilteredMap.put(o, result);
        return result;
    }

    private DefaultMutableTreeNode nodeForObject(Object o) {
        return (DefaultMutableTreeNode)this.modelToFilteredMap.get(o);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.filter != null) {
            return ((DefaultMutableTreeNode)this.nodeForObject(parent).getChildAt(index)).getUserObject();
        }
        return this.delegate.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.filter != null) {
            return this.nodeForObject(parent).getChildCount();
        }
        return this.delegate.getChildCount(parent);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (this.filter != null) {
            DefaultMutableTreeNode parentNode = this.nodeForObject(parent);
            DefaultMutableTreeNode childNode = this.nodeForObject(child);
            if (parentNode == null || childNode == null) {
                return -1;
            }
            return parentNode.getIndex(childNode);
        }
        return this.delegate.getIndexOfChild(parent, child);
    }

    @Override
    public Object getRoot() {
        if (this.filter != null) {
            return this.rootNode != null ? this.rootNode.getUserObject() : null;
        }
        return this.delegate.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.delegate.isLeaf(node);
    }

    private void fireTreeStructureChanged(TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public static interface Filter {
        public boolean include(Object var1);
    }
}

