/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.FormatMoleculePanel;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.ColorSetUtil;
import chemaxon.marvin.util.SwingUtil;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class FormatMoleculeDialog
implements CallbackIface,
ActionListener {
    private static final String CANCEL_COMMAND = "cancel";
    private static final String OK_COMMAND = "ok";
    private static final ResourceBundle RESOURCES;
    private SketchPanel sketchPanel;
    private Object molecule = null;
    private JDialog dialog = null;
    private FormatMoleculePanel moleculePanel;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)arg;
        } else if (method.equals("setMolecule")) {
            this.molecule = arg;
        } else if (method.equals("show")) {
            this.show();
        }
        return null;
    }

    public void show() {
        this.init();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.sketchPanel);
        this.dialog.setVisible(true);
    }

    private void init() {
        this.dialog = this.sketchPanel.isParentWindowDialog() ? new JDialog(this.sketchPanel.getParentDialog()) : new JDialog(this.sketchPanel.getParentFrame());
        this.dialog.addWindowListener(new WindowHandler(this.sketchPanel));
        ResourceBundle rc = RESOURCES;
        this.dialog.setTitle(rc.getString("FormatMoleculeDialog"));
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        this.moleculePanel = new FormatMoleculePanel(this.sketchPanel, this.molecule, this.dialog);
        gbl.setConstraints(contentPane.add(this.moleculePanel), gbc);
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets.top = 2;
        gbc.insets.bottom = 1;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbl.setConstraints(this.addOkCancelPanel(), gbc);
    }

    private JPanel addOkCancelPanel() {
        JPanel panel = new JPanel();
        this.dialog.getContentPane().add(panel);
        panel.add(this.createButton(OK_COMMAND));
        panel.add(this.createButton(CANCEL_COMMAND));
        return panel;
    }

    private JButton createButton(String id) {
        JButton result = new JButton(new DelegatingAction(id, MolPanel.GRESOURCES.getString(id)));
        result.addActionListener(this);
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (OK_COMMAND.equals(ev.getActionCommand())) {
            this.apply();
        } else if (CANCEL_COMMAND.equals(ev.getActionCommand())) {
            this.cancel();
        }
    }

    private void cancel() {
        this.dialog.setVisible(false);
    }

    private void apply() {
        this.dialog.setVisible(false);
        this.sketchPanel.getEditor().historize();
        this.sketchPanel.repaint();
        this.moleculePanel.applyChanges();
        ColorSetUtil.copyDefaultSetColor(this.sketchPanel.getEditor().getDocument(), this.sketchPanel.getEditor().getPiece());
        this.sketchPanel.getEditor().historize();
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(FormatMoleculePanel.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("FormatMoleculePanel.properties not found");
        }
        RESOURCES = rc;
    }

    private class WindowHandler
    extends WindowAdapter {
        private final SketchPanel pane;

        public WindowHandler(SketchPanel pane) {
            this.pane = pane;
        }

        @Override
        public void windowClosing(WindowEvent ignored) {
            this.pane.requestFocus();
        }
    }
}

