/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.FontAttrPanel;
import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.InstallStyles;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.graphics.MFont;
import chemaxon.util.DotfileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FormatMoleculePanel
extends JPanel
implements CallbackIface,
ActionListener,
FocusListener {
    private static final ResourceBundle RESOURCES;
    private SketchPanel sketchPanel;
    private JDialog dialog = null;
    private SelectionMolecule selMol;
    private JRadioButton selRB;
    private JRadioButton defRB;
    private JRadioButton allRB;
    private JButton loadButton;
    private JButton saveButton;
    private JButton resetToDefaultButton;
    private JPanel bondPanel;
    private FontAttrPanel atomFontPanel;
    private String defaultFontName;
    private int defaultFontStyle;
    private double defaultFontSizeVal;
    private double bondThicknessVal;
    private double defaultBondTVal;
    private JTextField bondThicknessTF;
    private JLabel bondThicknessLabel;
    private Color defaultColorVal;
    private JButton bondcolorButton;
    private JButton bondResetButton;
    private JLabel bondcolorLabel;
    private Color bondcolorVal;
    private Color defaultBondcolorVal;
    private boolean bondcolorSet = false;
    private boolean isResetToDefault = false;

    public FormatMoleculePanel(SketchPanel sp, Object arg, JDialog pdialog) {
        this.sketchPanel = sp;
        if (arg instanceof SelectionMolecule) {
            this.selMol = (SelectionMolecule)arg;
        } else if (arg instanceof MolAtom) {
            this.selMol = new SelectionMolecule();
            this.selMol.add((MolAtom)arg);
        } else if (arg instanceof MolBond) {
            this.selMol = new SelectionMolecule();
            this.selMol.add((MolBond)arg);
        } else {
            this.selMol = new SelectionMolecule();
        }
        this.dialog = pdialog;
        this.init();
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("loadAttrPanels") && arg != null) {
            double thickness;
            Object[] args = (Object[])arg;
            String attr = (String)args[0];
            this.atomFontPanel.setSelectedFontFamily(attr);
            attr = (String)args[1];
            this.atomFontPanel.setSelectedStyleStr(attr);
            double size = ((Double)args[2]).intValue();
            this.atomFontPanel.setSelectedSize(size);
            if (args[3] != null) {
                Color atomColor = null;
                if (args[3] instanceof String) {
                    atomColor = Color.getColor((String)args[3]);
                } else if (args[3] instanceof Integer) {
                    int c = (Integer)args[3];
                    atomColor = new Color(c);
                }
                this.atomFontPanel.setTextColorProp(atomColor);
            } else {
                this.atomFontPanel.setTextColorProp(null);
            }
            this.bondThicknessVal = thickness = ((Double)args[4]).doubleValue();
            this.bondThicknessTF.setText(String.valueOf(thickness));
            if (args[5] != null) {
                Color bondColor = null;
                if (args[5] instanceof String) {
                    bondColor = Color.getColor((String)args[5]);
                } else if (args[5] instanceof Integer) {
                    int c = (Integer)args[5];
                    bondColor = new Color(c);
                }
                this.setBondColorProp(bondColor);
            } else {
                this.setBondColorProp(null);
            }
        }
        return null;
    }

    private void init() {
        for (Container parent = this.sketchPanel; parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        FormatMoleculePanel contentPane = this;
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.top = 2;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.insets.bottom = 1;
        ++gbc.gridy;
        gbc.anchor = 18;
        JPanel mainPanel = new JPanel();
        GridBagLayout mgbl = new GridBagLayout();
        mainPanel.setLayout(mgbl);
        GridBagConstraints mgbc = SwingUtil.createTopLeftConstraints();
        mgbc.weightx = 0.0;
        mgbc.weighty = 0.0;
        mgbc.insets.top = 2;
        mgbc.insets.left = 5;
        mgbc.insets.right = 5;
        mgbc.insets.bottom = 1;
        ++mgbc.gridy;
        mgbc.anchor = 18;
        JPanel panel = new JPanel();
        GridBagLayout pgbl = new GridBagLayout();
        panel.setLayout(pgbl);
        GridBagConstraints pgbc = SwingUtil.createTopLeftConstraints();
        pgbc.fill = 1;
        pgbc.insets.top = 8;
        pgbc.insets.bottom = 0;
        pgbc.weightx = 1.0;
        pgbc.weighty = 1.0;
        boolean isSelMol = this.selMol != null && !this.selMol.isEmpty();
        this.selRB = this.createRadioButton("Selected", isSelMol, "select", "SelectedText");
        panel.add(this.selRB);
        ++pgbc.gridy;
        pgbl.setConstraints(this.selRB, pgbc);
        this.selRB.setEnabled(isSelMol);
        this.defRB = this.createRadioButton("Default", !isSelMol, "default", "DefaultText");
        panel.add(this.defRB);
        ++pgbc.gridy;
        pgbl.setConstraints(this.defRB, pgbc);
        mainPanel.add(panel);
        mgbl.setConstraints(panel, mgbc);
        JPanel allpanel = new JPanel();
        GridBagLayout allgbl = new GridBagLayout();
        allpanel.setLayout(allgbl);
        GridBagConstraints allgbc = SwingUtil.createTopLeftConstraints();
        allgbc.fill = 1;
        allgbc.insets.right = 15;
        this.allRB = this.createRadioButton("All", false, "all", "AllText");
        allpanel.add(this.allRB);
        allgbl.setConstraints(this.allRB, allgbc);
        ++allgbc.gridx;
        allgbl.setConstraints(this.addLoadSavePanel(allpanel), allgbc);
        mainPanel.add(allpanel);
        mgbc.insets.top = 5;
        ++mgbc.gridy;
        mgbl.setConstraints(allpanel, mgbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.selRB);
        group.add(this.defRB);
        group.add(this.allRB);
        mgbc.insets.top = 13;
        ++mgbc.gridy;
        JPanel moleculePanel = this.createMoleculePanel();
        mgbl.setConstraints(moleculePanel, mgbc);
        mainPanel.add(moleculePanel);
        contentPane.add(mainPanel);
        gbl.setConstraints(contentPane, gbc);
    }

    private JRadioButton createRadioButton(String text, boolean selected, String cmd, String toolTipID) {
        JRadioButton rb = new JRadioButton(RESOURCES.getString(text), selected);
        rb.setActionCommand(cmd);
        rb.addActionListener(this);
        rb.setToolTipText(RESOURCES.getString(toolTipID));
        return rb;
    }

    private JPanel addLoadSavePanel(JPanel mpanel) {
        JPanel panel = new JPanel();
        mpanel.add(panel);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        gbc.fill = 1;
        gbc.insets.left = 20;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        Action loadAction = this.createAction("load", RESOURCES.getString("LoadStyle"));
        Action saveAction = this.createAction("save", RESOURCES.getString("SaveStyle"));
        saveAction.setEnabled(!Environment.UNTRUSTED);
        this.loadButton = new JButton(loadAction);
        gbl.setConstraints(panel.add(this.loadButton), gbc);
        this.loadButton.setToolTipText(RESOURCES.getString("LoadButtonText"));
        ++gbc.gridx;
        this.saveButton = new JButton(saveAction);
        gbl.setConstraints(panel.add(this.saveButton), gbc);
        this.saveButton.setToolTipText(RESOURCES.getString("SaveButtonText"));
        if (this.selRB.isSelected() || this.defRB.isSelected()) {
            this.loadButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        } else {
            this.loadButton.setEnabled(!Environment.UNTRUSTED);
            this.saveButton.setEnabled(!Environment.UNTRUSTED);
        }
        return panel;
    }

    private Action createAction(String id, String label) {
        DelegatingAction result = new DelegatingAction(id, label);
        result.addActionListener(this);
        return result;
    }

    private JPanel createMoleculePanel() {
        JPanel atomPanel;
        ResourceBundle rc = RESOURCES;
        JPanel mPanel = SwingUtil.createSubPanel(rc.getString("Molecule"));
        GridBagLayout molgbl = new GridBagLayout();
        mPanel.setLayout(molgbl);
        GridBagConstraints molgbc = SwingUtil.createTopLeftConstraints();
        molgbc.fill = 1;
        molgbc.insets.right = 5;
        molgbc.insets.left = 5;
        molgbc.insets.bottom = 5;
        if (this.selMol.isBond()) {
            atomPanel = this.createAtomsLabelPanel(false);
            this.bondPanel = this.createBondsPanel(true);
        } else if (this.selMol.isAtom()) {
            atomPanel = this.createAtomsLabelPanel(true);
            this.bondPanel = this.createBondsPanel(false);
            this.setBondPanelEnabled(false);
        } else {
            atomPanel = this.createAtomsLabelPanel(true);
            this.bondPanel = this.createBondsPanel(true);
        }
        ++molgbc.gridy;
        molgbl.setConstraints(atomPanel, molgbc);
        mPanel.add(atomPanel);
        molgbc.insets.top = 3;
        ++molgbc.gridy;
        molgbl.setConstraints(this.bondPanel, molgbc);
        mPanel.add(this.bondPanel);
        Action resetAction = this.createAction("resetToDefault", RESOURCES.getString("ResetToDefault"));
        ++molgbc.gridy;
        molgbc.fill = 0;
        molgbc.anchor = 13;
        molgbc.insets.right = 5;
        this.resetToDefaultButton = new JButton(resetAction);
        molgbl.setConstraints(mPanel.add(this.resetToDefaultButton), molgbc);
        this.resetToDefaultButton.setToolTipText(RESOURCES.getString("ResetToDefaultButtonText"));
        return mPanel;
    }

    private JPanel createAtomsLabelPanel(boolean isThereAtom) {
        ResourceBundle rc = RESOURCES;
        if (isThereAtom) {
            this.initDefaultFonts(!this.selMol.isEmpty());
            this.initDefaultColor(true, !this.selMol.isEmpty());
        }
        this.atomFontPanel = new FontAttrPanel(rc.getString("Atoms"), 2, this.defaultFontName, this.defaultFontStyle, (int)this.defaultFontSizeVal, this.defaultColorVal, 0, 0, null);
        this.atomFontPanel.setFontFamilyLabel(rc.getString("baseFontLabel"));
        this.atomFontPanel.setSizeLabel(rc.getString("fontScaleLabel"));
        this.atomFontPanel.setSizeToolTip(rc.getString("fontScaleToolTip"));
        if (!isThereAtom) {
            this.atomFontPanel.setPanelEnabled(false);
        }
        return this.atomFontPanel;
    }

    private JPanel createBondsPanel(boolean isThereBond) {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("Bonds"));
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        gbc.fill = 1;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(panel.add(this.createBondsThicknessPanel(isThereBond)), gbc);
        ++gbc.gridx;
        gbl.setConstraints(panel.add(this.createBondsColorsPanel(isThereBond)), gbc);
        return panel;
    }

    private JPanel createBondsThicknessPanel(boolean isThereBond) {
        if (isThereBond) {
            this.initDefaultBondThickness(!this.selMol.isEmpty());
        }
        ResourceBundle rc = RESOURCES;
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        this.bondThicknessLabel = new JLabel(rc.getString("Thickness"));
        gbl.setConstraints(panel.add(this.bondThicknessLabel), gbc);
        this.bondThicknessTF = new JTextField(5);
        panel.add(this.bondThicknessTF);
        this.bondThicknessTF.setText(String.valueOf(this.bondThicknessVal));
        this.bondThicknessTF.addFocusListener(this);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbl.setConstraints(this.bondThicknessTF, gbc);
        return panel;
    }

    private JPanel createBondsColorsPanel(boolean isThereBond) {
        if (isThereBond) {
            this.initDefaultColor(false, !this.selMol.isEmpty());
        }
        ResourceBundle rc = RESOURCES;
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        this.bondcolorLabel = new JLabel(rc.getString("Colors"));
        gbl.setConstraints(panel.add(this.bondcolorLabel), gbc);
        ++gbc.gridx;
        this.bondcolorButton = FontAttrPanel.createColorChooser(this, "bondcolor", this.bondcolorVal);
        this.bondcolorSet = false;
        gbl.setConstraints(panel.add(this.bondcolorButton), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.bondResetButton = this.createResetButton("bondreset", "colorResetToolTip");
        gbl.setConstraints(panel.add(this.bondResetButton), gbc);
        return panel;
    }

    private void setBondPanelEnabled(boolean enabled) {
        ResourceBundle rc = RESOURCES;
        this.bondPanel.setEnabled(enabled);
        if (!enabled) {
            this.bondPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, rc.getString("Bonds"), 4, 2, null, Color.gray), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        } else {
            SwingUtil.decorateSubPanel(this.bondPanel, rc.getString("Bonds"));
        }
        this.bondThicknessLabel.setEnabled(enabled);
        this.bondThicknessTF.setEnabled(enabled);
        this.bondcolorButton.setEnabled(enabled);
        this.bondcolorLabel.setEnabled(enabled);
        this.bondResetButton.setEnabled(enabled);
    }

    private void initDefaultFonts(boolean selectedItems) {
        UserSettings settings = this.sketchPanel.getUserSettings();
        MDocument mdoc = this.sketchPanel.getEditor().getDocument();
        this.defaultFontName = null;
        this.defaultFontStyle = -1;
        this.defaultFontSizeVal = 0.0;
        if (selectedItems && !this.selMol.isEmpty()) {
            int i;
            MolAtom[] atomArr = this.selMol.getAtomArray();
            int setNo = atomArr[0].getSetSeq();
            boolean inSet = true;
            for (i = 1; inSet && i < atomArr.length; ++i) {
                if (atomArr[i].getSetSeq() == setNo) continue;
                inSet = false;
            }
            if (inSet) {
                if (mdoc.getAtomSetFont(setNo) != null) {
                    this.defaultFontName = mdoc.getAtomSetFont(setNo).getFamily();
                    this.defaultFontStyle = mdoc.getAtomSetFont(setNo).getStyle();
                    this.defaultFontSizeVal = mdoc.getAtomSetFont(setNo).getSizeDouble();
                } else {
                    this.defaultFontName = FormatMoleculePanel.fontName(settings.getAtomFont());
                    this.defaultFontStyle = 0;
                    this.defaultFontSizeVal = 12.0 * (settings.getAtomSize() / 0.4);
                }
            } else {
                double fs;
                int ft;
                String fn;
                int[] setNoArr = new int[atomArr.length];
                setNoArr[0] = atomArr[i - 1].getSetSeq();
                int n = 1;
                for (int j = i; j < atomArr.length; ++j) {
                    inSet = false;
                    for (int k = 0; !inSet && k < n; ++k) {
                        if (atomArr[j].getSetSeq() != setNoArr[k]) continue;
                        inSet = true;
                    }
                    if (inSet) continue;
                    setNoArr[n] = atomArr[j].getSetSeq();
                    ++n;
                }
                if (mdoc.getAtomSetFont(setNo) != null) {
                    fn = mdoc.getAtomSetFont(setNo).getFamily();
                    ft = mdoc.getAtomSetFont(setNo).getStyle();
                    fs = mdoc.getAtomSetFont(setNo).getSizeDouble();
                } else {
                    fn = FormatMoleculePanel.fontName(settings.getAtomFont());
                    ft = 0;
                    fs = (int)(12.0 * (settings.getAtomSize() / 0.4));
                }
                boolean sameFN = true;
                boolean sameFT = true;
                boolean sameFS = true;
                for (int j = 0; (sameFN || sameFT || sameFS) && j < n; ++j) {
                    int k = setNoArr[j];
                    if (mdoc.getAtomSetFont(k) != null) {
                        if (!fn.equals(mdoc.getAtomSetFont(k).getFamily())) {
                            sameFN = false;
                        }
                        if (ft != mdoc.getAtomSetFont(k).getStyle()) {
                            sameFT = false;
                        }
                        if (fs == mdoc.getAtomSetFont(k).getSizeDouble()) continue;
                        sameFS = false;
                        continue;
                    }
                    if (!fn.equals(FormatMoleculePanel.fontName(settings.getAtomFont()))) {
                        sameFN = false;
                    }
                    if (ft != 0) {
                        sameFT = false;
                    }
                    if (fs == 12.0 * (settings.getAtomSize() / 0.4)) continue;
                    sameFS = false;
                }
                if (sameFN) {
                    this.defaultFontName = fn;
                }
                if (sameFT) {
                    this.defaultFontStyle = ft;
                }
                if (sameFS) {
                    this.defaultFontSizeVal = fs;
                }
            }
        } else if (!selectedItems) {
            if (mdoc.getAtomSetFont(0) != null) {
                this.defaultFontName = mdoc.getAtomSetFont(0).getFamily();
                this.defaultFontStyle = mdoc.getAtomSetFont(0).getStyle();
                this.defaultFontSizeVal = mdoc.getAtomSetFont(0).getSizeDouble();
            } else {
                this.defaultFontName = FormatMoleculePanel.fontName(settings.getAtomFont());
                this.defaultFontStyle = 0;
                this.defaultFontSizeVal = 12.0 * (settings.getAtomSize() / 0.4);
            }
        }
    }

    private void initDefaultColor(boolean isAtom, boolean selectedItems) {
        MDocument mdoc = this.sketchPanel.getEditor().getDocument();
        if (isAtom) {
            this.defaultColorVal = null;
        } else {
            this.defaultBondcolorVal = null;
            this.bondcolorVal = null;
        }
        if (selectedItems && !this.selMol.isEmpty()) {
            int i;
            MolAtom[] atomArr = this.selMol.getAtomArray();
            MolBond[] bondArr = this.selMol.getBondArray();
            if (!isAtom && bondArr.length == 0) {
                return;
            }
            int setNo = isAtom ? atomArr[0].getSetSeq() : bondArr[0].getSetSeq();
            int n = isAtom ? atomArr.length : bondArr.length;
            boolean inSet = true;
            for (i = 1; inSet && i < n; ++i) {
                if (!(isAtom ? atomArr[i].getSetSeq() != setNo : bondArr[i].getSetSeq() != setNo)) continue;
                inSet = false;
            }
            if (inSet) {
                if (isAtom && mdoc.getAtomSetColor(setNo) != null) {
                    this.defaultColorVal = mdoc.getAtomSetColor(setNo);
                } else if (!isAtom && mdoc.getBondSetColor(setNo) != null) {
                    this.defaultBondcolorVal = this.bondcolorVal = mdoc.getBondSetColor(setNo);
                }
            } else {
                int[] setNoArr = isAtom ? new int[atomArr.length] : new int[bondArr.length];
                setNoArr[0] = isAtom ? atomArr[i - 1].getSetSeq() : bondArr[i - 1].getSetSeq();
                int m = 1;
                for (int j = i; j < n; ++j) {
                    inSet = false;
                    for (int k = 0; !inSet && k < m; ++k) {
                        if (!(isAtom ? atomArr[j].getSetSeq() == setNoArr[k] : bondArr[j].getSetSeq() == setNoArr[k])) continue;
                        inSet = true;
                    }
                    if (inSet) continue;
                    setNoArr[m] = isAtom ? atomArr[j].getSetSeq() : bondArr[j].getSetSeq();
                    ++m;
                }
                if (isAtom ? mdoc.getAtomSetColor(setNo) != null : mdoc.getBondSetColor(setNo) != null) {
                    Color c = isAtom ? mdoc.getAtomSetColor(setNo) : mdoc.getBondSetColor(setNo);
                    boolean sameColor = true;
                    for (int j = 0; sameColor && j < m; ++j) {
                        int k = setNoArr[j];
                        if (isAtom ? mdoc.getAtomSetColor(k) != null : mdoc.getBondSetColor(k) != null) {
                            if (!(isAtom ? !c.equals(mdoc.getAtomSetColor(k)) : !c.equals(mdoc.getBondSetColor(k)))) continue;
                            sameColor = false;
                            continue;
                        }
                        sameColor = false;
                    }
                    if (sameColor) {
                        if (isAtom) {
                            this.defaultColorVal = c;
                        } else {
                            this.bondcolorVal = c;
                            this.defaultBondcolorVal = c;
                        }
                    }
                }
            }
        } else if (!selectedItems) {
            if (isAtom && mdoc.getAtomSetColor(0) != null) {
                this.defaultColorVal = mdoc.getAtomSetColor(0);
            } else if (isAtom && mdoc.getAtomSetColor(0) == null) {
                this.defaultColorVal = null;
            } else if (!isAtom && mdoc.getBondSetColor(0) != null) {
                this.defaultBondcolorVal = this.bondcolorVal = mdoc.getBondSetColor(0);
            } else if (!isAtom && mdoc.getBondSetColor(0) == null) {
                this.bondcolorVal = null;
                this.defaultBondcolorVal = null;
            }
        }
    }

    private void initDefaultBondThickness(boolean selectedItems) {
        UserSettings settings = this.sketchPanel.getUserSettings();
        MDocument mdoc = this.sketchPanel.getEditor().getDocument();
        this.bondThicknessVal = 0.0;
        this.defaultBondTVal = 0.0;
        if (!this.selMol.isEmpty() && selectedItems) {
            MolBond[] bondArr = this.selMol.getBondArray();
            if (bondArr.length > 0) {
                int i;
                int setNo = bondArr[0].getSetSeq();
                boolean inSet = true;
                for (i = 1; inSet && i < bondArr.length; ++i) {
                    if (bondArr[i].getSetSeq() == setNo) continue;
                    inSet = false;
                }
                if (inSet) {
                    this.bondThicknessVal = mdoc.getBondSetThickness(setNo) != 0.0 ? mdoc.getBondSetThickness(setNo) : settings.getWireThickness();
                } else {
                    int[] setNoArr = new int[bondArr.length];
                    setNoArr[0] = bondArr[i - 1].getSetSeq();
                    int n = 1;
                    for (int j = i; j < bondArr.length; ++j) {
                        inSet = false;
                        for (int k = 0; !inSet && k < n; ++k) {
                            if (bondArr[j].getSetSeq() != setNoArr[k]) continue;
                            inSet = true;
                        }
                        if (inSet) continue;
                        setNoArr[n] = bondArr[j].getSetSeq();
                        ++n;
                    }
                    double bt = mdoc.getBondSetThickness(setNo) != 0.0 ? mdoc.getBondSetThickness(setNo) : settings.getWireThickness();
                    boolean sameBT = true;
                    for (int j = 0; sameBT && j < n; ++j) {
                        int k = setNoArr[j];
                        if (mdoc.getBondSetThickness(k) != 0.0) {
                            if (bt == mdoc.getBondSetThickness(k)) continue;
                            sameBT = false;
                            continue;
                        }
                        if (bt == settings.getWireThickness()) continue;
                        sameBT = false;
                    }
                    if (sameBT) {
                        this.bondThicknessVal = bt;
                    }
                }
            }
        } else if (!selectedItems) {
            this.bondThicknessVal = mdoc.getBondSetThickness(0) != 0.0 ? mdoc.getBondSetThickness(0) : settings.getWireThickness();
        }
        this.defaultBondTVal = this.bondThicknessVal;
    }

    private JButton createResetButton(String cmd, String toolTipID) {
        JButton b = new JButton(RESOURCES.getString("Reset"));
        b.setActionCommand(cmd);
        b.setToolTipText(RESOURCES.getString(toolTipID));
        b.addActionListener(this);
        return b;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd.equals("bondcolor")) {
            Color c = this.sketchPanel.showColorChooserDialog(this.bondcolorVal);
            if (c != null) {
                this.setBondColorProp(c);
            }
        } else if (cmd.equals("bondreset")) {
            this.setBondColorProp(null);
        } else if (cmd.equals("select")) {
            this.isResetToDefault = false;
            if (this.selMol.isBond()) {
                this.initDefaultBondThickness(true);
                this.initDefaultColor(false, true);
                this.bondThicknessTF.setText(String.valueOf(this.bondThicknessVal));
                this.setBondColor(this.defaultBondcolorVal);
                this.atomFontPanel.setPanelEnabled(false);
                this.setBondPanelEnabled(true);
            } else if (this.selMol.isAtom()) {
                this.initDefaultFonts(true);
                this.initDefaultColor(true, true);
                this.atomFontPanel.setSelectedFontFamily(this.defaultFontName);
                this.atomFontPanel.setSelectedStyle(this.defaultFontStyle);
                this.atomFontPanel.setSelectedSize((int)this.defaultFontSizeVal);
                this.atomFontPanel.setTextColor(this.defaultColorVal);
                this.atomFontPanel.setPanelEnabled(true);
                this.setBondPanelEnabled(false);
            } else {
                this.initDefaultFonts(true);
                this.initDefaultColor(true, true);
                this.initDefaultBondThickness(true);
                this.initDefaultColor(false, true);
                this.atomFontPanel.setSelectedFontFamily(this.defaultFontName);
                this.atomFontPanel.setSelectedStyle(this.defaultFontStyle);
                this.atomFontPanel.setSelectedSize((int)this.defaultFontSizeVal);
                this.atomFontPanel.setTextColor(this.defaultColorVal);
                this.bondThicknessTF.setText(String.valueOf(this.bondThicknessVal));
                this.setBondColor(this.defaultBondcolorVal);
                this.atomFontPanel.setPanelEnabled(true);
                this.setBondPanelEnabled(true);
            }
            this.loadButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        } else if (cmd.equals("default") || cmd.equals("all")) {
            this.isResetToDefault = false;
            this.initDefaultFonts(false);
            this.initDefaultColor(true, false);
            this.initDefaultBondThickness(false);
            this.initDefaultColor(false, false);
            this.atomFontPanel.setSelectedFontFamily(this.defaultFontName);
            this.atomFontPanel.setSelectedStyle(this.defaultFontStyle);
            this.atomFontPanel.setSelectedSize((int)this.defaultFontSizeVal);
            this.atomFontPanel.setTextColor(this.defaultColorVal);
            this.bondThicknessTF.setText(String.valueOf(this.bondThicknessVal));
            this.setBondColor(this.defaultBondcolorVal);
            this.atomFontPanel.setPanelEnabled(true);
            this.setBondPanelEnabled(true);
            if (cmd.equals("default")) {
                this.loadButton.setEnabled(false);
                this.saveButton.setEnabled(false);
            } else if (cmd.equals("all")) {
                this.loadButton.setEnabled(!Environment.UNTRUSTED);
                this.saveButton.setEnabled(!Environment.UNTRUSTED);
            }
        } else if (cmd.equals("load")) {
            CallbackIface mm = (CallbackIface)MarvinModule.load("sketch.swing.LoadJournalStyleDialog", this.sketchPanel);
            if (mm == null) {
                return;
            }
            mm.callback("setSketchPanel", this.sketchPanel);
            mm.callback("setFormatMoleculePanel", this);
            mm.callback("show", null);
        } else if (cmd.equals("save")) {
            CallbackIface mm = (CallbackIface)MarvinModule.load("sketch.swing.LoadSaveJSDialog", this.sketchPanel);
            if (mm == null) {
                return;
            }
            mm.callback("setSketchPanel", this.sketchPanel);
            mm.callback("setFormatMoleculePanel", this);
            File o = InstallStyles.getStyleDir();
            File dir = o != null ? o : DotfileUtil.getDotDir();
            mm.callback("setFile", dir);
            Object[] command = new Object[]{"saveAs", this.atomFontPanel.getSelectedFontFamily(), this.atomFontPanel.getSelectedStyleStr(), new Double(this.atomFontPanel.getSelectedSize()).toString(), this.atomFontPanel.getSelectedColor() != null ? Integer.valueOf(this.atomFontPanel.getSelectedColor().getRGB()) : "default", this.bondThicknessTF.getText(), this.bondcolorVal != null ? Integer.valueOf(this.bondcolorVal.getRGB()) : "default"};
            mm.callback("setCommand", command);
        } else if (cmd.equals("resetToDefault")) {
            this.isResetToDefault = true;
            if (this.selRB.isSelected() && this.selMol.isAtom()) {
                this.defaultFontName = FormatMoleculePanel.fontName(MolPainterCommon.DEFAULT_BASE_FONT);
                this.atomFontPanel.setSelectedFontFamily(this.defaultFontName);
                this.defaultFontStyle = 0;
                this.atomFontPanel.setSelectedStyle(0);
                this.defaultFontSizeVal = 12.0;
                this.atomFontPanel.setSelectedSize((int)this.defaultFontSizeVal);
                this.defaultColorVal = null;
                this.atomFontPanel.setTextColorProp(this.defaultColorVal);
            } else if (this.selRB.isSelected() && this.selMol.isBond()) {
                this.bondThicknessVal = 0.064;
                this.bondThicknessTF.setText(String.valueOf(this.bondThicknessVal));
                this.setBondColorProp(null);
            } else {
                this.atomFontPanel.setSelectedFontFamily(FormatMoleculePanel.fontName(MolPainterCommon.DEFAULT_BASE_FONT));
                this.atomFontPanel.setSelectedStyle(0);
                this.atomFontPanel.setSelectedSize(12.0);
                this.atomFontPanel.setTextColorProp(null);
                this.bondThicknessVal = 0.064;
                this.bondThicknessTF.setText(String.valueOf(0.064));
                this.setBondColorProp(null);
            }
        }
    }

    private void setBondColor(Color c) {
        if (this.bondcolorButton != null) {
            this.bondcolorVal = c;
            this.bondcolorButton.setBackground(c);
        }
    }

    private void setBondColorProp(Color c) {
        if (this.bondcolorButton != null) {
            this.bondcolorVal = c;
            this.bondcolorButton.setBackground(c);
            if (!this.bondcolorSet) {
                this.bondcolorSet = true;
                FormatMoleculePanel.setProp(this.bondcolorLabel);
            }
        }
    }

    static void setProp(JLabel l) {
        if (l != null) {
            String s = l.getText();
            l.setText("<html><small>*</small>" + s + "</html>");
            Window w = FormatMoleculePanel.findWindow(l);
            if (w != null) {
                w.pack();
            }
        }
    }

    private static Window findWindow(Component p) {
        while (p != null && !(p instanceof Window)) {
            p = p.getParent();
        }
        return (Window)p;
    }

    void applyChanges() {
        if (this.selRB.isSelected()) {
            int idfs = new Double(this.defaultFontSizeVal).intValue();
            int ifs = new Double(this.atomFontPanel.getSelectedSize()).intValue();
            if (!(this.atomFontPanel.getSelectedFontFamily().equals(this.defaultFontName) && this.atomFontPanel.getSelectedStyle() == this.defaultFontStyle && ifs == idfs && this.atomFontPanel.getSelectedColor() == null || this.selMol.isEmpty())) {
                this.setAtomSets();
            }
            if (this.atomFontPanel.getSelectedColor() == null && this.defaultColorVal != null || this.bondcolorVal == null && this.defaultBondcolorVal == null && this.isResetToDefault) {
                this.resetSetColor(true);
            }
            if (!(this.bondThicknessVal == this.defaultBondTVal && this.bondcolorVal == null || this.selMol.isEmpty())) {
                this.setBondSets();
            }
            if (this.bondcolorVal == null && this.defaultBondcolorVal != null || this.bondcolorVal == null && this.defaultBondcolorVal == null && this.isResetToDefault) {
                this.resetSetColor(false);
            }
        }
        if (this.defRB.isSelected()) {
            this.setDefaultValues();
        }
        if (this.allRB.isSelected()) {
            this.clearAllTheSets();
            this.setDefaultValues();
        }
    }

    private void clearAllTheSets() {
        this.sketchPanel.getEditor().getDocument().clearSets();
        this.sketchPanel.getEditor().getPainter().getCommon().clearSetPalette();
        Molecule mol = this.sketchPanel.getEditor().getMol();
        MolAtom[] molAtomArr = mol.getAtomArray();
        for (int i = 0; i < molAtomArr.length; ++i) {
            molAtomArr[i].setSetSeq(0);
        }
        MolBond[] molBondArr = mol.getBondArray();
        for (int i = 0; i < molBondArr.length; ++i) {
            molBondArr[i].setSetSeq(0);
        }
    }

    private void setDefaultValues() {
        MolEditor med = this.sketchPanel.getEditor();
        if (this.atomFontPanel.getSelectedFontFamily() != null && this.atomFontPanel.getSelectedStyle() != -1 && this.atomFontPanel.getSelectedSize() != 0.0) {
            String fn = this.atomFontPanel.getSelectedFontFamily();
            String dfn = FormatMoleculePanel.fontName(this.sketchPanel.getUserSettings().getAtomFont());
            double dfs = 12.0 * this.sketchPanel.getUserSettings().getAtomSize() / 0.4;
            int idfs = new Double(dfs).intValue();
            int ifs = new Double(this.atomFontPanel.getSelectedSize()).intValue();
            if (fn.equals(dfn) && this.atomFontPanel.getSelectedStyle() == 0 && ifs == idfs) {
                med.getDocument().setAtomSetFont(0, null);
            } else {
                Font f = this.atomFontPanel.getSelectedFont();
                float size = (float)this.atomFontPanel.getSelectedSize();
                f.deriveFont(0, size);
                MFont myFont = new MFont(f.getFamily(), f.getStyle(), f.getSize());
                med.getDocument().setAtomSetFont(0, myFont);
            }
        } else {
            JOptionPane.showMessageDialog(this.dialog, "All of the font fields should be set. Default font will not be created. ", "Invalid value", 1);
        }
        if (this.atomFontPanel.getSelectedColor() != null) {
            med.getDocument().setAtomSetRGB(0, this.atomFontPanel.getSelectedColor().getRGB());
        } else {
            med.getDocument().setAtomSetColorMode(0, 2);
            med.getPainter().getCommon().setAtomSetColor(0, null);
        }
        if (this.bondThicknessVal != 0.0) {
            if (this.bondThicknessVal == this.sketchPanel.getUserSettings().getWireThickness()) {
                med.getDocument().setBondSetThickness(0, 0.0);
            } else {
                med.getDocument().setBondSetThickness(0, this.bondThicknessVal);
            }
        }
        if (this.bondcolorVal != null) {
            med.getDocument().setBondSetRGB(0, this.bondcolorVal.getRGB());
        } else {
            med.getDocument().setBondSetColorMode(0, 2);
            med.getPainter().getCommon().setBondSetColor(0, null);
        }
    }

    private void setAtomSets() {
        MolEditor moledit = this.sketchPanel.getEditor();
        MolPainterCommon mcommon = moledit.getPainter().getCommon();
        ColorCollection mcolors = moledit.getPainter().getColors();
        MDocument mdoc = moledit.getDocument();
        MolAtom[] atomArr = this.selMol.getAtomArray();
        Color colorVal = this.atomFontPanel.getSelectedColor();
        if (this.atomFontPanel.getSelectedFontFamily() != null && this.atomFontPanel.getSelectedFontFamily().equals(this.defaultFontName) && this.atomFontPanel.getSelectedStyle() != this.defaultFontStyle && this.atomFontPanel.getSelectedSize() != this.defaultFontSizeVal && colorVal != null) {
            Font myFont = this.atomFontPanel.getSelectedFont();
            int setNo = this.thereIsASetLike(myFont, colorVal);
            if (setNo < 0) {
                ArrayList<MolAtom> atomVect = new ArrayList<MolAtom>(atomArr.length);
                for (int j = 0; j < atomArr.length; ++j) {
                    atomVect.add(atomArr[j]);
                }
                int freeFlag = this.findAFreeFlag(atomVect, null);
                mcommon.setAtomSetColor(freeFlag, colorVal);
                mcommon.setAtomSetFont(freeFlag, myFont);
                mdoc.setAtomSetRGB(freeFlag, colorVal.getRGB());
                MFont mf = new MFont(myFont.getFamily(), myFont.getStyle(), myFont.getSize2D());
                mdoc.setAtomSetFont(freeFlag, mf);
                for (int i = 0; i < atomArr.length; ++i) {
                    atomArr[i].setSetSeq(freeFlag);
                }
            } else {
                for (int i = 0; i < atomArr.length; ++i) {
                    atomArr[i].setSetSeq(setNo);
                }
            }
        } else {
            ArrayList<MolAtom> atomVect = new ArrayList<MolAtom>(atomArr.length);
            for (int j = 0; j < atomArr.length; ++j) {
                atomVect.add(atomArr[j]);
            }
            while (!atomVect.isEmpty()) {
                Font f0;
                int setSeq = ((MolAtom)atomVect.get(0)).getSetSeq();
                if (mdoc.getAtomSetFont(setSeq) == null) {
                    String dfn = FormatMoleculePanel.fontName(this.sketchPanel.getUserSettings().getAtomFont());
                    double dfs = 12.0 * this.sketchPanel.getUserSettings().getAtomSize() / 0.4;
                    f0 = new Font(dfn, 0, (int)dfs);
                    f0 = f0.deriveFont((float)dfs);
                } else {
                    f0 = mdoc.getAtomSetFont(setSeq).getAWTFont();
                }
                Color c0 = mcommon.getAtomSetColor(setSeq, mdoc, mcolors);
                if (c0 == null) {
                    c0 = mcolors.getForeground();
                }
                String fn = null;
                if (this.atomFontPanel.getSelectedFontFamily() != null && this.atomFontPanel.getSelectedFontFamily().equals(this.defaultFontName)) {
                    fn = f0.getName();
                }
                int ft = this.atomFontPanel.getSelectedStyle() == this.defaultFontStyle ? f0.getStyle() : -1;
                double fs = this.atomFontPanel.getSelectedSize() == this.defaultFontSizeVal ? (double)f0.getSize() : -1.0;
                Color c = colorVal == null ? c0 : null;
                List<MolAtom> sameVect = this.getSameAtoms(fn, ft, fs, c, atomVect);
                Font myFont = new Font(fn != null ? f0.getName() : this.atomFontPanel.getSelectedFontFamily(), ft >= 0 ? f0.getStyle() : this.atomFontPanel.getSelectedStyle(), (int)(fs >= 0.0 ? (double)f0.getSize() : this.atomFontPanel.getSelectedSize()));
                myFont = myFont.deriveFont((float)(fs >= 0.0 ? (double)f0.getSize() : this.atomFontPanel.getSelectedSize()));
                Color myColor = colorVal == null ? c0 : colorVal;
                this.changeAtomSetting(myFont, myColor, sameVect);
            }
        }
    }

    private void resetSetColor(boolean isAtom) {
        block10: {
            int setSeq;
            MolEditor moledit = this.sketchPanel.getEditor();
            MDocument mdoc = moledit.getDocument();
            if (this.selMol.isEmpty()) break block10;
            MolAtom[] atomArr = this.selMol.getAtomArray();
            MolBond[] bondArr = this.selMol.getBondArray();
            if (!isAtom && bondArr.length <= 0) {
                return;
            }
            ArrayList<MolAtom> atomVect = new ArrayList<MolAtom>(atomArr.length);
            for (int j = 0; j < atomArr.length; ++j) {
                atomVect.add(atomArr[j]);
            }
            ArrayList<MolBond> bondVect = new ArrayList<MolBond>(bondArr.length);
            for (int j = 0; j < bondArr.length; ++j) {
                bondVect.add(bondArr[j]);
            }
            if (isAtom) {
                while (!atomVect.isEmpty()) {
                    Font f0;
                    setSeq = ((MolAtom)atomVect.get(0)).getSetSeq();
                    if (mdoc.getAtomSetFont(setSeq) == null) {
                        String dfn = FormatMoleculePanel.fontName(this.sketchPanel.getUserSettings().getAtomFont());
                        double dfs = 12.0 * this.sketchPanel.getUserSettings().getAtomSize() / 0.4;
                        f0 = new Font(dfn, 0, (int)dfs);
                        f0 = f0.deriveFont((float)dfs);
                    } else {
                        f0 = mdoc.getAtomSetFont(setSeq).getAWTFont();
                    }
                    String fn = f0.getName();
                    int ft = f0.getStyle();
                    int fs = f0.getSize();
                    List<MolAtom> sameVect = this.getSameAtoms(fn, ft, fs, null, atomVect);
                    this.changeAtomSetting(f0, null, sameVect);
                }
            } else {
                while (!bondVect.isEmpty()) {
                    setSeq = ((MolBond)bondVect.get(0)).getSetSeq();
                    double t0 = mdoc.getBondSetThickness(setSeq);
                    if (t0 == 0.0) {
                        t0 = this.sketchPanel.getUserSettings().getWireThickness();
                    }
                    List<MolBond> sameVect = this.getSameBonds(t0, null, bondVect);
                    this.changeBondSetting(t0, null, sameVect);
                }
            }
        }
    }

    private void setBondSets() {
        MolEditor moledit = this.sketchPanel.getEditor();
        MDocument mdoc = moledit.getDocument();
        MolPainter molpainter = moledit.getPainter();
        MolPainterCommon mcommon = molpainter.getCommon();
        ColorCollection mcolors = molpainter.getColors();
        MolBond[] bondArr = this.selMol.getBondArray();
        if (this.bondThicknessVal != this.defaultBondTVal && this.bondcolorVal != null) {
            int setNo = this.thereIsASetLike(this.bondThicknessVal, this.bondcolorVal);
            if (setNo < 0) {
                int i;
                ArrayList<MolBond> bondVect = new ArrayList<MolBond>(bondArr.length);
                for (i = 0; i < bondArr.length; ++i) {
                    bondVect.add(bondArr[i]);
                }
                int freeFlag = this.findAFreeFlag(null, bondVect);
                mcommon.setBondSetColor(freeFlag, this.bondcolorVal);
                mdoc.setBondSetRGB(freeFlag, this.bondcolorVal.getRGB());
                mcommon.setBondSetLineThickness(freeFlag, this.bondThicknessVal);
                mdoc.setBondSetThickness(freeFlag, this.bondThicknessVal);
                for (i = 0; i < bondArr.length; ++i) {
                    bondArr[i].setSetSeq(freeFlag);
                }
            } else {
                for (int i = 0; i < bondArr.length; ++i) {
                    bondArr[i].setSetSeq(setNo);
                }
            }
        } else {
            ArrayList<MolBond> bondVect = new ArrayList<MolBond>(bondArr.length);
            for (int i = 0; i < bondArr.length; ++i) {
                bondVect.add(bondArr[i]);
            }
            while (!bondVect.isEmpty()) {
                Color c0;
                int setSeq = ((MolBond)bondVect.get(0)).getSetSeq();
                double t0 = mdoc.getBondSetThickness(setSeq);
                if (t0 == 0.0) {
                    t0 = this.sketchPanel.getUserSettings().getWireThickness();
                }
                if ((c0 = mdoc.getBondSetColor(setSeq)) == null) {
                    c0 = mcolors.getForeground();
                }
                double t = this.bondThicknessVal == this.defaultBondTVal ? t0 : 0.0;
                Color c = this.bondcolorVal == null ? c0 : null;
                List<MolBond> sameVect = this.getSameBonds(t, c, bondVect);
                double myThickness = t == t0 ? t0 : this.bondThicknessVal;
                Color myColor = this.bondcolorVal == null ? c0 : this.bondcolorVal;
                this.changeBondSetting(myThickness, myColor, sameVect);
            }
        }
    }

    private void changeAtomSetting(Font myFont, Color myColor, List<MolAtom> atomVect) {
        int freeFlag;
        MolEditor moledit = this.sketchPanel.getEditor();
        MolPainter molpainter = moledit.getPainter();
        MolPainterCommon mcommon = molpainter.getCommon();
        ColorCollection mcolors = molpainter.getColors();
        MDocument mdoc = moledit.getDocument();
        int setNo = this.thereIsASetLike(myFont, myColor);
        if (setNo >= 0) {
            freeFlag = setNo;
        } else {
            freeFlag = this.findAFreeFlag(atomVect, null);
            if (this.atomFontPanel.getSelectedColor() == null && myColor != null && myColor.equals(mcolors.getForeground())) {
                mdoc.setAtomSetColorMode(freeFlag, 2);
            } else if (myColor == null) {
                mcommon.setAtomSetColor(freeFlag, null);
                mdoc.setAtomSetColorMode(freeFlag, 2);
            } else {
                mcommon.setAtomSetColor(freeFlag, myColor);
                mdoc.setAtomSetRGB(freeFlag, myColor.getRGB());
            }
            mcommon.setAtomSetFont(freeFlag, myFont);
            MFont mf = new MFont(myFont.getFamily(), myFont.getStyle(), myFont.getSize2D());
            mdoc.setAtomSetFont(freeFlag, mf);
        }
        while (!atomVect.isEmpty()) {
            atomVect.remove(0).setSetSeq(freeFlag);
        }
    }

    private void changeBondSetting(double myThickness, Color myColor, List<MolBond> bondVect) {
        int freeFlag;
        MolEditor moledit = this.sketchPanel.getEditor();
        MolPainter molpainter = moledit.getPainter();
        MDocument mdoc = moledit.getDocument();
        MolPainterCommon mcommon = molpainter.getCommon();
        int setNo = this.thereIsASetLike(myThickness, myColor);
        if (setNo >= 0) {
            freeFlag = setNo;
        } else {
            freeFlag = this.findAFreeFlag(null, bondVect);
            if (this.bondcolorVal == null && myColor != null && myColor.equals(molpainter.getColors().getForeground())) {
                mdoc.setBondSetColorMode(freeFlag, 2);
            } else if (myColor == null) {
                mcommon.setBondSetColor(freeFlag, null);
                mdoc.setBondSetColorMode(freeFlag, 2);
            } else {
                mcommon.setBondSetColor(freeFlag, myColor);
                mdoc.setBondSetRGB(freeFlag, myColor.getRGB());
            }
            mcommon.setBondSetLineThickness(freeFlag, myThickness);
            mdoc.setBondSetThickness(freeFlag, myThickness);
        }
        while (!bondVect.isEmpty()) {
            bondVect.remove(0).setSetSeq(freeFlag);
        }
    }

    private int findAFreeFlag(List<MolAtom> avect, List<MolBond> bvect) {
        int setNo;
        int i;
        boolean[] isAFlagArr;
        boolean isAtomArr = avect != null;
        int flag = 1;
        MolEditor moledit = this.sketchPanel.getEditor();
        Molecule mol = moledit.getMol();
        if (isAtomArr) {
            isAFlagArr = new boolean[64];
            MolAtom[] molAtomArr = mol.getAtomArray();
            for (i = 0; i < molAtomArr.length; ++i) {
                if (avect.contains(molAtomArr[i])) continue;
                setNo = molAtomArr[i].getSetSeq();
                isAFlagArr[setNo] = true;
            }
        } else {
            isAFlagArr = new boolean[64];
            MolBond[] molBondArr = mol.getBondArray();
            for (i = 0; i < molBondArr.length; ++i) {
                if (bvect.contains(molBondArr[i])) continue;
                setNo = molBondArr[i].getSetSeq();
                isAFlagArr[setNo] = true;
            }
        }
        while (isAFlagArr[flag] && flag < isAFlagArr.length) {
            ++flag;
        }
        if (!isAFlagArr[flag]) {
            if (isAtomArr) {
                moledit.getDocument().setAtomSetColorMode(flag, 2);
                moledit.getPainter().getCommon().setAtomSetColor(flag, null);
            } else {
                moledit.getDocument().setBondSetColorMode(flag, 2);
                moledit.getPainter().getCommon().setBondSetColor(flag, null);
            }
            return flag;
        }
        return -1;
    }

    private int thereIsASetLike(Font myFont, Color myColor) {
        MolEditor moledit = this.sketchPanel.getEditor();
        MDocument mdoc = moledit.getDocument();
        for (int setNo = 0; setNo < 64; ++setNo) {
            Font actualFont;
            Color actualColor = mdoc.getAtomSetColor(setNo);
            Font font = actualFont = mdoc.getAtomSetFont(setNo) == null ? null : mdoc.getAtomSetFont(setNo).getAWTFont();
            if (setNo == 0 && actualFont == null) {
                String dfn = FormatMoleculePanel.fontName(this.sketchPanel.getUserSettings().getAtomFont());
                double dfs = 12.0 * this.sketchPanel.getUserSettings().getAtomSize() / 0.4;
                actualFont = new Font(dfn, 0, (int)dfs);
                actualFont = actualFont.deriveFont((float)dfs);
            }
            if (actualFont != null) {
                if (actualFont.equals(myFont) && myColor == null && actualColor == null) {
                    return setNo;
                }
                if (!actualFont.equals(myFont) || myColor == null || actualColor == null || !actualColor.equals(myColor)) continue;
                return setNo;
            }
            return -1;
        }
        return -1;
    }

    private int thereIsASetLike(double thickness, Color myColor) {
        MolEditor moledit = this.sketchPanel.getEditor();
        ColorCollection colors = moledit.getPainter().getColors();
        MDocument mdoc = moledit.getDocument();
        for (int setNo = 0; setNo < 64; ++setNo) {
            double actualThickness;
            Color actualColor = mdoc.getBondSetColor(setNo);
            if (actualColor == null) {
                actualColor = colors.getForeground();
            }
            if ((actualThickness = mdoc.getBondSetThickness(setNo)) == 0.0) {
                actualThickness = this.sketchPanel.getUserSettings().getWireThickness();
            }
            if (actualThickness == thickness && myColor == null && actualColor == null) {
                return setNo;
            }
            if (actualThickness == thickness && actualColor == null) {
                actualColor = colors.getForeground();
            }
            if (actualThickness != thickness || myColor == null || !actualColor.equals(myColor)) continue;
            return setNo;
        }
        return -1;
    }

    private List<MolAtom> getSameAtoms(String name, int type, double size, Color color, List<MolAtom> atomVect) {
        ArrayList<MolAtom> vect = new ArrayList<MolAtom>();
        MolEditor moledit = this.sketchPanel.getEditor();
        MDocument mdoc = moledit.getDocument();
        int i = 0;
        boolean isIt = true;
        while (i < atomVect.size()) {
            Font actualFont;
            int setSeq = atomVect.get(i).getSetSeq();
            if (mdoc.getAtomSetFont(setSeq) == null) {
                String dfn = FormatMoleculePanel.fontName(this.sketchPanel.getUserSettings().getAtomFont());
                double dfs = 12.0 * this.sketchPanel.getUserSettings().getAtomSize() / 0.4;
                actualFont = new Font(dfn, 0, (int)dfs);
                actualFont = actualFont.deriveFont((float)dfs);
            } else {
                actualFont = mdoc.getAtomSetFont(setSeq).getAWTFont();
            }
            Color actualColor = mdoc.getAtomSetColor(setSeq);
            if (actualColor == null) {
                actualColor = moledit.getPainter().getColors().getForeground();
            }
            if (name != null && !actualFont.getName().equals(name)) {
                isIt = false;
            }
            if (type >= 0 && actualFont.getStyle() != type) {
                isIt = false;
            }
            if (size >= 0.0 && (double)actualFont.getSize() != size) {
                isIt = false;
            }
            if (color != null && !actualColor.equals(color)) {
                isIt = false;
            }
            if (isIt) {
                vect.add(atomVect.remove(i));
                continue;
            }
            ++i;
        }
        return vect;
    }

    private List<MolBond> getSameBonds(double thickness, Color color, List<MolBond> bondVect) {
        ArrayList<MolBond> vect = new ArrayList<MolBond>();
        MolEditor moledit = this.sketchPanel.getEditor();
        MDocument mdoc = moledit.getDocument();
        int i = 0;
        boolean isIt = true;
        while (i < bondVect.size()) {
            Color actualColor;
            int setFlag = bondVect.get(i).getSetSeq();
            double actualThickness = mdoc.getBondSetThickness(setFlag);
            if (actualThickness == 0.0) {
                actualThickness = this.sketchPanel.getUserSettings().getWireThickness();
            }
            if ((actualColor = mdoc.getBondSetColor(setFlag)) == null) {
                actualColor = moledit.getPainter().getColors().getForeground();
            }
            if (thickness > 0.0 && actualThickness != thickness) {
                isIt = false;
            }
            if (color != null && !actualColor.equals(color)) {
                isIt = false;
            }
            if (isIt) {
                vect.add(bondVect.remove(i));
                continue;
            }
            ++i;
        }
        return vect;
    }

    @Override
    public void focusGained(FocusEvent ev) {
    }

    @Override
    public void focusLost(FocusEvent ev) {
        Object src = ev.getSource();
        if (src instanceof JTextField) {
            JTextField t = (JTextField)src;
            double y = -1.0;
            try {
                if (t == this.bondThicknessTF) {
                    y = Double.valueOf(t.getText());
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            if (t == this.bondThicknessTF) {
                if (y > 0.0) {
                    if (t == this.bondThicknessTF) {
                        this.bondThicknessVal = y;
                        this.bondThicknessTF.setText(String.valueOf(y));
                    }
                } else {
                    if (t == this.bondThicknessTF) {
                        y = this.bondThicknessVal;
                        this.bondThicknessTF.setText(String.valueOf(y));
                    }
                    JOptionPane.showMessageDialog(this.dialog, "Positive number expected.", "Invalid value", 0);
                }
            }
        }
    }

    private static String fontName(Font f) {
        return f.getFamily();
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(FormatMoleculePanel.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("FormatMoleculePanel.properties not found");
        }
        RESOURCES = rc;
    }
}

