/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.modules.SgroupValidate;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.swing.ListWithDisabledItemsRenderer;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.text.MStringTokenizer;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GroupCreationDialog
implements CallbackIface,
Serializable,
ActionListener {
    private static final long serialVersionUID = -7475545034021600140L;
    private static final ResourceBundle RESOURCES;
    private static final Pattern rangePattern;
    private static final Pattern superAtomNamePattern;
    private GroupType[] availableGroups = new GroupType[19];
    private SketchPanel sketchPanel;
    private JDialog dialog = null;
    private JButton okay = null;
    private JButton cancel = null;
    private JComboBox typeCombo = null;
    private JComboBox superscriptCombo = null;
    private JLabel superscriptLabel = null;
    private JComboBox bracketTypeCombo = null;
    private JLabel bracketTypeLabel = null;
    private JLabel chargeLocationLabel = null;
    private JLabel subscriptJLabel = null;
    private JTextField subscriptTxt = null;
    private JButton subscriptHelp = null;
    private int creationActionI = 17;
    private int savedCreationActionI;
    private String[] superscripts;
    private JRadioButton onAtoms;
    private JRadioButton onGroup;
    private Sgroup sgroup;
    private JLabel typeLabel;
    private final int GROUP_EDITING = 0;
    private final int GROUP_SELECTION = 1;
    private final int GROUP_CREATION = 2;
    private int mode = 0;
    private EscapeHandler escapeHandle = new EscapeHandler();
    public static final String RGROUP_GROUP = "rgroupGroup";

    public GroupCreationDialog() {
        this.superscripts = new String[]{"htn", "htf", "hhn", "hhf", "eun"};
        this.availableGroups[0] = new GroupType(RESOURCES.getString("anypolymerGroup"), 20, "", "", null, 11, 0);
        this.availableGroups[1] = new GroupType(RESOURCES.getString("componentGroup"), 15, "none", RESOURCES.getString("orderNumber"), null, 13, 0);
        this.availableGroups[2] = new GroupType(RESOURCES.getString("copolymerGroup"), 21, "", "", null, 5, 0);
        this.availableGroups[3] = new GroupType(RESOURCES.getString("alternatingCopolymerGroup"), 22, "", "", null, 5, 1);
        this.availableGroups[4] = new GroupType(RESOURCES.getString("blockCopolymerGroup"), 23, "", "", null, 5, 3);
        this.availableGroups[5] = new GroupType(RESOURCES.getString("randomCopolymerGroup"), 24, "", "", null, 5, 2);
        this.availableGroups[6] = new GroupType(RESOURCES.getString("crosslinkGroup"), 25, "", "", null, 6, 0);
        this.availableGroups[7] = new GroupType(RESOURCES.getString("genericGroup"), 26, "", "", null, 12, 0);
        this.availableGroups[8] = new GroupType(RESOURCES.getString("graftGroup"), 27, "", "", null, 15, 0);
        this.availableGroups[9] = new GroupType(RESOURCES.getString("merGroup"), 28, "", "", null, 4, 0);
        this.availableGroups[10] = new GroupType(RESOURCES.getString("modificationGroup"), 29, "", "", null, 7, 0);
        this.availableGroups[11] = new GroupType(RESOURCES.getString("monomerGroup"), 30, "", "", null, 3, 0);
        this.availableGroups[12] = new GroupType(RESOURCES.getString("multipleGroup"), 11, "3", RESOURCES.getString("mulSgroupRepeatCount"), null, 1, 0);
        this.availableGroups[13] = new GroupType(RESOURCES.getString("orderedMixtureGroup"), 17, "", "", null, 9, 0);
        this.availableGroups[14] = new GroupType(RESOURCES.getString("rangeGroup"), 19, "3", RESOURCES.getString("rsruLabel"), null, 2, 0);
        this.availableGroups[15] = new GroupType(RESOURCES.getString(RGROUP_GROUP), 14, "R1", RESOURCES.getString("rgroupNumber"), null, -1, -1);
        this.availableGroups[16] = new GroupType(RESOURCES.getString("sruGroup"), 18, "n", RESOURCES.getString("sruLabel"), null, 2, 0);
        this.availableGroups[17] = new GroupType(RESOURCES.getString("superatomGroup"), 10, "noname", RESOURCES.getString("supSgroupName"), null, 0, 0);
        this.availableGroups[18] = new GroupType(RESOURCES.getString("unorderedMixtureGroup"), 16, "", "", null, 8, 0);
    }

    @Override
    public Object callback(String method, Object o) {
        int type;
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)o;
        } else if (method.equals("show")) {
            this.init1();
        } else if (method.equals("edit")) {
            this.sgroup = (Sgroup)o;
            this.mode = 0;
            this.init1();
        } else if (method.equals("mode")) {
            String type2 = (String)o;
            if (type2.equals("selection")) {
                this.mode = 1;
            } else if (type2.equals("create")) {
                this.mode = 2;
            }
        } else if (method.equals("groupType") && (type = ((Integer)o).intValue()) == 19) {
            this.creationActionI = this.getIndexOf(type);
        }
        return null;
    }

    private JDialog createDialog() {
        JDialog result = this.sketchPanel.isParentWindowDialog() ? new JDialog(this.sketchPanel.getParentDialog(), true) : new JDialog(this.sketchPanel.getParentFrame(), true);
        if (this.mode == 0) {
            result.setTitle("Edit Group");
        } else {
            result.setTitle("Create Group");
        }
        result.setResizable(false);
        return result;
    }

    private void init1() {
        int i;
        int ipad;
        MolEditor medit = this.sketchPanel.getEditor();
        if (this.mode != 0 && !SgroupValidate.isCorrectGroupSelection(medit)) {
            JOptionPane.showMessageDialog(this.sketchPanel, "Selection for group creation is incorrect. Please, repeat your selection.", "Warning", 2);
            this.cancel();
            return;
        }
        this.dialog = this.createDialog();
        this.savedCreationActionI = this.creationActionI;
        for (int i2 = this.availableGroups.length - 1; i2 >= 0; --i2) {
            this.availableGroups[i2].savedSubscriptValue = this.availableGroups[i2].subscriptValue;
        }
        Container contentPane = this.dialog.getContentPane();
        contentPane.removeAll();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(gbl);
        FontMetrics fm = this.sketchPanel.getFontMetrics(this.sketchPanel.getFont());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 1;
        this.typeLabel = new JLabel(RESOURCES.getString("groupTypeLabel"), 2);
        gbl.setConstraints(contentPane.add(this.typeLabel), gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(5, 5, 0, 5);
        String[] types = new String[this.availableGroups.length];
        for (int i3 = types.length - 1; i3 >= 0; --i3) {
            types[i3] = this.availableGroups[i3].typeName;
        }
        this.typeCombo = new JComboBox<String>(types);
        this.typeCombo.addActionListener(this);
        gbl.setConstraints(contentPane.add(this.typeCombo), gbc);
        ++gbc.gridy;
        gbc.ipadx = ipad = fm.stringWidth("aa");
        this.subscriptJLabel = new JLabel("", 2);
        gbc.gridx = 0;
        gbl.setConstraints(contentPane.add(this.subscriptJLabel), gbc);
        this.subscriptTxt = new JTextField();
        this.subscriptTxt.addActionListener(this);
        this.subscriptTxt.addKeyListener(this.escapeHandle);
        this.subscriptTxt.selectAll();
        gbc.fill = 1;
        gbc.gridx = 1;
        gbl.setConstraints(contentPane.add(this.subscriptTxt), gbc);
        this.subscriptHelp = new JButton("Help");
        this.subscriptHelp.addActionListener(this);
        gbc.fill = 0;
        gbc.gridx = 2;
        gbl.setConstraints(contentPane.add(this.subscriptHelp), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.superscriptLabel = new JLabel(RESOURCES.getString("repeatPattern"), 2);
        gbl.setConstraints(contentPane.add(this.superscriptLabel), gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(5, 5, 0, 5);
        String[] superscriptTypes = MStringTokenizer.convertToArray(RESOURCES.getString("superscriptTypes"));
        this.superscriptCombo = new JComboBox<String>(superscriptTypes);
        this.superscriptCombo.addActionListener(this);
        ArrayList<String> disabledGroupNames = new ArrayList<String>();
        for (String s : this.sketchPanel.getDisabledGroupTypes()) {
            try {
                disabledGroupNames.add(RESOURCES.getString(s));
            }
            catch (MissingResourceException e) {}
        }
        ListWithDisabledItemsRenderer renderer = new ListWithDisabledItemsRenderer(types.length);
        if (this.sketchPanel.getUserSettings().isvalidateSgroupsAtCreation()) {
            if (this.mode == 0) {
                for (i = 0; i < this.availableGroups.length; ++i) {
                    if (this.availableGroups[i].typeValue == -1) {
                        renderer.setEnabled(i, false);
                        continue;
                    }
                    renderer.setEnabled(i, SgroupValidate.isAllowedSgroupTypeToChangeTo(medit, this.availableGroups[i].create_action, this.sgroup) && !disabledGroupNames.contains(this.availableGroups[i].typeName));
                }
            } else {
                boolean isDefaultAllowed = true;
                int firstAllowed = -1;
                for (int i4 = 0; i4 < this.availableGroups.length; ++i4) {
                    if (this.availableGroups[i4].typeValue == -1) {
                        renderer.setEnabled(i4, true);
                        if (firstAllowed >= 0) continue;
                        firstAllowed = i4;
                        continue;
                    }
                    boolean isAllowed = SgroupValidate.isAllowedSgroupTypeToCreate(medit, this.availableGroups[i4].create_action);
                    isAllowed = isAllowed && !disabledGroupNames.contains(this.availableGroups[i4].typeName);
                    renderer.setEnabled(i4, isAllowed);
                    if (isAllowed && firstAllowed < 0) {
                        firstAllowed = i4;
                    }
                    if (i4 != this.creationActionI || isAllowed) continue;
                    isDefaultAllowed = false;
                }
                if (!isDefaultAllowed) {
                    this.creationActionI = firstAllowed;
                }
            }
        } else {
            for (i = 0; i < this.availableGroups.length; ++i) {
                if (!disabledGroupNames.contains(this.availableGroups[i].typeName)) continue;
                renderer.setEnabled(i, false);
            }
        }
        this.typeCombo.setRenderer(renderer);
        gbl.setConstraints(contentPane.add(this.superscriptCombo), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.bracketTypeLabel = new JLabel(RESOURCES.getString("bracketTypeLabel"), 2);
        gbl.setConstraints(contentPane.add(this.bracketTypeLabel), gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(5, 5, 0, 5);
        String[] bracketTypes = MStringTokenizer.convertToArray(RESOURCES.getString("bracketTypes"));
        this.bracketTypeCombo = new JComboBox<String>(bracketTypes);
        this.bracketTypeCombo.addActionListener(this);
        gbl.setConstraints(contentPane.add(this.bracketTypeCombo), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.chargeLocationLabel = new JLabel(RESOURCES.getString("chargeLocation"), 2);
        gbl.setConstraints(contentPane.add(this.chargeLocationLabel), gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(5, 5, 0, 5);
        String[] chargeLocationTypes = MStringTokenizer.convertToArray(RESOURCES.getString("chargeLocationTypes"));
        this.onAtoms = new JRadioButton(chargeLocationTypes[0]);
        this.onAtoms.setActionCommand(chargeLocationTypes[0]);
        this.onAtoms.setToolTipText(RESOURCES.getString("chargToolTipText"));
        this.onGroup = new JRadioButton(chargeLocationTypes[1]);
        this.onGroup.setActionCommand(chargeLocationTypes[1]);
        this.onGroup.setToolTipText(RESOURCES.getString("chargToolTipText"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.onAtoms);
        group.add(this.onGroup);
        this.onAtoms.addActionListener(this);
        this.onGroup.addActionListener(this);
        gbl.setConstraints(contentPane.add(this.onAtoms), gbc);
        ++gbc.gridy;
        gbl.setConstraints(contentPane.add(this.onGroup), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        JPanel panel = new JPanel();
        gbl.setConstraints(contentPane.add(panel), gbc);
        this.okay = new JButton("OK");
        panel.add(this.okay);
        this.okay.setMnemonic('O');
        this.okay.addActionListener(this);
        this.cancel = new JButton("Cancel");
        panel.add(this.cancel);
        this.cancel.setMnemonic('C');
        this.cancel.addActionListener(this);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public synchronized void windowClosing(WindowEvent e) {
                GroupCreationDialog.this.cancel();
                GroupCreationDialog.this.sketchPanel.closeGroupCreationDialog(GroupCreationDialog.this.dialog);
            }
        });
        this.setType(this.creationActionI);
        this.dialog.setLocationRelativeTo(this.sketchPanel);
        if (this.sgroup != null) {
            this.creationActionI = this.getType(this.sgroup);
            this.typeCombo.setSelectedIndex(this.creationActionI);
            if (SgroupValidate.canHavePolymerSuperScript(this.sgroup.getSgroupGraph(), this.sgroup.getType())) {
                this.superscriptCombo.setEnabled(true);
                this.updateSuperScriptCombo((RepeatingUnitSgroup)this.sgroup);
            } else {
                this.superscriptCombo.setEnabled(false);
            }
            int bracketType = 1;
            if (this.sgroup.getBracketCount() != 0) {
                ArrayList<MBracket> list = this.sgroup.getBrackets();
                for (int i5 = 0; i5 < list.size(); ++i5) {
                    bracketType = list.get(i5).getType();
                }
            }
            this.bracketTypeCombo.setSelectedIndex(bracketType == 1 ? 0 : 1);
            this.subscriptTxt.setEditable(SgroupValidate.canHaveSubScript(this.sgroup.getType()));
            this.subscriptTxt.setEnabled(SgroupValidate.canHaveSubScript(this.sgroup.getType()));
            if (SgroupValidate.canHaveSubScript(this.sgroup.getType())) {
                this.subscriptTxt.setText(this.getSubscript(this.sgroup));
            } else {
                this.subscriptTxt.setText("");
            }
            this.subscriptHelp.setEnabled(this.sgroup.getType() == 0);
            this.onAtoms.setEnabled(this.hasCharge(this.availableGroups[this.creationActionI].create_action));
            this.onGroup.setEnabled(this.hasCharge(this.availableGroups[this.creationActionI].create_action));
            if (this.sgroup.getChargeLocation() == 1) {
                this.onAtoms.setSelected(true);
            } else if (this.sgroup.getChargeLocation() == 2) {
                this.onGroup.setSelected(true);
            }
        } else {
            this.onAtoms.setSelected(true);
        }
        this.sketchPanel.showWindow(this.dialog);
    }

    private String getSubscript(Sgroup sg) {
        if (sg.isOrderedComponentSgroup()) {
            return sg.getSubscript().substring(1);
        }
        if (sg.getType() == 13) {
            return "none";
        }
        return sg.getSubscript();
    }

    private int getIndexOf(int action) {
        for (int index = 0; index < this.availableGroups.length; ++index) {
            if (this.availableGroups[index].create_action != action) continue;
            return index;
        }
        return -1;
    }

    private int getType(Sgroup sg) {
        int index;
        for (index = 0; !(index >= this.availableGroups.length || this.availableGroups[index].typeValue == sg.getType() && (sg.getType() == 2 ? (RepeatingUnitSgroup.isAcceptableSru(sg.getSubscript()) ? this.availableGroups[index].create_action == 18 : this.availableGroups[index].create_action == 19) : this.availableGroups[index].subtypeValue == sg.getSubType())); ++index) {
        }
        return index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object t = e.getSource();
        if (t == this.cancel) {
            this.cancel();
            this.sketchPanel.closeGroupCreationDialog(this.dialog);
        } else if (t == this.typeCombo) {
            int i = this.typeCombo.getSelectedIndex();
            ListWithDisabledItemsRenderer renderer = (ListWithDisabledItemsRenderer)this.typeCombo.getRenderer();
            if (!renderer.isEnabled(i)) {
                this.typeCombo.setSelectedIndex(this.creationActionI);
            } else if (i != this.creationActionI) {
                this.setType(i);
            }
        } else if (t == this.okay) {
            this.doIt();
        } else if (t == this.subscriptTxt) {
            this.doIt();
        } else if (t == this.subscriptHelp) {
            JOptionPane.showMessageDialog(this.sketchPanel, RESOURCES.getString("subscriptHelp"), RESOURCES.getString("helpTitle"), 1);
        }
    }

    private void setOK() {
        String s = this.getSubscript();
        boolean acceptable = false;
        int id = this.availableGroups[this.creationActionI].create_action;
        if (id == 10) {
            acceptable = GroupCreationDialog.isAcceptableSuperatomName(s);
        } else if (id == 11) {
            acceptable = this.isAcceptableGroupMultiplier(s);
        } else if (id == 14) {
            acceptable = this.isAcceptableRgroupNumber(s) && this.sgroup == null;
        } else if (id == 15) {
            acceptable = this.isAcceptableComponentIndex(s);
        } else if (id == 16 || id == 17 || id == 20 || id == 21 || id == 23 || id == 24 || id == 22 || id == 25 || id == 26 || id == 27 || id == 28 || id == 29 || id == 30) {
            acceptable = true;
        } else if (id == 18) {
            acceptable = RepeatingUnitSgroup.isAcceptableSru(s);
        } else if (id == 19) {
            acceptable = this.isAcceptableRangedSru(s);
        }
        this.okay.setEnabled(acceptable);
    }

    private void enableTextField(int index) {
        this.subscriptJLabel.setText(this.availableGroups[index].subscriptLabel);
        this.subscriptTxt.setText(this.availableGroups[index].subscriptValue);
        this.subscriptTxt.setEditable(true);
        this.subscriptTxt.setEnabled(true);
    }

    private void disableTextField() {
        this.subscriptTxt.setEditable(false);
        this.subscriptTxt.setEnabled(false);
        this.subscriptHelp.setEnabled(false);
    }

    private boolean hasRepeatingPattern(int id) {
        return id == 20 || id == 18 || id == 21 || id == 22 || id == 23 || id == 24 || id == 25 || id == 27 || id == 29 || id == 19;
    }

    private boolean hasCharge(int id) {
        return id == 15 || id == 26 || id == 28 || id == 30;
    }

    private void setType(int i) {
        int id = this.availableGroups[i].create_action;
        this.typeCombo.setSelectedIndex(i);
        if (i != this.creationActionI) {
            this.availableGroups[this.creationActionI].subscriptValue = this.getSubscript();
            this.creationActionI = i;
        }
        if (id == 10 || id == 11 || id == 14 || id == 15 || id == 18 || id == 19) {
            this.enableTextField(i);
        } else {
            this.disableTextField();
        }
        this.subscriptHelp.setEnabled(id == 10);
        SelectionMolecule selection = this.sgroup == null ? (SelectionMolecule)this.sketchPanel.getEditor().getSelectionDocument().getMainMoleculeGraph() : this.sgroup.getSgroupGraph();
        this.superscriptCombo.setEnabled(SgroupValidate.canHavePolymerSuperScript(selection, this.availableGroups[i].typeValue));
        this.onAtoms.setEnabled(this.hasCharge(id));
        this.onGroup.setEnabled(this.hasCharge(id));
        this.setOK();
        this.dialog.pack();
    }

    private void doIt() {
        if (!this.okay.isEnabled()) {
            return;
        }
        MolEditor medit = this.sketchPanel.getEditor();
        if (this.sgroup != null) {
            this.editGroup(medit);
        } else {
            this.createNewGroup(medit, this.availableGroups[this.creationActionI].create_action);
        }
        this.sketchPanel.closeGroupCreationDialog(this.dialog);
    }

    private void createNewGroup(MolEditor medit, int create_cmd) {
        String params = "";
        String subscr = this.getSubscript();
        String superscript = this.getSuperScript();
        if (subscr.equals("none")) {
            subscr = "";
        }
        if (create_cmd == 11 || create_cmd >= 15 && create_cmd <= 31) {
            params = (this.bracketTypeCombo.getSelectedIndex() == 0 ? Integer.toString(1) : Integer.toString(0)).concat(params);
        }
        if (create_cmd == 17 || create_cmd == 16) {
            subscr = "";
        }
        if (this.hasRepeatingPattern(create_cmd)) {
            params = params.concat(superscript);
            params = params.concat(subscr);
        }
        if (create_cmd == 14 || create_cmd == 11 || create_cmd == 10) {
            params = params.concat(subscr);
        }
        if (create_cmd == 15) {
            params = params.concat("c");
            params = params.concat(subscr);
        }
        if (this.hasCharge(create_cmd)) {
            params = params.concat(this.getChargeLocation());
        }
        if (this.mode == 1 && create_cmd == 18) {
            create_cmd = 31;
        }
        medit.edit(create_cmd, params);
        this.availableGroups[this.creationActionI].subscriptValue = subscr;
        if (create_cmd == 15) {
            if (subscr.equals("")) {
                this.availableGroups[this.creationActionI].subscriptValue = "none";
            } else if (this.isPositiveInteger(subscr)) {
                try {
                    int n = Integer.parseInt(subscr);
                    this.availableGroups[this.creationActionI].subscriptValue = Integer.toString(++n);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        if (create_cmd == 18 && subscr.length() >= 2) {
            this.availableGroups[this.creationActionI].subscriptValue = "n";
        }
        if (create_cmd == 19 && subscr.length() >= 2) {
            this.availableGroups[this.creationActionI].subscriptValue = "3";
        }
    }

    private void editGroup(MolEditor medit) {
        this.sgroup = medit.replaceGroup(this.sgroup, this.availableGroups[this.creationActionI].typeValue, this.availableGroups[this.creationActionI].subtypeValue, this.subscriptTxt.getText(), this.getSuperScript(), this.onAtoms.isSelected() ? 1 : 2, this.bracketTypeCombo.getSelectedIndex() == 0 ? 1 : 0);
        this.sgroup = null;
        medit.unselect();
        medit.historize();
    }

    private String getChargeLocation() {
        return Integer.toString(this.onAtoms.isSelected() ? 1 : 2);
    }

    private String getSuperScript() {
        return this.superscripts[this.superscriptCombo.getSelectedIndex()];
    }

    private void updateSuperScriptCombo(RepeatingUnitSgroup sg) {
        int j;
        String conn = "";
        if (sg.getConnectivity() == 1) {
            conn = conn.concat("hh");
            conn = conn.concat(sg.isFlipped() ? "f" : "n");
        } else if (sg.getConnectivity() == 2) {
            conn = conn.concat("ht");
            conn = conn.concat(sg.isFlipped() ? "f" : "n");
        } else if (sg.getConnectivity() == 0) {
            conn = conn.concat("eu");
            conn = conn.concat("n");
        }
        for (j = 0; j < this.superscripts.length && !this.superscripts[j].equalsIgnoreCase(conn); ++j) {
        }
        this.superscriptCombo.setSelectedIndex(j);
    }

    private String getSubscript() {
        return this.subscriptTxt.getText();
    }

    private void cancel() {
        this.creationActionI = this.savedCreationActionI;
        for (int i = this.availableGroups.length - 1; i >= 0; --i) {
            this.availableGroups[i].subscriptValue = this.availableGroups[i].savedSubscriptValue;
        }
        this.sketchPanel.getEditor().unselect();
    }

    private static boolean isAcceptableSuperatomName(String s) {
        return superAtomNamePattern.matcher(s).matches();
    }

    private boolean isAcceptableGroupMultiplier(String s) {
        return this.isPositiveInteger(s);
    }

    private boolean isAcceptableComponentIndex(String s) {
        return s.equals("") || s.equals("none") || this.isPositiveInteger(s);
    }

    private boolean isAcceptableRangedSru(String s) {
        return rangePattern.matcher(s).matches();
    }

    private boolean isAcceptableRgroupNumber(String s) {
        if (s.startsWith("R")) {
            s = s.substring(1);
        }
        return s.isEmpty() || this.isNonNegativeInteger(s) && Integer.parseInt(s) <= Short.MAX_VALUE;
    }

    private boolean isNonNegativeInteger(String s) {
        return this.isPositiveInteger(s) || s.trim().equals("0");
    }

    private boolean isPositiveInteger(String s) {
        boolean acceptable = false;
        try {
            acceptable = Integer.parseInt(s) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return acceptable;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        if (this.subscriptTxt != null) {
            this.subscriptTxt.removeKeyListener(this.escapeHandle);
            this.subscriptTxt.removeActionListener(this);
        }
        if (this.okay != null) {
            this.okay.removeActionListener(this);
        }
        if (this.cancel != null) {
            this.cancel.removeActionListener(this);
        }
        out.defaultWriteObject();
        if (this.subscriptTxt != null) {
            this.subscriptTxt.addKeyListener(this.escapeHandle);
            this.subscriptTxt.addActionListener(this);
        }
        if (this.okay != null) {
            this.okay.addActionListener(this);
        }
        if (this.cancel != null) {
            this.cancel.addActionListener(this);
        }
    }

    static {
        rangePattern = Pattern.compile("(([0-9][0-9]*){0,1}\\s*-{0,1}\\s*([0-9][0-9]*){0,1}\\s*,{0,1}\\s*)*(([0-9][0-9]*)\\s*-{0,1}\\s*([0-9][0-9]*){0,1})\\s*");
        superAtomNamePattern = Pattern.compile("[a-zA-Z0-9\\\\\\-+*/=.!?|~@#$%^_&()\\[\\]{}<>,;:`'][a-zA-Z0-9\\\\ \\-+*/=.!?|~@#$%^_&()\\[\\]{}<>,;:`'\\n]*");
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(GroupCreationDialog.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("GroupCreationDialog.properties not found");
        }
        RESOURCES = rc;
    }

    private class EscapeHandler
    extends KeyAdapter {
        private EscapeHandler() {
        }

        @Override
        public void keyReleased(KeyEvent ev) {
            if (ev.getKeyCode() == 27) {
                GroupCreationDialog.this.cancel();
                GroupCreationDialog.this.sketchPanel.closeGroupCreationDialog(GroupCreationDialog.this.dialog);
                return;
            }
            GroupCreationDialog.this.setOK();
        }
    }

    private class GroupType {
        private String typeName;
        private int create_action;
        private String subscriptValue;
        private String subscriptLabel;
        private String savedSubscriptValue;
        private int typeValue;
        private int subtypeValue;

        public GroupType(String name, int action, String value, String label, String savedValue, int type, int subtype) {
            this.typeName = name;
            this.create_action = action;
            this.subscriptValue = value;
            this.subscriptLabel = label;
            this.savedSubscriptValue = savedValue;
            this.typeValue = type;
            this.subtypeValue = subtype;
        }
    }
}

