/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.util.Environment;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;

public class InstallStyles {
    private static File styleDir;

    public static File getStyleDir() {
        return styleDir;
    }

    private static File createStyleDir() {
        if (Environment.UNTRUSTED) {
            return null;
        }
        File dir = DotfileUtil.getDotFile("styles");
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException sex) {
                System.err.println("Cannot create " + dir.getAbsolutePath());
                return null;
            }
        }
        return dir;
    }

    private static void installStyles() {
        styleDir = InstallStyles.createStyleDir();
        if (styleDir == null) {
            return;
        }
        ArrayList<String> sfsList = new ArrayList<String>();
        InputStream isb = BasicEnvironment.getResourceAsStream(InstallStyles.class, "/chemaxon/marvin/styles/styleFileList.properties");
        if (isb != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(isb));
            try {
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    sfsList.add(inputLine);
                }
                in.close();
                isb.close();
            }
            catch (IOException ioex) {
                System.err.println("Cannot read chemaxon/marvin/styles/styleFileList.properties");
            }
        } else {
            System.err.println("Cannot find chemaxon/marvin/styles/styleFileList.properties.");
        }
        int d = -1;
        for (int i = 0; i < sfsList.size(); ++i) {
            InputStream is = BasicEnvironment.getResourceAsStream(InstallStyles.class, "/chemaxon/marvin/styles/" + sfsList.get(i));
            if (is != null) {
                File f = new File(styleDir.getAbsolutePath() + File.separator + sfsList.get(i));
                if (f.exists()) continue;
                try {
                    FileOutputStream os = new FileOutputStream(f);
                    while ((d = is.read()) != -1) {
                        ((OutputStream)os).write(d);
                    }
                    is.close();
                    ((OutputStream)os).close();
                }
                catch (IOException ioex) {
                    System.err.println("Cannot copy " + sfsList.get(i) + " to " + f.getAbsolutePath());
                }
                continue;
            }
            System.err.println("Cannot find \"chemaxon/marvin/styles/" + sfsList.get(i) + "\"");
        }
    }

    static {
        InstallStyles.installStyles();
    }
}

