/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.PropertiesFileFilter;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.FormatDialog;
import chemaxon.marvin.sketch.swing.modules.FormatMoleculePanel;
import chemaxon.marvin.sketch.swing.modules.InstallStyles;
import chemaxon.marvin.swing.ActionButton;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.util.DotfileUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class LoadJournalStyleDialog
implements CallbackIface,
ActionListener,
FocusListener {
    private static final ResourceBundle RESOURCES;
    private static File styleDir;
    private SketchPanel sketchPanel;
    private FormatDialog formatDialog;
    private FormatMoleculePanel formatMoleculePanel;
    private JDialog dialog = null;
    private boolean canceled;
    private JComboBox journalStyleCombo;
    private String journalStyleVal;
    private Vector journalStyleFiles;
    private String usrDefJSFileName;
    private Action okAction = this.createAction("ok", "ok");
    private Action cancelAction = this.createAction("cancel", "cancel");
    private Action browseAction = this.createAction("browse", "browse");
    private String timerTask = null;
    private CallbackIface loadsavejs;
    private Vector journalStyles;
    private Vector journalStyleValues;

    public LoadJournalStyleDialog() {
        this.browseAction.setEnabled(!Environment.UNTRUSTED);
    }

    private Action createAction(String id, String labelKey) {
        DelegatingAction result = new DelegatingAction(id, MolPanel.GRESOURCES.getString(labelKey));
        result.addActionListener(this);
        return result;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)arg;
        } else if (method.equals("setFormatDialog")) {
            this.formatDialog = (FormatDialog)arg;
        } else if (method.equals("setFormatMoleculePanel")) {
            this.formatMoleculePanel = (FormatMoleculePanel)arg;
        } else if (method.equals("show")) {
            this.init();
            this.dialog.pack();
            try {
                Method m = JDialog.class.getMethod("setLocationRelativeTo", Component.class);
                m.invoke((Object)this.dialog, this.sketchPanel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.timerTask = "show";
            Timer tmr = new Timer(20, this);
            tmr.setRepeats(false);
            tmr.start();
        } else if (method.equals("setFileFromUsr")) {
            File reFile = (File)this.loadsavejs.callback("getFile", null);
            this.usrDefJSFileName = reFile.getPath();
            ActionEvent ev = new ActionEvent(this, 0, "close");
            this.okAction.actionPerformed(ev);
        } else if (method.equals("getStyleDir")) {
            return styleDir;
        }
        return null;
    }

    private void init() {
        Container parent;
        for (parent = this.sketchPanel; parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        if (parent instanceof Dialog) {
            this.dialog = new JDialog((Dialog)parent, true);
        } else if (parent instanceof Frame) {
            this.dialog = new JDialog((Frame)parent, true);
        }
        ResourceBundle rc = RESOURCES;
        this.dialog.setTitle(rc.getString("LoadJStyleDialog"));
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.top = 10;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.insets.bottom = 0;
        ++gbc.gridy;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbl.setConstraints(this.addJournalPanel(this.dialog), gbc);
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets.top = 2;
        gbc.insets.bottom = 1;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbl.setConstraints(this.addOkCancelPanel(this.dialog), gbc);
    }

    private JPanel addJournalPanel(JDialog dialog) {
        int k;
        ResourceBundle rc = RESOURCES;
        JPanel journalpanel = new JPanel();
        GridBagLayout jgbl = new GridBagLayout();
        journalpanel.setLayout(jgbl);
        GridBagConstraints jgbc = SwingUtil.createTopLeftConstraints();
        jgbc.insets.left = 10;
        jgbc.fill = 1;
        JLabel journalStyleLabel = new JLabel(rc.getString("JournalStyleLabel"));
        journalpanel.add(journalStyleLabel);
        jgbl.setConstraints(journalStyleLabel, jgbc);
        ++jgbc.gridx;
        this.journalStyleValues = this.readDirectory();
        if (this.journalStyleValues == null) {
            this.journalStyleValues = new Vector();
        }
        this.journalStyleCombo = new JComboBox(this.journalStyleValues);
        int j = -1;
        for (k = 0; k < this.journalStyles.size() && ((String)this.journalStyles.get(k)).compareTo("default.properties") != 0; ++k) {
        }
        if (this.journalStyleValues.size() > 0 && k >= 0 && k < this.journalStyleValues.size()) {
            j = k;
        } else if (this.journalStyleValues.size() > 0 && k == this.journalStyleValues.size()) {
            j = 0;
        }
        this.journalStyleCombo.setSelectedIndex(j);
        if (j >= 0 && j < this.journalStyleValues.size()) {
            this.journalStyleVal = (String)this.journalStyleValues.get(j);
        }
        this.journalStyleCombo.setActionCommand("jstyle");
        this.journalStyleCombo.addActionListener(this);
        journalpanel.add(this.journalStyleCombo);
        jgbl.setConstraints(this.journalStyleCombo, jgbc);
        ++jgbc.gridx;
        JPanel browsepanel = new JPanel();
        GridBagLayout bgbl = new GridBagLayout();
        browsepanel.setLayout(bgbl);
        GridBagConstraints bgbc = SwingUtil.createTopLeftConstraints();
        bgbc.insets.right = 10;
        bgbc.fill = 1;
        JButton browseButton = new JButton(this.browseAction);
        browsepanel.add(browseButton);
        bgbl.setConstraints(browseButton, bgbc);
        journalpanel.add(browsepanel);
        jgbl.setConstraints(browsepanel, jgbc);
        dialog.getContentPane().add(journalpanel);
        return journalpanel;
    }

    private Vector readDirectory() {
        Vector<String> styles = null;
        if (styleDir != null && styleDir.isDirectory()) {
            PropertiesFileFilter pff = new PropertiesFileFilter();
            File[] flist = styleDir.listFiles();
            this.journalStyles = new Vector(flist.length);
            this.journalStyleFiles = new Vector(flist.length);
            styles = new Vector<String>(flist.length);
            for (int i = 0; i < flist.length; ++i) {
                String fni;
                int j;
                if (!flist[i].isFile() || !pff.accept(flist[i])) continue;
                String fn = flist[i].getPath();
                String sn = this.getStyleName(fn);
                if (sn == null && (j = (fni = flist[i].getName()).lastIndexOf(46)) > 0) {
                    sn = fni.substring(0, j);
                }
                int n = styles.size();
                for (j = 0; j < n && sn.compareTo(styles.get(j).toString()) > 0; ++j) {
                }
                this.journalStyleFiles.insertElementAt(fn, j);
                styles.insertElementAt(sn, j);
                this.journalStyles.insertElementAt(flist[i].getName(), j);
            }
        }
        return styles;
    }

    private String getStyleName(String fname) {
        String sn = null;
        ResourceBundle rc = null;
        if (fname != null) {
            try {
                File file = new File(fname);
                FileInputStream in = new FileInputStream(file);
                rc = new PropertyResourceBundle(in);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.sketchPanel, "File " + fname + " not found", "File not found", 0);
            }
            catch (IOException ex) {
                this.sketchPanel.getErrorDisplay().error("Cannot import file " + fname, ex);
            }
            catch (MissingResourceException ex) {
                JOptionPane.showMessageDialog(this.sketchPanel, fname + " is not an acceptable journal style file ", "Missing Resource", 0);
            }
        }
        if (rc == null) {
            return null;
        }
        try {
            sn = rc.getString("StyleName");
        }
        catch (MissingResourceException ex) {
            sn = null;
        }
        return sn;
    }

    private JPanel addOkCancelPanel(JDialog dialog) {
        JPanel panel = new JPanel();
        dialog.getContentPane().add(panel);
        panel.add(new ActionButton(this.okAction));
        panel.add(new ActionButton(this.cancelAction));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object t = ev.getSource();
        if (t instanceof Timer) {
            if (this.timerTask.equals("show")) {
                this.showDialog();
            }
        } else {
            String cmd = ev.getActionCommand();
            if (cmd.equals("ok")) {
                this.dialog.setVisible(false);
                this.canceled = false;
                this.sketchPanel.getEditor().historize();
            } else if (cmd.equals("cancel")) {
                this.dialog.setVisible(false);
            } else if (cmd.equals("jstyle")) {
                this.journalStyleVal = this.journalStyleValues.get(this.journalStyleCombo.getSelectedIndex()).toString();
            } else if (cmd.equals("browse")) {
                this.loadsavejs = (CallbackIface)MarvinModule.load("sketch.swing.LoadSaveJSDialog", this.sketchPanel);
                this.loadsavejs.callback("setSketchPanel", this.sketchPanel);
                this.loadsavejs.callback("setLoadJSDialog", this);
                this.loadsavejs.callback("setFile", styleDir != null ? styleDir : DotfileUtil.getDotDir());
                String[] command = new String[]{"open"};
                this.loadsavejs.callback("setCommand", command);
            } else if (cmd.equals("close")) {
                this.dialog.setVisible(false);
            }
        }
    }

    private void showDialog() {
        this.canceled = true;
        this.dialog.setVisible(true);
        if (!this.canceled) {
            ResourceBundle rc = null;
            String fname = null;
            if (this.journalStyleVal != null && this.usrDefJSFileName == null) {
                int n = this.journalStyleFiles.size();
                for (int i = 0; i < n && fname == null; ++i) {
                    if (this.journalStyleValues.elementAt(i).toString().compareTo(this.journalStyleVal) != 0) continue;
                    fname = this.journalStyleFiles.elementAt(i).toString();
                }
            } else if (this.usrDefJSFileName != null) {
                fname = this.usrDefJSFileName;
            }
            if (fname != null) {
                try {
                    File file = new File(fname);
                    FileInputStream in = new FileInputStream(file);
                    rc = new PropertyResourceBundle(in);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(this.sketchPanel, "File " + fname + " not found", "File not found", 0);
                }
                catch (IOException ex) {
                    this.sketchPanel.getErrorDisplay().error("Cannot import file " + fname, ex);
                }
                catch (MissingResourceException ex) {
                    JOptionPane.showMessageDialog(this.sketchPanel, fname + " is not an acceptable journal style file ", "Missing Resource", 0);
                }
            }
            try {
                if (rc == null) {
                    throw new MissingResourceException("Style is not selected or invalid", "LoadJournalStyleDialog", "Missing style");
                }
                Object[] attrVals = new Object[6];
                String arg = rc.getString("FontName");
                attrVals[0] = arg;
                arg = rc.getString("FontStyle");
                attrVals[1] = arg;
                arg = rc.getString("FontSize");
                attrVals[2] = new Double(arg);
                arg = rc.getString("FontColor");
                if (arg.equals("default")) {
                    attrVals[3] = null;
                } else {
                    try {
                        attrVals[3] = new Integer(arg);
                    }
                    catch (NumberFormatException ex) {
                        attrVals[3] = arg;
                    }
                }
                arg = rc.getString("BondThickness");
                attrVals[4] = new Double(arg);
                arg = rc.getString("BondColor");
                if (arg.equals("default")) {
                    attrVals[5] = null;
                } else {
                    try {
                        attrVals[5] = new Integer(arg);
                    }
                    catch (NumberFormatException ex) {
                        attrVals[5] = arg;
                    }
                }
                if (this.formatDialog != null) {
                    this.formatDialog.callback("loadAttrPanels", attrVals);
                }
                if (this.formatMoleculePanel != null) {
                    this.formatMoleculePanel.callback("loadAttrPanels", attrVals);
                }
            }
            catch (MissingResourceException ex) {
                JOptionPane.showMessageDialog(this.sketchPanel, "The selected file is not an acceptable journal style", "Missing Resource", 0);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent ev) {
    }

    @Override
    public void focusLost(FocusEvent ev) {
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = SketchPanel.getResourceBundle(LoadJournalStyleDialog.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("LoadJournalStyleDialog.properties not found");
        }
        RESOURCES = rc;
        styleDir = InstallStyles.getStyleDir();
    }
}

