/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.common.swing.modules.LoadSaveBase;
import chemaxon.marvin.common.swing.modules.PropertiesFileFilter;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.FormatDialog;
import chemaxon.marvin.sketch.swing.modules.FormatMoleculePanel;
import chemaxon.marvin.sketch.swing.modules.LoadJournalStyleDialog;
import chemaxon.marvin.util.CallbackIface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.MissingResourceException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;

public class LoadSaveJSDialog
extends LoadSaveBase
implements CallbackIface,
ActionListener {
    private static final int SAVE_CANCEL = 0;
    private static final int SAVE_NO = 1;
    private static final int SAVE_OVERWRITE = 2;
    private static final int SAVE_RECREATE = 3;
    private SketchPanel sketchPanel = null;
    private LoadJournalStyleDialog loadJournalStyleDialog = null;
    private FormatDialog formatDialog = null;
    private FormatMoleculePanel formatMoleculePanel = null;
    private File jsFile = null;
    private File pwd = null;
    private String format = "properties";
    private Object[] command;
    private int saveMode = 0;

    public LoadSaveJSDialog() {
        try {
            this.pwd = new File(System.getProperty("user.dir"));
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Object callback(String cmd, Object arg) {
        if (cmd.equals("setSketchPanel")) {
            this.sketchPanel = (SketchPanel)arg;
        } else if (cmd.equals("setFormatDialog")) {
            this.formatDialog = (FormatDialog)arg;
        } else if (cmd.equals("setFormatMoleculePanel")) {
            this.formatMoleculePanel = (FormatMoleculePanel)arg;
        } else if (cmd.equals("setLoadJSDialog")) {
            this.loadJournalStyleDialog = (LoadJournalStyleDialog)arg;
        } else if (cmd.equals("setFile")) {
            File f = (File)arg;
            this.jsFile = f.isDirectory() ? null : f;
            this.setPwd(f);
        } else {
            if (cmd.equals("getFile")) {
                return this.jsFile;
            }
            if (cmd.equals("setCommand")) {
                this.command = (Object[])arg;
                Timer t = new Timer(20, this);
                t.setRepeats(false);
                t.start();
            }
        }
        return null;
    }

    private void setPwd(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                this.pwd = f;
            } else {
                String s = f.getParent();
                if (s != null) {
                    this.pwd = new File(s);
                }
            }
        }
    }

    private JFileChooser makeChooser() {
        File cwd = this.pwd;
        JFileChooser w = cwd != null ? new JFileChooser(cwd) : new JFileChooser();
        PropertiesFileFilter pff = new PropertiesFileFilter();
        w.addChoosableFileFilter(pff);
        return w;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object t = e.getSource();
        if (t instanceof Timer) {
            Object[] v = this.command;
            if (v[0].equals("open")) {
                File f = null;
                if (v[0] != null && v[0] instanceof File) {
                    f = (File)v[0];
                } else {
                    JFileChooser chooser = this.makeChooser();
                    int r = chooser.showOpenDialog(this.sketchPanel);
                    if (r == 0) {
                        f = chooser.getSelectedFile();
                    }
                }
                if (f != null) {
                    this.jsFile = f;
                    this.loadJournalStyleDialog.callback("setFileFromUsr", this);
                }
            } else if (v[0].equals("saveAs")) {
                JFileChooser w = this.makeChooser();
                do {
                    this.saveAs(w);
                } while (this.saveMode == 1);
            }
        }
    }

    private void saveAs(JFileChooser w) {
        File newfile;
        int r = w.showSaveDialog(this.sketchPanel);
        this.saveMode = 0;
        if (r == 0 && (newfile = w.getSelectedFile()) != null) {
            String fmt = this.format;
            this.setPwd(newfile);
            String ext = MFileFormatUtil.getFileExtensionLC(newfile);
            FileFilter ff = w.getFileFilter();
            if (ff instanceof PropertiesFileFilter) {
                PropertiesFileFilter pff = (PropertiesFileFilter)ff;
                fmt = pff.getFormat();
                if (ext == null) {
                    ext = pff.getExtension();
                    newfile = new File(newfile.getPath() + "." + ext);
                }
            }
            if (ext == null && fmt != null) {
                ext = fmt;
                newfile = new File(newfile.getPath() + "." + ext);
            }
            if (fmt == null || !fmt.equals(ext)) {
                JOptionPane.showMessageDialog(null, "Style can be saved in .properties extension file./n" + newfile.getName() + " has wrong extension.", "Unknown output file format", 0);
                this.saveMode = 1;
                return;
            }
            this.format = fmt;
            this.saveMode = this.prepareSaving(newfile);
            this.jsFile = newfile;
            if (this.saveMode != 0 && this.saveMode != 1) {
                try {
                    if (!this.save(this.jsFile)) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Save was not successfull", "Save aborted", 0);
                }
                if (this.formatDialog != null) {
                    this.formatDialog.callback("loadAttrPanels", null);
                }
                if (this.formatMoleculePanel != null) {
                    this.formatMoleculePanel.callback("loadAttrPanels", null);
                }
            }
        }
    }

    private int prepareSaving(File f) {
        if (f.exists()) {
            int mode = JOptionPane.showConfirmDialog(this.sketchPanel, "File " + f.getName() + " exists. Overwrite?", "File exists", 0, 2);
            return mode == 0 ? 2 : 1;
        }
        try {
            if (!f.createNewFile()) {
                throw new IOException();
            }
            return 3;
        }
        catch (IOException ex) {
            this.sketchPanel.getErrorDisplay().error("Cannot create new file with name " + f.getName(), ex);
            return 1;
        }
    }

    private boolean save(File f) {
        Object[] attrs = this.command;
        switch (this.saveMode) {
            case 2: {
                if (f.canRead() && f.canWrite()) {
                    try {
                        int i;
                        RandomAccessFile raf = new RandomAccessFile(f, "rw");
                        long fSize = raf.length();
                        String line = raf.readLine();
                        String eol = System.getProperty("line.separator");
                        while (line != null && (line.equals("") || line.startsWith("#"))) {
                            line = raf.readLine();
                        }
                        if (line == null) {
                            throw new IOException("Read error in replaceFileContents");
                        }
                        long pos = raf.getFilePointer() - (long)line.getBytes().length - 2L;
                        if (pos < 0L) {
                            pos = 0L;
                        }
                        if ((i = line.indexOf("=")) > 0) {
                            String key = line.substring(0, i);
                            if (!key.equals("FontName")) {
                                throw new MissingResourceException(f.getName() + " is not a journal style properties file. Can " + "not overwrite!", f.getName(), "badResource");
                            }
                        } else {
                            throw new MissingResourceException(null, null, null);
                        }
                        byte[] content = ("FontName=" + attrs[1] + eol + "FontStyle=" + attrs[2] + eol + "FontSize=" + attrs[3] + eol + "FontColor=" + attrs[4] + eol + "BondThickness=" + attrs[5] + eol + "BondColor=" + attrs[6] + eol).getBytes();
                        this.replaceFileContents(raf, pos, fSize, content);
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(this.sketchPanel, "File " + f.getName() + " not found", "File not found", 0);
                    }
                    catch (IOException ex) {
                        this.sketchPanel.getErrorDisplay().error("Read/Write error in file " + f.getName(), ex);
                    }
                    catch (MissingResourceException ex) {
                        if (ex.getKey().equals("badResource")) {
                            JOptionPane.showMessageDialog(this.sketchPanel, ex.getMessage(), "Illegal Resource", 0);
                        }
                        JOptionPane.showMessageDialog(this.sketchPanel, f.getName() + " is not an acceptable style file ", "Missing Resource", 0);
                    }
                }
                return true;
            }
            case 3: {
                if (f.canWrite()) {
                    String content = "FontName=" + attrs[1] + "\n" + "FontStyle=" + attrs[2] + "\n" + "FontSize=" + attrs[3] + "\n" + "FontColor=" + attrs[4] + "\n" + "BondThickness=" + attrs[5] + "\n" + "BondColor=" + attrs[6] + "\n";
                    this.simpleWrite(f, content, false);
                }
                return true;
            }
        }
        return false;
    }
}

