/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.FontAttrPanel;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.modules.MObjectDoubleProp;
import chemaxon.marvin.sketch.swing.MolIcon;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.util.text.MStringTokenizer;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MTextBox;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MObjectPropertiesPanel
extends JPanel
implements ActionListener,
FocusListener {
    public static final String TITLE;
    private static final ResourceBundle RESOURCES;
    private static final int ARROW_LENGTH = 0;
    private static final int ARROW_WIDTH = 1;
    private static final int[] ARROW_FLAGS;
    private SketchPanel sketchPanel;
    private JDialog parentDialog;
    private MObject[] mObjects;
    private boolean badvalue = false;
    private JLabel bgColorLabel;
    private JButton bgColorButton;
    private Color bgColorVal;
    private boolean bgColorSet = false;
    private JLabel lineColorLabel;
    private JButton lineColorButton;
    private Color lineColorVal;
    private boolean lineColorSet = false;
    private MObjectDoubleProp[] lineDoubleProps = new MObjectDoubleProp[0];
    private JLabel[] lineDoublePropLabels = new JLabel[0];
    private JTextField[] lineDoublePropTFs = new JTextField[0];
    private JLabel rectTOptionLabel;
    private JComboBox rectTOptionCombo;
    private boolean rectTOptionSet = false;
    private JLabel rectTCenterLabel;
    private JComboBox rectTCenterCombo;
    private boolean rectTCenterSet = false;
    private JComboBox[] arrowCombo = new JComboBox[2];
    private JComboBox[] arrowDirCombo = new JComboBox[2];
    private JLabel[] arrowLabels = new JLabel[2];
    private JLabel[] arrowLengthLabels = new JLabel[2];
    private JLabel[] arrowWidthLabels = new JLabel[2];
    private JTextField[] arrowLengthTF = new JTextField[2];
    private JTextField[] arrowWidthTF = new JTextField[2];
    private Double[] arrowLengthVals = new Double[2];
    private boolean[] arrowSet = new boolean[2];
    private Double[] arrowWidthVals = new Double[2];
    private JButton[] arrowResetButton = new JButton[2];
    private FontAttrPanel textFontPanel;

    public MObjectPropertiesPanel(SketchPanel skpan, MObject[] mobjs, JDialog pdialog) {
        this.sketchPanel = skpan;
        this.mObjects = mobjs;
        this.parentDialog = pdialog;
        for (Container parent = this.sketchPanel; parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        MObjectPropertiesPanel contentPane = this;
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.top = 5;
        gbc.insets.left = 5;
        gbc.insets.right = 5;
        gbc.insets.bottom = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        if (MObjectPropertiesPanel.hasText(this.mObjects)) {
            gbl.setConstraints(contentPane.add(this.createTextPanel()), gbc);
            ++gbc.gridy;
        }
        if (MObjectPropertiesPanel.hasLine(this.mObjects)) {
            gbc.gridwidth = 1;
            gbl.setConstraints(contentPane.add(this.createLinesPanel()), gbc);
            if (MObjectPropertiesPanel.hasRectangle(this.mObjects)) {
                ++gbc.gridx;
                gbl.setConstraints(contentPane.add(this.createRectangleTransformPanel()), gbc);
                gbc.gridx = 0;
                gbc.gridwidth = 2;
            }
            ++gbc.gridy;
            if (MObjectPropertiesPanel.hasLineEnds(this.mObjects)) {
                gbl.setConstraints(contentPane.add(this.createLineEndsPanel()), gbc);
                ++gbc.gridy;
            }
        }
        if (MObjectPropertiesPanel.hasBackground(this.mObjects)) {
            gbl.setConstraints(contentPane.add(this.createBackgroundPanel()), gbc);
            ++gbc.gridy;
        }
    }

    public boolean hasBadValue() {
        return this.badvalue;
    }

    private JPanel createBackgroundPanel() {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("backgroundLabel"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        this.bgColorLabel = new JLabel(rc.getString("colorLabel"));
        gbl.setConstraints(panel.add(this.bgColorLabel), gbc);
        ++gbc.gridx;
        this.bgColorVal = MObjectPropertiesPanel.getBackground(this.mObjects);
        this.bgColorButton = FontAttrPanel.createColorChooser(this, "bgColor", this.bgColorVal);
        this.bgColorSet = false;
        gbl.setConstraints(panel.add(this.bgColorButton), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JButton b = FontAttrPanel.createResetColorButton(this, "resetBgColor");
        gbl.setConstraints(panel.add(b), gbc);
        return panel;
    }

    private JPanel createLinesPanel() {
        ResourceBundle rc = RESOURCES;
        String key = this.mObjects.length == 1 ? (this.mObjects[0] instanceof MRectangle ? "lineOutlineLabel" : "lineLabel") : "lineLinesAndOutlinesLabel";
        JPanel panel = SwingUtil.createSubPanel(rc.getString(key));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        this.lineColorLabel = new JLabel(rc.getString("colorLabel"));
        gbl.setConstraints(panel.add(this.lineColorLabel), gbc);
        ++gbc.gridx;
        this.lineColorVal = MObjectPropertiesPanel.getLineColor(this.mObjects);
        this.lineColorButton = FontAttrPanel.createColorChooser(this, "lineColor", this.lineColorVal);
        this.lineColorSet = false;
        gbl.setConstraints(panel.add(this.lineColorButton), gbc);
        ++gbc.gridx;
        gbl.setConstraints(panel.add(new JLabel()), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JButton b = FontAttrPanel.createResetColorButton(this, "resetLineColor");
        gbl.setConstraints(panel.add(b), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.top = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.addLineDoubleProp(gbl, gbc, panel, 2, "lineThickness", "lineThicknessLabel", 0, "thickness", this.mObjects, MPolyline.DEFAULT_THICKNESS, 0.0, 2);
        gbc.fill = 0;
        gbl.setConstraints(panel.add(new JLabel()), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbl.setConstraints(panel.add(this.createResetButton("resetLineThickness", "valueResetToolTip")), gbc);
        if (MObjectPropertiesPanel.hasArc(this.mObjects)) {
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.insets.top = 5;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.addLineDoubleProp(gbl, gbc, panel, 2, "lineArcAngle", "lineArcAngleLabel", 1, "arcAngle", this.mObjects, 0.0, 0.0, 0);
            gbc.fill = 0;
            gbl.setConstraints(panel.add(new JLabel("degrees", 2)), gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbl.setConstraints(panel.add(this.createResetButton("resetLineArcAngle", "valueResetToolTip")), gbc);
        }
        return panel;
    }

    private JPanel createRectangleTransformPanel() {
        ResourceBundle rc = RESOURCES;
        String key = "rectTransformLabel";
        JPanel panel = SwingUtil.createSubPanel(rc.getString(key));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        this.rectTOptionLabel = new JLabel(rc.getString("rectTOptionLabel"));
        gbl.setConstraints(panel.add(this.rectTOptionLabel), gbc);
        String[] labels = MStringTokenizer.getStringArrayRC("rectTOptionList", rc);
        this.rectTOptionCombo = new JComboBox<String>(labels);
        this.rectTOptionCombo.setSelectedIndex(MObjectPropertiesPanel.getTOption(this.mObjects));
        this.rectTOptionCombo.setActionCommand("rectTOptions");
        this.rectTOptionCombo.addActionListener(this);
        ++gbc.gridx;
        gbc.fill = 2;
        gbl.setConstraints(panel.add(this.rectTOptionCombo), gbc);
        this.rectTOptionSet = false;
        this.rectTCenterLabel = new JLabel(rc.getString("rectTCenterLabel"));
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.top = 5;
        gbc.fill = 0;
        gbl.setConstraints(panel.add(this.rectTCenterLabel), gbc);
        labels = MStringTokenizer.getStringArrayRC("rectTCenterList", rc);
        this.rectTCenterCombo = new JComboBox<String>(labels);
        int k = MObjectPropertiesPanel.getRectangleTCenter(this.mObjects);
        if (k >= 0) {
            this.rectTCenterCombo.setSelectedIndex(k);
        }
        this.rectTCenterCombo.setActionCommand("rectTCenter");
        this.rectTCenterCombo.addActionListener(this);
        ++gbc.gridx;
        gbc.fill = 2;
        gbl.setConstraints(panel.add(this.rectTCenterCombo), gbc);
        this.rectTCenterSet = false;
        return panel;
    }

    private JPanel createLineEndsPanel() {
        ResourceBundle rc = RESOURCES;
        JPanel panel = SwingUtil.createSubPanel(rc.getString("lineEndsLabel"));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = SwingUtil.createTopLeftConstraints();
        gbc.insets.right = 10;
        gbc.insets.top = 5;
        for (int i = 1; i >= 0; --i) {
            boolean enable;
            this.arrowLengthVals[i] = MObjectPropertiesPanel.getArrowProp(this.mObjects, i, 0);
            this.arrowWidthVals[i] = MObjectPropertiesPanel.getArrowProp(this.mObjects, i, 1);
            int flags = MObjectPropertiesPanel.getArrowFlags(this.mObjects, i);
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            String key = i == MPolyline.HEAD ? "arrowHeadLabel" : "arrowTailLabel";
            this.arrowLabels[i] = new JLabel(rc.getString(key));
            gbl.setConstraints(panel.add(this.arrowLabels[i]), gbc);
            ++gbc.gridx;
            boolean bl = enable = this.arrowWidthVals[i] != null;
            if (this.arrowLengthVals[i] == null || this.arrowWidthVals[i] == null) {
                double width;
                UserSettings settings = this.sketchPanel.getUserSettings();
                double length = i == MPolyline.HEAD ? settings.getSketchArrowHeadLength() : settings.getSketchArrowTailLength();
                double d = width = i == MPolyline.HEAD ? settings.getSketchArrowHeadWidth() : settings.getSketchArrowTailWidth();
                if (this.arrowLengthVals[i] == null) {
                    this.arrowLengthVals[i] = new Double(length);
                }
                if (this.arrowWidthVals[i] == null) {
                    this.arrowWidthVals[i] = new Double(width);
                }
            }
            Object[] labels = this.getArrowIcons(i, flags);
            this.arrowCombo[i] = new JComboBox<Object>(labels);
            if (enable) {
                for (int j = 1; j < ARROW_FLAGS.length; ++j) {
                    if (ARROW_FLAGS[j] != (flags & ~MPolyline.ARROW_BACK_FLAG)) continue;
                    this.arrowCombo[i].setSelectedIndex(j);
                    break;
                }
            }
            this.arrowCombo[i].setActionCommand("arrowType" + i);
            this.arrowCombo[i].addActionListener(this);
            gbl.setConstraints(panel.add(this.arrowCombo[i]), gbc);
            ++gbc.gridx;
            labels = new Object[]{rc.getString("arrowDirectionForward"), rc.getString("arrowDirectionBack")};
            this.arrowDirCombo[i] = new JComboBox<Object>(labels);
            this.arrowDirCombo[i].setEnabled(enable);
            this.arrowDirCombo[i].setSelectedIndex((flags & MPolyline.ARROW_BACK_FLAG) != 0 ? 1 : 0);
            this.arrowDirCombo[i].setActionCommand("arrowDirection" + i);
            this.arrowDirCombo[i].addActionListener(this);
            gbl.setConstraints(panel.add(this.arrowDirCombo[i]), gbc);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            ++gbc.gridx;
            this.arrowSet[i] = false;
            this.arrowLengthLabels[i] = new JLabel(rc.getString("arrowLengthLabel"), 4);
            this.arrowLengthLabels[i].setEnabled(enable);
            gbl.setConstraints(panel.add(this.arrowLengthLabels[i]), gbc);
            this.arrowLengthTF[i] = new JTextField(5);
            panel.add(this.arrowLengthTF[i]);
            this.arrowLengthTF[i].setActionCommand("arrowLength" + i);
            this.arrowLengthTF[i].setText(this.arrowLengthVals != null && this.arrowLengthVals[i] != null ? this.arrowLengthVals[i].toString() : "0");
            this.arrowLengthTF[i].setEnabled(enable);
            this.arrowLengthTF[i].addFocusListener(this);
            this.arrowLengthTF[i].addActionListener(this);
            ++gbc.gridx;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbl.setConstraints(this.arrowLengthTF[i], gbc);
            ++gbc.gridx;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.arrowWidthLabels[i] = new JLabel(rc.getString("arrowWidthLabel"));
            this.arrowWidthLabels[i].setEnabled(enable);
            gbl.setConstraints(panel.add(this.arrowWidthLabels[i]), gbc);
            this.arrowWidthTF[i] = new JTextField(5);
            panel.add(this.arrowWidthTF[i]);
            this.arrowWidthTF[i].setActionCommand("arrowWidth" + i);
            this.arrowWidthTF[i].setText(this.arrowWidthVals != null && this.arrowWidthVals[i] != null ? this.arrowWidthVals[i].toString() : "0");
            this.arrowWidthTF[i].setEnabled(enable);
            this.arrowWidthTF[i].addFocusListener(this);
            this.arrowWidthTF[i].addActionListener(this);
            ++gbc.gridx;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbl.setConstraints(this.arrowWidthTF[i], gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            this.arrowResetButton[i] = this.createResetButton("resetArrow" + i, "valueResetToolTip");
            this.arrowResetButton[i].setEnabled(enable);
            gbl.setConstraints(panel.add(this.arrowResetButton[i]), gbc);
            ++gbc.gridy;
            gbc.gridx = 5;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.addLineDoubleProp(gbl, gbc, panel, 4, "lineSkip" + i, "lineSkipLabel", 2 + i, i == MPolyline.HEAD ? "headSkip" : "tailSkip", this.mObjects, 0.0, 0.0, 0);
            gbc.weightx = 1.0;
            gbl.setConstraints(panel.add(this.createResetButton("resetLineSkip" + i, "valueResetToolTip")), gbc);
            ++gbc.gridy;
        }
        return panel;
    }

    private void enableArrowProps(int i, boolean enable) {
        int k = this.arrowCombo[i].getSelectedIndex();
        boolean v = k != 0 && enable;
        this.arrowDirCombo[i].setEnabled(v);
        this.arrowLengthLabels[i].setEnabled(v);
        this.arrowLengthTF[i].setEnabled(v);
        this.arrowWidthLabels[i].setEnabled(v);
        this.arrowWidthTF[i].setEnabled(v);
        this.arrowResetButton[i].setEnabled(v);
    }

    private boolean isLineVisible() {
        return this.lineColorVal != null || this.bgColorVal == null;
    }

    private Object[] getArrowIcons(int i, int flags) {
        Object[] icons = new Object[ARROW_FLAGS.length];
        int w = 32;
        int h = 12;
        for (int j = 0; j < icons.length; ++j) {
            MPoint p1 = new MPoint(0.0, 0.5 * (double)h, 0.0);
            MPoint p2 = new MPoint(w, 0.5 * (double)h, 0.0);
            MPolyline pl = new MPolyline(p1, p2);
            double lw = MPolyline.DEFAULT_THICKNESS;
            double aw = 0.5;
            double al = 0.8;
            double c = 0.75 * (double)h / aw;
            pl.setThickness(c * lw);
            if (j > 0) {
                int f = ARROW_FLAGS[j] | flags & MPolyline.ARROW_BACK_FLAG;
                pl.setArrowFlags(i, f);
                pl.setArrowLength(i, c * al);
                pl.setArrowWidth(i, c * aw);
            }
            icons[j] = new MolIcon(pl, w, h);
        }
        return icons;
    }

    private JPanel createTextPanel() {
        ResourceBundle rc = RESOURCES;
        JTextArea msg = null;
        int nrich = MObjectPropertiesPanel.countRichTextBoxes(this.mObjects);
        if (nrich != 0) {
            String key = this.mObjects.length == 1 ? "baseFontRichTextWarning1" : (nrich == 1 ? "baseFontRichTextWarningA" : "baseFontRichTextWarning2");
            msg = new JTextArea(rc.getString(key));
            msg.setEditable(false);
        }
        this.textFontPanel = new FontAttrPanel(rc.getString("textLabel"), 10, MObjectPropertiesPanel.getBaseFontFamily(this.mObjects), MObjectPropertiesPanel.getBaseFontStyle(this.mObjects), MObjectPropertiesPanel.getFontScale(this.mObjects), MObjectPropertiesPanel.getColor(this.mObjects), MObjectPropertiesPanel.getHorizontalAlignment(this.mObjects), MObjectPropertiesPanel.getVerticalAlignment(this.mObjects), msg);
        this.textFontPanel.setFontFamilyLabel(rc.getString("baseFontLabel"));
        this.textFontPanel.setSizeLabel(rc.getString("fontScaleLabel"));
        this.textFontPanel.setSizeToolTip(rc.getString("fontScaleToolTip"));
        return this.textFontPanel;
    }

    private JButton createResetButton(String cmd, String tip) {
        ResourceBundle rc = RESOURCES;
        JButton b = new JButton(rc.getString("reset"));
        b.setActionCommand(cmd);
        b.setToolTipText(rc.getString(tip));
        b.addActionListener(this);
        return b;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        block16: {
            String cmd;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                cmd = ev.getActionCommand();
                                if (!cmd.equals("bgColor")) break block15;
                                Color c = this.sketchPanel.showColorChooserDialog(this.bgColorVal);
                                if (c == null) break block16;
                                this.setBgColorProp(c);
                                break block16;
                            }
                            if (!cmd.equals("resetBgColor")) break block17;
                            this.setBgColorProp(null);
                            break block16;
                        }
                        if (!cmd.equals("lineColor")) break block18;
                        Color c = this.sketchPanel.showColorChooserDialog(this.lineColorVal);
                        if (c == null) break block16;
                        this.setLineColorProp(c);
                        break block16;
                    }
                    if (!cmd.equals("rectTOptions")) break block19;
                    if (this.rectTOptionSet) break block16;
                    this.rectTOptionSet = true;
                    this.setProp(this.rectTOptionLabel);
                    break block16;
                }
                if (!cmd.equals("rectTCenter")) break block20;
                if (this.rectTCenterSet) break block16;
                this.rectTCenterSet = true;
                this.setProp(this.rectTCenterLabel);
                break block16;
            }
            if (cmd.startsWith("arrowType")) {
                int i = cmd.charAt(9) - 48;
                this.enableArrowProps(i, this.isLineVisible());
                this.setArrowProp(i, this.arrowSet, this.arrowLabels);
            } else if (cmd.startsWith("arrowDirection")) {
                int i = cmd.charAt(14) - 48;
                int k = this.arrowCombo[i].getSelectedIndex();
                int f = ARROW_FLAGS[k];
                if (this.arrowDirCombo[i].getSelectedIndex() == 1) {
                    f |= MPolyline.ARROW_BACK_FLAG;
                }
                this.arrowCombo[i].setModel(new DefaultComboBoxModel<Object>(this.getArrowIcons(i, f)));
                this.arrowCombo[i].setSelectedIndex(k);
                this.setArrowProp(i, this.arrowSet, this.arrowLabels);
            } else if (cmd.startsWith("arrowLength")) {
                int i = cmd.charAt(11) - 48;
                this.setArrow(i, this.arrowSet, this.arrowLabels, this.arrowLengthVals, this.arrowLengthTF);
            } else if (cmd.startsWith("arrowWidth")) {
                int i = cmd.charAt(10) - 48;
                this.setArrow(i, this.arrowSet, this.arrowLabels, this.arrowWidthVals, this.arrowWidthTF);
            } else if (cmd.equals("resetLineColor")) {
                this.setLineColorProp(null);
            } else if (cmd.startsWith("resetArrow")) {
                int i = cmd.charAt(10) - 48;
                double length = 0.8;
                double width = 0.5;
                this.arrowLengthVals[i] = new Double(length);
                this.arrowWidthVals[i] = new Double(width);
                this.arrowLengthTF[i].setText(String.valueOf(length));
                this.arrowWidthTF[i].setText(String.valueOf(width));
                this.setArrowProp(i, this.arrowSet, this.arrowLabels);
            } else {
                for (int i = 0; i < this.lineDoubleProps.length; ++i) {
                    MObjectDoubleProp p = this.lineDoubleProps[i];
                    JTextField tf = this.lineDoublePropTFs[i];
                    String cmdi = p.getActionCommand();
                    String resetcmd = "reset" + cmdi.substring(0, 1).toUpperCase() + cmdi.substring(1);
                    if (cmdi.equals(cmd)) {
                        this.setDoubleProp(i);
                        break;
                    }
                    if (!resetcmd.equals(cmd)) continue;
                    p.setDefault();
                    Double v = p.getValue();
                    tf.setText(v != null ? v.toString() : String.valueOf(p.getDefaultValue()));
                    JLabel l = this.lineDoublePropLabels[i];
                    if (p.isSet()) break;
                    this.setProp(l);
                    break;
                }
            }
        }
        this.badvalue = false;
    }

    private void setDoubleProp(int i) {
        MObjectDoubleProp p = this.lineDoubleProps[i];
        JTextField tf = this.lineDoublePropTFs[i];
        try {
            p.setValue(tf.getText());
        }
        catch (IllegalArgumentException ex) {
            this.badvalue = true;
            JOptionPane.showMessageDialog(this.parentDialog, ex.getMessage(), "Invalid value", 0);
            Double v = p.getValue();
            tf.setText(v != null ? v.toString() : String.valueOf(p.getDefaultValue()));
            return;
        }
        if (p.isSet()) {
            JLabel l = this.lineDoublePropLabels[i];
            this.setProp(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performChanges() {
        UserSettings settings = this.sketchPanel.getUserSettings();
        MolEditor medit = this.sketchPanel.getEditor();
        medit.setHistorizeEnabled(false);
        try {
            for (int i = 0; i < this.mObjects.length; ++i) {
                MObject o = this.mObjects[i];
                if (this.bgColorSet && o.hasBackground()) {
                    medit.edit(2, o, this.bgColorVal);
                }
                if (this.lineColorSet && o.hasLineColor()) {
                    medit.edit(1, o, this.lineColorVal);
                }
                for (int j = 0; j < this.lineDoubleProps.length; ++j) {
                    MObjectDoubleProp p = this.lineDoubleProps[j];
                    if (!p.isSet()) continue;
                    Double v = p.getValue();
                    medit.edit(p.getMolEditorCommand(), o, v != null ? v.doubleValue() : p.getDefaultValueToSet());
                }
                if (o instanceof MPolyline) {
                    int cmdarrf = 2;
                    int cmdarrl = 4;
                    int cmdarrw = 6;
                    for (int j = 0; j < 2; ++j) {
                        if (this.arrowCombo[j] == null) continue;
                        double l = 0.0;
                        double w = 0.0;
                        int k = this.arrowCombo[j].getSelectedIndex();
                        int f = ARROW_FLAGS[k];
                        if (k != 0) {
                            l = this.arrowLengthVals[j];
                            w = this.arrowWidthVals[j];
                        }
                        if (this.arrowDirCombo[j].getSelectedIndex() == 1) {
                            f |= MPolyline.ARROW_BACK_FLAG;
                        }
                        if (!this.arrowSet[j]) continue;
                        medit.edit(cmdarrf + j, o, f);
                        medit.edit(cmdarrl + j, o, l);
                        medit.edit(cmdarrw + j, o, w);
                    }
                    if (this.arrowLengthVals[MPolyline.HEAD] != null) {
                        settings.setSketchArrowHeadLength(this.arrowLengthVals[MPolyline.HEAD]);
                    }
                    if (this.arrowWidthVals[MPolyline.HEAD] != null) {
                        settings.setSketchArrowHeadWidth(this.arrowWidthVals[MPolyline.HEAD]);
                    }
                    if (this.arrowLengthVals[MPolyline.TAIL] != null) {
                        settings.setSketchArrowTailLength(this.arrowLengthVals[MPolyline.TAIL]);
                    }
                    if (this.arrowWidthVals[MPolyline.TAIL] != null) {
                        settings.setSketchArrowTailWidth(this.arrowWidthVals[MPolyline.TAIL]);
                    }
                }
                if (o instanceof MRectangle) {
                    if (this.rectTOptionSet) {
                        medit.edit(6, o, this.rectTOptionCombo.getSelectedIndex());
                    }
                    if (this.rectTCenterSet) {
                        medit.edit(7, o, this.rectTCenterCombo.getSelectedIndex());
                    }
                }
                if (o instanceof MTextBox) {
                    if (o instanceof MNameTextBox) {
                        ((MNameTextBox)o).setAutoHeight(true);
                    }
                    if (this.textFontPanel.isFontFamilyChanged()) {
                        medit.edit(0, o, this.textFontPanel.getSelectedFontFamily());
                    }
                    if (this.textFontPanel.isFontStyleChanged()) {
                        medit.edit(5, o, this.textFontPanel.getSelectedStyle());
                    }
                    if (this.textFontPanel.isFontSizeChanged()) {
                        medit.edit(8, o, this.textFontPanel.getSelectedSize());
                    }
                    if (this.textFontPanel.isHalignChanged()) {
                        medit.edit(8, o, this.textFontPanel.getSelectedHalign());
                    }
                    if (this.textFontPanel.isValignChanged()) {
                        medit.edit(9, o, this.textFontPanel.getSelectedValign());
                    }
                }
                if (this.textFontPanel == null || !this.textFontPanel.isColorChanged() || !o.hasColor()) continue;
                medit.edit(0, o, this.textFontPanel.getSelectedColor());
            }
        }
        finally {
            medit.setHistorizeEnabled(true);
        }
    }

    @Override
    public void focusGained(FocusEvent ev) {
    }

    @Override
    public void focusLost(FocusEvent ev) {
        int i;
        Object src = ev.getSource();
        this.badvalue = false;
        for (i = 0; i < this.lineDoublePropTFs.length; ++i) {
            if (this.lineDoublePropTFs[i] != src) continue;
            this.setDoubleProp(i);
        }
        if (src instanceof JTextField) {
            for (i = 0; i < 2; ++i) {
                if (src == this.arrowLengthTF[i]) {
                    this.setArrow(i, this.arrowSet, this.arrowLabels, this.arrowLengthVals, this.arrowLengthTF);
                }
                if (src != this.arrowWidthTF[i]) continue;
                this.setArrow(i, this.arrowSet, this.arrowLabels, this.arrowWidthVals, this.arrowWidthTF);
            }
        }
    }

    private void setBgColorProp(Color c) {
        if (this.bgColorButton != null) {
            this.bgColorVal = c;
            this.bgColorButton.setBackground(c);
            if (!this.bgColorSet) {
                this.bgColorSet = true;
                this.setProp(this.bgColorLabel);
            }
        }
    }

    private void setLineColorProp(Color c) {
        if (this.lineColorButton != null) {
            this.lineColorVal = c;
            this.lineColorButton.setBackground(c);
            if (!this.lineColorSet) {
                this.lineColorSet = true;
                this.setProp(this.lineColorLabel);
            }
        }
    }

    private void setArrowProp(int i, boolean[] set, JLabel[] labels) {
        if (!set[i]) {
            set[i] = true;
            this.setProp(labels[i]);
        }
    }

    private void setProp(JLabel l) {
        if (l != null) {
            String s = l.getText();
            l.setText("<html><small>*</small>" + s + "</html>");
            this.parentDialog.pack();
        }
    }

    private static boolean hasText(MObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MTextBox)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLine(MObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MPolyline)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLineEnds(MObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            MObject o = objs[i];
            if (!(o instanceof MPolyline) || o instanceof MBracket) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRectangle(MObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MRectangle)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasArc(MObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MPolyline) || ((MPolyline)objs[i]).getPointCount() != 2) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBackground(MObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (!objs[i].hasBackground()) continue;
            return true;
        }
        return false;
    }

    private static Color getBackground(MObject[] objs) {
        Color c = null;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!objs[i].hasBackground()) continue;
            Color c1 = objs[i].getBackground();
            if (found) {
                if (!MObjectPropertiesPanel.areEqualObjects(c1, c)) {
                    return null;
                }
            } else {
                found = true;
            }
            c = c1;
        }
        return c;
    }

    private static String getBaseFontFamily(MObject[] objs) {
        String s = null;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MTextBox)) continue;
            String s1 = ((MTextBox)objs[i]).getBaseFontFamily();
            if (found) {
                if (!MObjectPropertiesPanel.areEqualObjects(s1, s)) {
                    return null;
                }
            } else {
                found = true;
            }
            s = s1;
        }
        return s;
    }

    private static int getBaseFontStyle(MObject[] objs) {
        int s = -1;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MTextBox)) continue;
            int s1 = ((MTextBox)objs[i]).getBaseFontStyle();
            if (found) {
                if (s != -1 && s != s1) {
                    return -1;
                }
            } else {
                found = true;
            }
            s = s1;
        }
        return s;
    }

    private static double getFontScale(MObject[] objs) {
        double s = 0.0;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MTextBox)) continue;
            double s1 = ((MTextBox)objs[i]).getFontScale();
            if (found) {
                if (s != 0.0 && s != s1) {
                    return 0.0;
                }
            } else {
                found = true;
            }
            s = s1;
        }
        return s;
    }

    private static int getVerticalAlignment(MObject[] objs) {
        int a = -1;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MTextBox)) continue;
            int a1 = ((MTextBox)objs[i]).getVerticalAlignment();
            if (found) {
                if (a != a1) {
                    return -1;
                }
            } else {
                found = true;
            }
            a = a1;
        }
        return a;
    }

    private static int getHorizontalAlignment(MObject[] objs) {
        int a = -1;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MTextBox)) continue;
            int a1 = ((MTextBox)objs[i]).getHorizontalAlignment();
            if (found) {
                if (a != a1) {
                    return -1;
                }
            } else {
                found = true;
            }
            a = a1;
        }
        return a;
    }

    private static int countRichTextBoxes(MObject[] objs) {
        int n = 0;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MTextBox) || !((MTextBox)objs[i]).hasRichText()) continue;
            ++n;
        }
        return n;
    }

    private static Color getColor(MObject[] objs) {
        Color c = null;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!objs[i].hasColor()) continue;
            Color c1 = objs[i].getColor();
            if (found) {
                if (!MObjectPropertiesPanel.areEqualObjects(c1, c)) {
                    return null;
                }
            } else {
                found = true;
            }
            c = c1;
        }
        return c;
    }

    private static Color getLineColor(MObject[] objs) {
        Color c = null;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!objs[i].hasLineColor()) continue;
            Color c1 = objs[i].getLineColor();
            if (found) {
                if (!MObjectPropertiesPanel.areEqualObjects(c1, c)) {
                    return null;
                }
            } else {
                found = true;
            }
            c = c1;
        }
        return c;
    }

    private static Double getLineDoubleProp(MObject[] objs, String s) {
        Double d = null;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            Double d1;
            if (!(objs[i] instanceof MPolyline)) continue;
            String v = objs[i].getAttribute(s);
            Double d2 = d1 = v != null ? Double.valueOf(v) : null;
            if (found) {
                if (!MObjectPropertiesPanel.areEqualObjects(d1, d)) {
                    return null;
                }
            } else {
                found = true;
            }
            d = d1;
        }
        return d;
    }

    private static int getTOption(MObject[] objs) {
        int k = -1;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MRectangle)) continue;
            int k1 = ((MRectangle)objs[i]).getTOption();
            if (found) {
                if (k != k1) {
                    return -1;
                }
            } else {
                found = true;
            }
            k = k1;
        }
        return k;
    }

    private static int getRectangleTCenter(MObject[] objs) {
        int k = -1;
        boolean found = false;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MRectangle)) continue;
            int k1 = ((MRectangle)objs[i]).getTCenter();
            if (found) {
                if (k != k1) {
                    return -1;
                }
            } else {
                found = true;
            }
            k = k1;
        }
        return k;
    }

    private static Double getArrowProp(MObject[] objs, int i, int what) {
        Double d = null;
        boolean found = false;
        for (int j = 0; j < objs.length; ++j) {
            MPolyline pl;
            double w;
            if (!(objs[j] instanceof MPolyline) || (w = (pl = (MPolyline)objs[j]).getArrowWidth(i)) == 0.0) continue;
            double l = pl.getArrowLength(i);
            Double d1 = null;
            if (what == 0) {
                d1 = new Double(l);
            } else if (what == 1) {
                d1 = new Double(w);
            }
            if (found) {
                if (MObjectPropertiesPanel.areEqualObjects(d1, d)) continue;
                return null;
            }
            found = true;
            d = d1;
        }
        return d;
    }

    private static int getArrowFlags(MObject[] objs, int i) {
        int flags = 0;
        boolean found = false;
        for (int j = 0; j < objs.length; ++j) {
            MPolyline pl;
            double w;
            if (!(objs[j] instanceof MPolyline) || (w = (pl = (MPolyline)objs[j]).getArrowWidth(i)) == 0.0) continue;
            int f = pl.getArrowFlags(i);
            if (found) {
                if (flags == f) continue;
                return 0;
            }
            found = true;
            flags = f;
        }
        return flags;
    }

    private static boolean areEqualObjects(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
    }

    private void setArrow(int i, boolean[] set, JLabel[] labels, Double[] vals, JTextField[] tf) {
        double x = -1.0;
        try {
            x = Double.valueOf(tf[i].getText());
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (x > 0.0) {
            if (vals[i] == null && x != 0.0 || vals[i] != null && vals[i] != x) {
                this.setArrowProp(i, set, labels);
                vals[i] = new Double(x);
            }
            tf[i].setText(String.valueOf(x));
        } else {
            x = vals[i] != null ? vals[i] : 0.0;
            tf[i].setText(String.valueOf(x));
            this.badvalue = true;
            JOptionPane.showMessageDialog(this.parentDialog, "Positive number expected.", "Invalid value", 0);
        }
    }

    private void addLineDoubleProp(GridBagLayout gbl, GridBagConstraints gbc, Container container, int labelAlign, String cmd, String lkey, int medcmd, String propname, MObject[] objs, double defv, double defv2set, int allowed) {
        Double v = MObjectPropertiesPanel.getLineDoubleProp(objs, propname);
        ResourceBundle rc = RESOURCES;
        MObjectDoubleProp p = new MObjectDoubleProp(cmd, medcmd, v, defv, defv2set, allowed);
        int n = this.lineDoubleProps.length;
        MObjectDoubleProp[] newprops = new MObjectDoubleProp[n + 1];
        System.arraycopy(this.lineDoubleProps, 0, newprops, 0, n);
        newprops[n] = p;
        this.lineDoubleProps = newprops;
        JLabel label = new JLabel(rc.getString(lkey), labelAlign);
        JLabel[] newlabels = new JLabel[n + 1];
        System.arraycopy(this.lineDoublePropLabels, 0, newlabels, 0, n);
        newlabels[n] = label;
        this.lineDoublePropLabels = newlabels;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbl.setConstraints(container.add(label), gbc);
        ++gbc.gridx;
        JTextField tf = new JTextField(5);
        tf.setActionCommand(cmd);
        tf.setText(v != null ? v.toString() : String.valueOf(p.getDefaultValue()));
        tf.addFocusListener(this);
        tf.addActionListener(this);
        JTextField[] newtf = new JTextField[n + 1];
        System.arraycopy(this.lineDoublePropTFs, 0, newtf, 0, n);
        newtf[n] = tf;
        this.lineDoublePropTFs = newtf;
        gbl.setConstraints(container.add(tf), gbc);
        ++gbc.gridx;
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(MObjectPropertiesPanel.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("MObjectPropertiesPanel.properties not found");
        }
        RESOURCES = rc;
        TITLE = rc.getString("title");
        int[] arrowFlags = new int[]{0, 0, MPolyline.ARROW_HALF_LEFT, MPolyline.ARROW_HALF_RIGHT};
        ARROW_FLAGS = arrowFlags;
    }
}

