/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.modules.FontFamilySizeComponents;
import chemaxon.marvin.sketch.swing.MObjectEditor;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.TextEditor;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.Editable;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.Symbol;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.SymbolsDialogProvider;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MObject;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.graphics.MTextDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class MTextBoxEditor
extends MObjectEditor
implements ActionListener,
TextEditor {
    private static final int LRU_MAX_LENGTH = 24;
    private static final long serialVersionUID = 6171276549093071089L;
    private static final String ICON_BASE = "/chemaxon/icons/marvin/";
    private static final ResourceBundle RESOURCES;
    private SketchPanel sketchPanel;
    private MTextBox textBox;
    private FontFamilySizeComponents fontFamilySizeComps;
    private ButtonModel italicFontModel;
    private ButtonModel boldFontModel;
    private ButtonModel subscriptModel;
    private ButtonModel superscriptModel;
    private JToolBar toolBar;
    private Object toolBarPosition = "South";
    private List<Symbol> userSymbols;

    @Override
    public void init(SketchPanel skpan) {
        this.sketchPanel = skpan;
        GridBagLayout gbl = new GridBagLayout();
        this.toolBar = new JToolBar();
        this.toolBar.setOrientation(0);
        this.toolBar.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.insets.right = 5;
        this.fontFamilySizeComps = new FontFamilySizeComponents(null, null, null, 0.0);
        this.fontFamilySizeComps.addActionListener(this);
        JComponent[] comps = this.fontFamilySizeComps.getJComponents();
        for (int i = 0; i < comps.length; ++i) {
            gbl.setConstraints(this.toolBar.add(comps[i]), gbc);
            ++gbc.gridx;
        }
        AbstractButton b = this.createToggleButton("boldFont", "fontBoldMenuLabel", "font/bold16.png");
        this.toolBar.add(b);
        this.boldFontModel = b.getModel();
        gbl.setConstraints(b, gbc);
        ++gbc.gridx;
        b = this.createToggleButton("italicFont", "fontItalicMenuLabel", "font/italic16.png");
        this.toolBar.add(b);
        this.italicFontModel = b.getModel();
        gbl.setConstraints(b, gbc);
        ++gbc.gridx;
        b = this.createButton("chooseColor", "colorChooseMenuLabel", "color16.png");
        this.toolBar.add(b);
        gbl.setConstraints(b, gbc);
        ++gbc.gridx;
        b = this.createToggleButton("subscript", "subscriptMenuLabel", "font/subscript16.png");
        this.toolBar.add(b);
        this.subscriptModel = b.getModel();
        gbl.setConstraints(b, gbc);
        ++gbc.gridx;
        b = this.createToggleButton("superscript", "superscriptMenuLabel", "font/superscript16.png");
        this.toolBar.add(b);
        this.superscriptModel = b.getModel();
        gbl.setConstraints(b, gbc);
        ++gbc.gridx;
        b = this.createButton("symbol", "symbolMenuLabel", "font/symbol16.png");
        this.toolBar.add(b);
        this.toolBar.add(Box.createHorizontalGlue());
        gbc.weightx = 1.0;
        gbl.setConstraints(b, gbc);
        ++gbc.gridx;
    }

    private AbstractButton createButton(String command, String label, String icon) {
        JButton result = new JButton();
        this.configure(result, command, RESOURCES.getString(label), icon);
        return result;
    }

    private AbstractButton createToggleButton(String command, String label, String icon) {
        JToggleButton result = new JToggleButton();
        this.configure(result, command, RESOURCES.getString(label), icon);
        return result;
    }

    private void configure(AbstractButton button, String command, String label, String icon) {
        button.setActionCommand(command);
        button.addActionListener(this);
        button.setText("");
        button.setToolTipText(this.getText(label));
        button.setIcon(this.createImageIcon(icon));
        button.setFocusable(false);
    }

    private String getText(String label) {
        if (label.length() > 3 && label.charAt(2) == '\'' && label.charAt(0) == '\'') {
            return label.substring(3);
        }
        return label;
    }

    public void addString(String str) {
        this.textBox.addString(str);
        this.sketchPanel.getCanvas().repaint();
    }

    @Override
    public void beginEditing() {
        this.sketchPanel.mainPanel.add((Component)this.toolBar, this.toolBarPosition);
        this.restoreKeyboardFocus();
    }

    @Override
    public void endEditing() {
        Object o = this.getToolBarPosition();
        if (o != null) {
            this.toolBarPosition = o;
        }
        this.sketchPanel.mainPanel.remove(this.toolBar);
        Container p = this.toolBar.getParent();
        if (p != null && p instanceof JPanel && (p = p.getParent()) != null && p instanceof JLayeredPane && (p = p.getParent()) != null && (p = p.getParent()) != null && p instanceof JDialog) {
            p.setVisible(false);
        }
        if (this.userSymbols != null && this.userSymbols.size() > 0) {
            Symbol[] symbols = this.userSymbols.toArray(new Symbol[this.userSymbols.size()]);
            if (symbols.length > 24) {
                symbols = Arrays.copyOf(symbols, 24);
            }
            if (symbols.length > 0) {
                this.sketchPanel.getUserSettings().setProperty("recentSymbols", Symbol.formatSymbols(symbols));
            }
        }
    }

    private Object getToolBarPosition() {
        BorderLayout bl = (BorderLayout)this.sketchPanel.mainPanel.getLayout();
        Object o = bl.getConstraints(this.toolBar);
        return o;
    }

    @Override
    public JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    @Override
    public void setMObject(MObject t) {
        this.textBox = (MTextBox)t;
        this.update();
    }

    @Override
    public void update() {
        MTextBox t = this.textBox;
        if (t != null) {
            int set0 = 24;
            MTextAttributes attr = t.getCurrentTextAttributes(set0);
            int flags = attr != null ? attr.getSet() : 0;
            MTextDocument tdoc = t.getTextDocument();
            MFont mft = tdoc.getAttrFont(attr);
            this.boldFontModel.setSelected(mft.isBold());
            this.italicFontModel.setSelected(mft.isItalic());
            boolean fntfam = attr == null || (flags & 8) != 0;
            boolean fntsiz = attr == null || (flags & 0x10) != 0;
            this.fontFamilySizeComps.setSelectedFontFamily(fntfam ? mft.getFamily() : null);
            this.fontFamilySizeComps.setSelectedSize(fntsiz ? mft.getSizeDouble() : 0.0);
            this.updateSubScript();
        }
    }

    private void updateSubScript() {
        this.superscriptModel.setSelected(this.isSuperscript());
        this.subscriptModel.setSelected(this.isSubscript());
        int subl = this.textBox.getCurrentSubLevel();
        if (subl == 0) {
            this.superscriptModel.setEnabled(true);
            this.subscriptModel.setEnabled(true);
        } else if (subl > 0) {
            this.superscriptModel.setEnabled(true);
            this.subscriptModel.setEnabled(this.textBox.getCurrentScriptCount(-subl) == 0);
        } else if (subl < 0) {
            this.subscriptModel.setEnabled(true);
            this.superscriptModel.setEnabled(this.textBox.getCurrentScriptCount(-subl) == 0);
        }
    }

    @Override
    public boolean isBoldFont() {
        if (this.textBox == null) {
            return false;
        }
        int set0 = 24;
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(set0);
        MFont mft = this.textBox.getTextDocument().getAttrFont(attr);
        return mft.isBold();
    }

    @Override
    public boolean isItalicFont() {
        if (this.textBox == null) {
            return false;
        }
        int set0 = 24;
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(set0);
        MFont mft = this.textBox.getTextDocument().getAttrFont(attr);
        return mft.isItalic();
    }

    @Override
    public void setBoldFont(boolean b) {
        int oldFont = b ? 1 : 0;
        int newFont = b ? 0 : 1;
        this.setFontStyle(oldFont, newFont, 32);
    }

    @Override
    public void setItalicFont(boolean b) {
        int oldFont = b ? 2 : 0;
        int newFont = b ? 0 : 2;
        this.setFontStyle(oldFont, newFont, 64);
    }

    @Override
    public boolean isSubscript() {
        return this.textBox.getCurrentSubLevel() < 0;
    }

    @Override
    public void setSubscript(boolean b) {
        if (b) {
            this.beginSubscript(true);
        } else {
            this.endSubscript();
        }
        this.restoreKeyboardFocus();
    }

    @Override
    public boolean isSuperscript() {
        return this.textBox.getCurrentSubLevel() > 0;
    }

    @Override
    public void setSuperscript(boolean b) {
        if (b) {
            this.beginSubscript(false);
        } else {
            this.endSubscript();
        }
        this.restoreKeyboardFocus();
    }

    @Override
    public String getFontFamily() {
        MFont mft;
        MTextDocument text = this.textBox.getTextDocument();
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        MFont mFont = mft = attr != null ? attr.getBaseFont() : null;
        if (mft == null) {
            mft = text.getDefaultFont();
        }
        return mft.getFamily();
    }

    @Override
    public void setFontFamily(String family) {
        MFont mft;
        MTextDocument text = this.textBox.getTextDocument();
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        MFont mFont = mft = attr != null ? attr.getBaseFont() : null;
        if (mft == null) {
            mft = text.getDefaultFont();
        }
        mft = text.reuseFont(family, mft.getStyle(), mft.getSizeDouble());
        this.textBox.setCurrentFont(mft, 8);
    }

    @Override
    public double getFontSize() {
        MFont mft;
        MTextDocument text = this.textBox.getTextDocument();
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        MFont mFont = mft = attr != null ? attr.getBaseFont() : null;
        if (mft == null) {
            mft = text.getDefaultFont();
        }
        return mft.getSizeDouble();
    }

    @Override
    public void setFontSize(double v) {
        MFont mft;
        MTextDocument text = this.textBox.getTextDocument();
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        MFont mFont = mft = attr != null ? attr.getBaseFont() : null;
        if (mft == null) {
            mft = text.getDefaultFont();
        }
        mft = text.reuseFont(mft.getFamily(), mft.getStyle(), v);
        this.textBox.setCurrentFont(mft, 16);
    }

    @Override
    public Color getForegroundColor() {
        return this.textBox != null ? this.textBox.getCurrentForeground() : this.sketchPanel.getCanvas().getPainter().getColors().getForeground();
    }

    @Override
    public void setForegroundColor(Color c) {
        if (this.textBox != null && c != null) {
            this.textBox.setCurrentForeground(c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        String cmd = ev.getActionCommand();
        if (cmd.equals("subscript")) {
            this.setSubscript(this.subscriptModel.isSelected());
        } else if ("symbol".equals(cmd)) {
            Component source = (Component)ev.getSource();
            Object position = this.getToolBarPosition();
            int location = position == "South" ? 1 : (position == "West" ? 3 : (position == "East" ? 7 : 5));
            SymbolsDialogProvider provider = (SymbolsDialogProvider)MarvinModule.load("chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.LRUDialog", this.sketchPanel);
            if (provider != null) {
                provider.open(source, location, Collections.unmodifiableCollection(this.getLRUSymbols()), new EditableAdapter(this));
            }
        } else if (cmd.equals("superscript")) {
            this.setSuperscript(this.superscriptModel.isSelected());
        } else if (cmd.equals("endsubscript")) {
            this.subscriptModel.setSelected(false);
            this.superscriptModel.setSelected(false);
            this.endSubscript();
        } else if (cmd.equals("subsubscript") || cmd.equals("subsuperscript")) {
            double dy;
            int subl = Math.abs(attr.getSubLevel());
            double scale = attr.getScale();
            if (cmd.equals("subsubscript")) {
                subl = -subl - 1;
                dy = -0.5;
            } else {
                ++subl;
                dy = 1.0;
            }
            attr = new MTextAttributes(641, subl, attr.getForeground(), attr.getBaseFont(), 0.7 * scale, attr.getDx(), dy);
            this.textBox.setCurrentTextAttributes(attr);
        } else if (cmd.equals("chooseColor")) {
            Color c = this.sketchPanel.showColorChooserDialog(this.getForegroundColor());
            this.setForegroundColor(c);
        } else if (cmd.equals("defaultFont")) {
            this.fontFamilySizeComps.setSelectedSize(0.0);
            this.textBox.setCurrentFont(null, 4);
        } else if (cmd.equals("regularFont")) {
            this.boldFontModel.setSelected(false);
            this.italicFontModel.setSelected(false);
            this.setFontStyle(0, 3, 96);
        } else if (cmd.equals("boldFont")) {
            this.setBoldFont(this.boldFontModel.isSelected());
        } else if (cmd.equals("italicFont")) {
            this.setItalicFont(this.italicFontModel.isSelected());
        } else if (cmd.equals("fontFamily")) {
            if (ev.getSource() == this.fontFamilySizeComps) {
                this.setFontFamily(this.fontFamilySizeComps.getSelectedFontFamily());
            }
        } else if (cmd.equals("fontSize")) {
            if (ev.getSource() == this.fontFamilySizeComps) {
                this.setFontSize(this.fontFamilySizeComps.getSelectedSize());
            }
        } else if (cmd.equals("fontFamilySizePopupClosed")) {
            this.restoreKeyboardFocus();
        }
        this.sketchPanel.getCanvas().repaint();
        this.update();
    }

    private void beginSubscript(boolean subscript) {
        double dy;
        int subl;
        int k0;
        MTextDocument text = this.textBox.getTextDocument();
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        MFont defaultFont = text.getDefaultFont();
        MTextAttributes attr0 = null;
        if ((attr == null || attr.getSubLevel() != 0) && (k0 = this.textBox.getPreviousNormalTextSectionIndex()) >= 0) {
            attr0 = text.getSection(k0).getAttributes();
        }
        MFont mft = null;
        byte subl0 = 0;
        double scale = 0.7;
        if (attr0 != null) {
            mft = attr0.getBaseFont();
            subl0 = attr0.getSubLevel();
            scale = 0.7 * attr0.getScale();
        } else if (attr != null) {
            mft = attr.getBaseFont();
            scale = attr.getScale();
            if (attr.getSubLevel() == 0) {
                scale *= 0.7;
            }
        }
        if (mft == null) {
            mft = defaultFont;
        }
        if (subscript) {
            subl = -Math.abs(subl0) - 1;
            dy = -0.4;
        } else {
            subl = Math.abs(subl0) + 1;
            dy = 0.6;
        }
        attr = attr != null ? new MTextAttributes(641, subl, attr.getForeground(), mft, scale, attr.getDx(), dy) : new MTextAttributes(641, subl, null, mft, scale, 0.0, dy);
        this.textBox.setCurrentTextAttributes(attr);
    }

    private void endSubscript() {
        MTextDocument text = this.textBox.getTextDocument();
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        int k0 = this.textBox.getPreviousNormalTextSectionIndex();
        MTextAttributes attr0 = k0 >= 0 ? text.getSection(k0).getAttributes() : null;
        MFont mft = null;
        Color fg = null;
        int subl = 0;
        double scale = 1.0;
        if (attr0 != null) {
            mft = attr0.getBaseFont();
            fg = attr0.getForeground();
            subl = attr0.getSubLevel();
            scale = attr0.getScale();
        } else if (attr != null) {
            mft = attr.getBaseFont();
            byte asubl = attr.getSubLevel();
            subl = asubl > 0 ? asubl - 1 : (asubl < 0 ? asubl + 1 : 0);
            scale = 1.0;
            fg = attr.getForeground();
        }
        attr = attr != null ? new MTextAttributes(641, subl, fg, mft, scale, attr.getDx(), 0.0) : new MTextAttributes(641, subl, null, mft, scale, 0.0, 0.0);
        this.textBox.setCurrentTextAttributes(attr);
    }

    private void setFontStyle(int set, int unset, int setflags) {
        MFont mft;
        MTextDocument text = this.textBox.getTextDocument();
        MTextAttributes attr = this.textBox.getCurrentTextAttributes(0);
        MFont defaultFont = text.getDefaultFont();
        MFont mFont = mft = attr != null ? attr.getBaseFont() : null;
        if (mft == null) {
            mft = defaultFont;
        }
        int style = mft.getStyle() & ~unset | set;
        if ((mft = text.reuseFont(mft.getFamily(), style, mft.getSizeDouble())).equals(defaultFont)) {
            mft = null;
        }
        this.textBox.setCurrentFont(mft, setflags);
    }

    private Icon createImageIcon(String path) {
        return new ImageIcon(this.getClass().getResource(ICON_BASE + path));
    }

    private void restoreKeyboardFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MTextBoxEditor.this.sketchPanel.requestFocus();
            }
        });
    }

    private Collection<Symbol> getLRUSymbols() {
        return this.createLRUSymbols();
    }

    private void addLRUSymbol(Symbol symbol) {
        this.userSymbols.remove(symbol);
        this.userSymbols.add(0, symbol);
    }

    private Collection<Symbol> getUserSymbols() {
        if (this.userSymbols == null) {
            this.userSymbols = new ArrayList<Symbol>(this.getSymbols("recentSymbols", Symbol.Source.USER));
        }
        return this.userSymbols;
    }

    private Collection<Symbol> getParameterSymbols() {
        return this.getSymbols("symbols", Symbol.Source.PARAMETER);
    }

    private Collection<Symbol> getSymbols(String key, Symbol.Source source) {
        String str = this.sketchPanel.getParameter(key);
        if (str == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(Symbol.parseSymbols(str, source));
    }

    private List<Symbol> createLRUSymbols() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        result.addAll(this.getUserSymbols());
        Collection<Symbol> parameters = MTextBoxEditor.remainder(this.getParameterSymbols(), result);
        result.addAll(Math.min(result.size(), Math.max(0, 24 - parameters.size())), parameters);
        if (result.size() < 24) {
            result.addAll(MTextBoxEditor.remainder(Symbol.getDefaults(), result));
        }
        return result;
    }

    private static <E> Collection<E> remainder(Collection<E> c1, Collection<E> c2) {
        LinkedHashSet<E> result = new LinkedHashSet<E>(c1);
        result.removeAll(c2);
        return result;
    }

    static {
        ResourceBundle rc = null;
        try {
            rc = MolPanel.getResourceBundle(MTextBoxEditor.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("MTextBoxEditor.properties not found");
        }
        RESOURCES = rc;
    }

    private static class EditableAdapter
    implements Editable {
        private final MTextBoxEditor editor;

        public EditableAdapter(MTextBoxEditor editor) {
            this.editor = editor;
        }

        @Override
        public String getDefaultFontFamily() {
            return this.editor.getFontFamily();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(Symbol symbol) {
            String font = this.editor.getFontFamily();
            try {
                this.editor.setFontFamily(symbol.getFontFamily());
                this.editor.addString(Symbol.newString(symbol.getCharacter()));
            }
            finally {
                this.editor.setFontFamily(font);
            }
            this.editor.addLRUSymbol(symbol);
        }
    }
}

