/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.swing.PeriodicSystemDialog;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.periodic.AdvancedPanel;
import chemaxon.marvin.sketch.swing.modules.periodic.PeriodicSystemPanel;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PeriodicSystemDialogImpl
extends AbstractDialog
implements PeriodicSystemDialog {
    private static final long serialVersionUID = -4816630285156046350L;
    private static final String TITLE_KEY = "Title";
    private static final String PERIODIC_TAB_KEY = "PeriodicTabTitle";
    private static final String ADVANCED_TAB_KEY = "AdvancedTabTitle";
    private SketchPanel sketchPanel;
    private PeriodicSystemPanel periodicPanel;
    private AdvancedPanel advancedPanel;

    public PeriodicSystemDialogImpl(Dialog dialog, SketchPanel sketchPanel) {
        super((Window)dialog, "", false);
        this.sketchPanel = sketchPanel;
    }

    public PeriodicSystemDialogImpl(Frame frame, SketchPanel sketchPanel) {
        super((Window)frame, "", false);
        this.sketchPanel = sketchPanel;
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildCloseButtonBar();
    }

    @Override
    protected JComponent buildContentPanel() {
        ResourceBundle resources = MolPanel.getResourceBundle(this.getClass().getName());
        this.setTitle(resources.getString(TITLE_KEY));
        this.periodicPanel = new PeriodicSystemPanel(this.sketchPanel);
        this.advancedPanel = new AdvancedPanel(this.sketchPanel);
        this.periodicPanel.setToggleListener(this.advancedPanel);
        this.advancedPanel.setToggleListener(this.periodicPanel);
        JTabbedPane tab = new JTabbedPane();
        tab.addTab(resources.getString(PERIODIC_TAB_KEY), this.periodicPanel);
        tab.addTab(resources.getString(ADVANCED_TAB_KEY), this.advancedPanel);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)tab, "Center");
        return contentPanel;
    }

    @Override
    public void releaseAll() {
        this.periodicPanel.toggleActionPerformed();
        this.advancedPanel.toggleActionPerformed();
    }

    @Override
    public void setMolecule(Molecule mol) {
        this.periodicPanel.setMolecule(mol);
    }

    public static interface ToggleListener {
        public void toggleActionPerformed();
    }
}

