/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.uif.util.swing.AbstractDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioChooserDialog
extends AbstractDialog {
    private static final long serialVersionUID = 3593897063185791649L;
    private final String message;
    private final List<String> options;
    private volatile int defaultIdx = 0;
    private ButtonGroup group = null;

    public RadioChooserDialog(String msg, List<String> opts, Dialog dialog) {
        this(msg, opts, dialog, "");
    }

    public RadioChooserDialog(String msg, List<String> opts, Dialog dialog, String title) {
        this(msg, opts, dialog, title, false);
    }

    public RadioChooserDialog(String msg, List<String> opts, Dialog dialog, String title, boolean modal) {
        super((Window)dialog, title, modal);
        this.message = msg;
        this.options = opts;
        this.init();
    }

    public RadioChooserDialog(String msg, List<String> opts, Frame frame) {
        this(msg, opts, frame, "");
    }

    public RadioChooserDialog(String msg, List<String> opts, Frame frame, String title) {
        this(msg, opts, frame, title, false);
    }

    public RadioChooserDialog(String msg, List<String> opts, Frame frame, String title, boolean modal) {
        super((Window)frame, title, modal);
        this.message = msg;
        this.options = opts;
        this.init();
    }

    public void setDefault(int idx) {
        this.defaultIdx = idx;
    }

    public void setDefault(String str) {
        this.defaultIdx = this.options.indexOf(str);
    }

    public synchronized int getSelectedIndex() {
        if (this.isCanceled()) {
            return Integer.MIN_VALUE;
        }
        return this.options.indexOf(this.group.getSelection().getActionCommand());
    }

    public synchronized String getSelected() {
        if (this.isCanceled()) {
            return null;
        }
        return this.group.getSelection().getActionCommand();
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildOKCancelButtonBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent buildContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (this.message != null) {
            panel.add(new JLabel(this.message));
        }
        RadioChooserDialog radioChooserDialog = this;
        synchronized (radioChooserDialog) {
            this.group = new ButtonGroup();
            for (String text : this.options) {
                JRadioButton button = new JRadioButton(text);
                button.setActionCommand(text);
                this.group.add(button);
                panel.add(button);
                if (this.defaultIdx != this.options.indexOf(text)) continue;
                button.setSelected(true);
            }
        }
        return panel;
    }

    private void init() {
        this.setCloseOnEsc(true);
    }
}

