/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.common.swing.DnD;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.swing.SketchCanvas;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;

public class SketchDnD
implements CallbackIface {
    private DnD theDnD;
    private DnD dragger = null;
    private DnD dropper = null;
    private Molecule dragMol = null;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.theDnD = (DnD)arg;
        } else if (method.equals("dragGestureRecognized")) {
            DragGestureEvent ev = (DragGestureEvent)arg;
            SketchCanvas sketchCanvas = this.getSketchCanvas();
            MolEditor medit = sketchCanvas.getEditor();
            this.dragMol = medit.getMolSelection();
            if (this.getSketchPanel() != null) {
                this.getSketchPanel().beginHourglass();
            }
            Transferable dataTransfer = ClipboardHandler.getTransferableFor(this.dragMol, null, "___dnd");
            if (this.getSketchPanel() != null) {
                this.getSketchPanel().endHourglass();
            }
            int na = this.dragMol.getAtomCount();
            this.dropper = null;
            this.dragger = null;
            if (sketchCanvas.callback("canbeDnDcopy", null) != null) {
                this.dragger = this.theDnD;
                this.theDnD.getDragSource().startDrag(ev, DragSource.DefaultCopyDrop, dataTransfer, this.theDnD);
                Point p = ev.getDragOrigin();
                sketchCanvas.setScreenPointerPos(p.x, p.y);
                medit.command(4, 0);
            } else if (na > 0 && sketchCanvas.callback("canbeDnDdrag", null) != null || na == 1) {
                this.theDnD.log("GESTURE RECOGNIZED, " + na + " atoms selected");
                this.dragger = this.theDnD;
                this.theDnD.getDragSource().startDrag(ev, DragSource.DefaultMoveDrop, dataTransfer, this.theDnD);
                Point p = ev.getDragOrigin();
                sketchCanvas.setScreenPointerPos(p.x, p.y);
                medit.command(4, 0);
            }
        } else if (method.equals("dragOver")) {
            Point p;
            DropTargetDragEvent ev = (DropTargetDragEvent)arg;
            SketchCanvas sketchCanvas = this.getSketchCanvas();
            if (this.theDnD == this.dragger) {
                p = ev.getLocation();
                sketchCanvas.setScreenPointerPos(p.x, p.y);
                MolEditor medit = sketchCanvas.getEditor();
                medit.command(2, 0);
                sketchCanvas.repaint();
            }
            ev.acceptDrag(3);
            p = ev.getLocation();
            sketchCanvas.doDragging(p.x, p.y);
            this.theDnD.log("[Target] dragOver " + p);
        } else if (method.equals("dragDropEnd")) {
            DragSourceDropEvent ev = (DragSourceDropEvent)arg;
            SketchCanvas sketchCanvas = this.getSketchCanvas();
            SketchPanel sketchPanel = this.getSketchPanel();
            MolEditor medit = sketchCanvas.getEditor();
            if (ev.getDropSuccess()) {
                if (this.dropper == this.theDnD) {
                    this.theDnD.log("SUCCESS (local transfer)");
                    medit.edit(10, true);
                } else if (ev.getDropAction() == 2) {
                    this.theDnD.log("SUCCESS (deleting original selection)");
                    medit.edit(20);
                } else {
                    this.theDnD.log("SUCCESS (copy)");
                    medit.edit(10, false);
                }
                medit.edit(11);
            } else {
                this.theDnD.log("REJECTED");
                medit.edit(10, false);
            }
            sketchPanel.updateControls();
            sketchPanel.setScrollbars();
            sketchCanvas.repaint();
            this.dropper = null;
            this.dragger = null;
        } else if (method.equals("drop")) {
            Molecule dropMol;
            DropTargetDropEvent ev = (DropTargetDropEvent)arg;
            SketchCanvas sketchCanvas = this.getSketchCanvas();
            SketchPanel sketchPanel = this.getSketchPanel();
            this.dropper = this.theDnD;
            DropTargetContext targetContext = ev.getDropTargetContext();
            ev.acceptDrop(ev.getSourceActions());
            Transferable t = ev.getTransferable();
            Molecule molecule = dropMol = this.theDnD == this.dragger ? this.dragMol : (Molecule)ClipboardHandler.getObjectFromTransferable(t);
            if (dropMol != null) {
                Object m;
                MolEditor medit = sketchCanvas.getEditor();
                Point p = ev.getLocation();
                if (this.theDnD == this.dragger) {
                    sketchCanvas.setScreenPointerPos(p.x, p.y);
                } else {
                    dropMol.valenceCheck();
                    sketchCanvas.setScreenPointerPos(p.x, p.y);
                    m = new Molecule[]{dropMol};
                    int id = sketchPanel.getMol().isEmpty() ? 0 : 131073;
                    sketchPanel.molLoaded((Molecule[])m, id);
                }
                if (sketchCanvas.callback("canbeDnDcopy", null) != null) {
                    m = medit.getPiece();
                    medit.command(5, 0);
                    if (m != null && ((MoleculeGraph)m).isAtom()) {
                        medit.command(7, 0);
                    }
                }
                medit.command(4, 0);
                medit.command(3, 0);
                sketchPanel.updateControls();
                sketchPanel.repaint();
                Object data = null;
                try {
                    data = t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (IOException ex) {
                }
                catch (UnsupportedFlavorException ex) {
                    // empty catch block
                }
                if (data != null) {
                    for (File f : (List)data) {
                        sketchPanel.addRecentFileToUserSettings(f);
                        sketchPanel.setLoadCwdToUserSettings(f);
                    }
                }
                targetContext.dropComplete(true);
            } else {
                Component c = (Component)((Object)this.theDnD.getHourglass());
                JOptionPane.showMessageDialog(c, "Cannot import molecule from this object.", "Cannot drop", 0);
                targetContext.dropComplete(false);
                ev.rejectDrop();
            }
        }
        return null;
    }

    private SketchCanvas getSketchCanvas() {
        return (SketchCanvas)this.theDnD.getComponent();
    }

    private SketchPanel getSketchPanel() {
        return (SketchPanel)this.theDnD.getMolPanel();
    }
}

