/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class TemplateOptionsDialogImpl
extends AbstractDialog {
    private static final String TITLE = "Template Options";
    private SketchPanel sketchPanel;
    private JSpinner maxTemplateCountSpinner;
    private JSpinner maxToolbarTemplateCountSpinner;
    private JComboBox behaviorComboBox;
    private JSpinner templateSizeSpinner;

    public TemplateOptionsDialogImpl(Frame frame, SketchPanel sketchPanel) {
        super((Window)frame, TITLE, true);
        this.sketchPanel = sketchPanel;
    }

    public TemplateOptionsDialogImpl(Dialog dialog, SketchPanel sketchPanel) {
        super((Window)dialog, TITLE, true);
        this.sketchPanel = sketchPanel;
    }

    @Override
    protected JComponent buildButtonBar() {
        return this.buildOKCancelButtonBar();
    }

    @Override
    protected JComponent buildContentPanel() {
        JPanel contentPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;30dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel title1 = new JLabel("Maximum number of loaded molecules:");
        contentPanel.add((Component)title1, cc.xy(1, 1));
        this.maxTemplateCountSpinner = new JSpinner();
        this.maxTemplateCountSpinner.setModel(new SpinnerNumberModel((Number)this.sketchPanel.getTemplatePresentationModel().getMaxTemplateCount(), Integer.valueOf(10), null, (Number)10));
        contentPanel.add((Component)this.maxTemplateCountSpinner, cc.xy(3, 1));
        JLabel title2 = new JLabel("Behavior of coordinates:");
        contentPanel.add((Component)title2, cc.xy(1, 3));
        this.behaviorComboBox = new JComboBox();
        this.behaviorComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"As in the original structures", "Always perform Clean2D", "Always perform Clean3D"}));
        this.behaviorComboBox.setSelectedIndex(this.sketchPanel.getTemplateHandler().getTemplateBehavior());
        contentPanel.add((Component)this.behaviorComboBox, cc.xywh(3, 3, 3, 1));
        JLabel title3 = new JLabel("Size of template images (pixels):");
        contentPanel.add((Component)title3, cc.xy(1, 5));
        this.templateSizeSpinner = new JSpinner();
        this.templateSizeSpinner.setModel(new SpinnerNumberModel(this.sketchPanel.getTemplateHandler().getTemplateLabelSize(), 20, 500, 10));
        contentPanel.add((Component)this.templateSizeSpinner, cc.xy(3, 5));
        JLabel title4 = new JLabel("Maximum number of buttons:");
        contentPanel.add((Component)title4, cc.xy(1, 7));
        this.maxToolbarTemplateCountSpinner = new JSpinner();
        this.maxToolbarTemplateCountSpinner.setModel(new SpinnerNumberModel(this.sketchPanel.getTemplatePresentationModel().getMaxToolBarActionCount(), 1, 50, 1));
        contentPanel.add((Component)this.maxToolbarTemplateCountSpinner, cc.xy(3, 7));
        return contentPanel;
    }

    @Override
    protected Action getOKAction() {
        return new OKAction();
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OKAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Integer templateCount = (Integer)TemplateOptionsDialogImpl.this.maxTemplateCountSpinner.getValue();
            TemplateOptionsDialogImpl.this.sketchPanel.getTemplateHandler().setMaxTemplateCount(templateCount);
            Integer toolbarTemplateCount = (Integer)TemplateOptionsDialogImpl.this.maxToolbarTemplateCountSpinner.getValue();
            TemplateOptionsDialogImpl.this.sketchPanel.getTemplateHandler().setMaxToolBarActionCount(toolbarTemplateCount);
            TemplateOptionsDialogImpl.this.sketchPanel.getTemplateHandler().setTemplateBehavior(TemplateOptionsDialogImpl.this.behaviorComboBox.getSelectedIndex());
            Integer templateLabelSize = (Integer)TemplateOptionsDialogImpl.this.templateSizeSpinner.getValue();
            TemplateOptionsDialogImpl.this.sketchPanel.getTemplateHandler().setTemplateLabelSize(templateLabelSize);
            TemplateOptionsDialogImpl.this.doOk();
        }
    }
}

