/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.atompropertyeditor.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractAtomPropertyEditor
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private static final long serialVersionUID = -3865088547502027109L;
    protected static final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
    protected Object value = null;
    protected int row = -1;
    protected int rowHeight = -1;
    protected JTable table = null;
    protected JPanel container = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return renderer.getTableCellRendererComponent(table, this.getUserFriendlyValue(value), isSelected, hasFocus, row, column);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = value;
        this.rowHeight = table.getRowHeight(row);
        this.row = row;
        this.table = table;
        final Component editor = this.getEditorComponent(value);
        editor.setVisible(false);
        this.getContainer().removeAll();
        this.getContainer().add(editor, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                editor.setVisible(true);
            }
        });
        this.table.setRowHeight(this.row, editor.getPreferredSize().height);
        return this.getContainer();
    }

    protected JPanel getContainer() {
        if (this.container == null) {
            this.container = new JPanel(new BorderLayout());
            this.container.setOpaque(false);
        }
        return this.container;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    protected String getUserFriendlyValue(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public void cancelCellEditing() {
        this.table.setRowHeight(this.row, this.rowHeight);
        this.table.setRowHeight(this.row, this.getTableCellRendererComponent((JTable)this.table, (Object)this.value, (boolean)true, (boolean)true, (int)this.row, (int)0).getPreferredSize().height);
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.table.setRowHeight(this.row, this.rowHeight);
        return super.stopCellEditing();
    }

    protected abstract Component getEditorComponent(Object var1);

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 1;
        }
        return true;
    }
}

