/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.attachdatadialog.config;

import chemaxon.marvin.sketch.swing.modules.attachdatadialog.config.Context;
import chemaxon.marvin.sketch.swing.modules.attachdatadialog.config.Name;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigProvider {
    private List<Context> contextList;

    public ConfigProvider() {
        this(null);
    }

    public ConfigProvider(String configLocation) {
        this.init();
        if (configLocation != null) {
            this.loadConfig(configLocation);
        } else {
            this.loadDefaultConfig();
        }
    }

    public List<String> getContextNames() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<Context> it = this.contextList.iterator();
        while (it.hasNext()) {
            ret.add(it.next().getDisplayName());
        }
        return ret;
    }

    public Context getContext(String name) {
        for (Context c : this.contextList) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Context getDefaultContext() {
        Context ret = this.getContext("Group");
        if (ret == null && !this.contextList.isEmpty()) {
            ret = this.contextList.get(0);
        }
        return ret;
    }

    public Context getContextByDisplayName(String name) {
        for (Context c : this.contextList) {
            if (!c.getDisplayName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Context getContextByFieldName(String name) {
        for (Context c : this.contextList) {
            if (!c.getDataNames().contains(name)) continue;
            return c;
        }
        return null;
    }

    private void loadConfig(String configLocation) {
        File config = DotfileUtil.getDotFile(configLocation);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(config);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (stream == null) {
            this.loadDefaultConfig();
            return;
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)stream, (DefaultHandler)new ConfigXMLHandler());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            this.loadDefaultConfig();
        }
        catch (SAXException e) {
            e.printStackTrace();
            this.loadDefaultConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.loadDefaultConfig();
        }
        if (this.contextList.isEmpty()) {
            this.loadDefaultConfig();
        }
    }

    private void loadDefaultConfig() {
        Context group = new Context("Group");
        group.setDisplayName("Group (Selection)");
        Context fragment = new Context("Fragment");
        fragment.addDataName(new Name("COEFF"));
        fragment.addDataName(new Name("Stoichiometry"));
        fragment.addDataName(new Name("[DUP]"));
        fragment.addDataName(new Name("REAGENT"));
        this.contextList.add(new Context("Atom"));
        this.contextList.add(new Context("Bond"));
        this.contextList.add(new Context("Single Bond"));
        this.contextList.add(new Context("Double Bond"));
        this.contextList.add(fragment);
        this.contextList.add(group);
        for (Context c : this.contextList) {
            if (c.getName().equals("Fragment")) continue;
            c.addDataName(new Name("[DUP]"));
        }
    }

    private void init() {
        this.contextList = new ArrayList<Context>();
    }

    private class ConfigXMLHandler
    extends DefaultHandler {
        Context actualContext;
        Name actualName;
        boolean readingValue;
        boolean readingUnit;

        private ConfigXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("context")) {
                this.actualContext = new Context(attributes.getValue("name"));
                String displayName = null;
                displayName = attributes.getValue("displayName");
                if (displayName != null) {
                    this.actualContext.setDisplayName(displayName);
                }
                String restrictName = null;
                restrictName = attributes.getValue("nameFieldEditable");
                if (restrictName != null) {
                    this.actualContext.setNameFieldEditable(Boolean.parseBoolean(restrictName));
                }
            } else if (qName.equals("dataname")) {
                this.actualName = new Name(attributes.getValue("textRepresentation"));
                String tag = null;
                tag = attributes.getValue("defaultTag");
                if (tag != null) {
                    this.actualName.setDefaultTag(tag);
                }
                String ismulti = null;
                ismulti = attributes.getValue("multipleValuesEnabled");
                if (ismulti != null) {
                    this.actualName.setMultipleSelect(Boolean.parseBoolean(ismulti));
                }
                String restrictValue = null;
                restrictValue = attributes.getValue("valueFieldEditable");
                if (restrictValue != null) {
                    this.actualName.setValueFieldEditable(Boolean.parseBoolean(restrictValue));
                }
            } else if (qName.equals("value")) {
                this.readingValue = true;
            } else if (qName.equals("unit")) {
                this.readingUnit = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.readingValue) {
                String textContent = this.readContent(ch, start, length);
                this.actualName.addValue(textContent);
            } else if (this.readingUnit) {
                String textContent = this.readContent(ch, start, length);
                this.actualName.addUnit(textContent);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("context")) {
                ConfigProvider.this.contextList.add(this.actualContext);
                this.actualContext = null;
            } else if (qName.equals("dataname")) {
                this.actualContext.addDataName(this.actualName);
                this.actualName = null;
            } else if (qName.equals("value")) {
                this.readingValue = false;
            } else if (qName.equals("unit")) {
                this.readingUnit = false;
            }
        }

        private String readContent(char[] ch, int start, int length) {
            char[] valueChars = new char[length];
            for (int i = 0; i < length; ++i) {
                valueChars[i] = ch[start + i];
            }
            return new String(valueChars);
        }
    }
}

