/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.checkers.runner.SketchCheckerRunner;
import chemaxon.checkers.runner.configuration.reader.ActionStringBasedConfigurationReader;
import chemaxon.checkers.runner.configuration.reader.XMLBasedConfigurationReader;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.checker.DialogFactory;
import chemaxon.util.DotfileUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CheckerRunnerDisplay {
    private static final String IN_PROGRESS_MESSAGE = "Structure checking in progress, please wait...";
    private static final String NO_PROBLEM_FOUND_MESSAGE = "The document appears to be valid.";
    private static final String DIALOG_TITLE = "Structure Checker";
    protected JPanel mainPanel = null;
    protected JProgressBar progressBar = null;
    protected JButton closeButton = null;
    protected JLabel messageLabel = null;
    protected JDialog dialog = null;
    protected HierarchyListener hierarchyListener = null;
    protected final SketchPanel sketch;
    protected List<StructureCheckerResult> resultList = null;
    protected CheckerRunner runner = null;
    protected boolean runMode = true;
    protected boolean canceled = false;
    protected static final int PROGRESS_CHECK_DELAY = 500;
    protected static final int PROGRESS_CHECK_INTERVAL = 200;
    protected Runnable dialogDisplayerRunnable = null;
    protected final Timer progressCheckTimer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckerRunnerDisplay.this.progressCheckPerformed();
        }
    });

    public CheckerRunnerDisplay(SketchPanel sketch) {
        this.sketch = sketch;
    }

    public synchronized void start() {
        this.getRunner().setMolecule(this.sketch.getMol());
        this.canceled = false;
        this.setRunMode(true);
        this.getRunner().check();
        new Thread(this.getDialogDisplayerRunnable()).start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.getRunner().isChecking() || !this.runMode) {
            this.getDialog().setVisible(true);
        }
    }

    public List<StructureCheckerResult> getResult() {
        return this.resultList;
    }

    public CheckerRunner getRunner() {
        if (this.runner == null) {
            XMLBasedConfigurationReader reader = null;
            InputStream inputStream = null;
            File userFile = DotfileUtil.getDotFile("/" + this.sketch.getUserSettings().getCheckerConfigFileName());
            try {
                inputStream = new FileInputStream(userFile);
            }
            catch (FileNotFoundException e) {
                inputStream = CheckerRunnerDisplay.class.getResourceAsStream("/chemaxon/marvin/sketch/swing/modules/checker/resources/default.xml");
            }
            if (inputStream != null) {
                reader = new XMLBasedConfigurationReader(inputStream);
                this.runner = new SketchCheckerRunner(reader);
            } else {
                this.runner = new SketchCheckerRunner(new ActionStringBasedConfigurationReader(""));
            }
        }
        return this.runner;
    }

    public synchronized void resetRunner() {
        if (this.runner != null) {
            this.runner.cancel();
        }
        this.runner = null;
    }

    protected void setRunMode(boolean runMode) {
        this.runMode = runMode;
        this.getCloseButton().setText(runMode ? "Cancel" : "Close");
        this.getProgressBar().setVisible(runMode);
        this.getMessageLabel().setText(runMode ? IN_PROGRESS_MESSAGE : NO_PROBLEM_FOUND_MESSAGE);
    }

    protected synchronized void stop() {
        if (this.getRunner() != null && this.getRunner().isChecking()) {
            this.getRunner().cancel();
        }
        if (this.progressCheckTimer != null) {
            this.progressCheckTimer.stop();
        }
        this.resultList = this.getRunner().getResultList();
        if ((this.resultList == null || this.resultList.isEmpty()) && !this.canceled) {
            this.setRunMode(false);
        } else {
            if (this.canceled) {
                this.resultList = null;
            }
            this.hideDialog();
        }
        this.notify();
    }

    protected Runnable getDialogDisplayerRunnable() {
        if (this.dialogDisplayerRunnable == null) {
            this.dialogDisplayerRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CheckerRunnerDisplay checkerRunnerDisplay = CheckerRunnerDisplay.this;
                    synchronized (checkerRunnerDisplay) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            if (CheckerRunnerDisplay.this.getRunner().isChecking()) {
                                CheckerRunnerDisplay.this.progressCheckTimer.start();
                                CheckerRunnerDisplay.this.notify();
                            } else {
                                CheckerRunnerDisplay.this.stop();
                            }
                        }
                    }
                }
            };
        }
        return this.dialogDisplayerRunnable;
    }

    protected void hideDialog() {
        if (this.dialog != null) {
            this.dialog.removeHierarchyListener(this.getHierarchyListener());
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    protected HierarchyListener getHierarchyListener() {
        if (this.hierarchyListener == null) {
            this.hierarchyListener = new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Window window;
                    if ((e.getChangeFlags() & 4L) != 0L && e.getSource() instanceof Window && !(window = (Window)e.getSource()).isShowing()) {
                        CheckerRunnerDisplay.this.canceled = true;
                        CheckerRunnerDisplay.this.stop();
                        CheckerRunnerDisplay.this.hideDialog();
                    }
                }
            };
        }
        return this.hierarchyListener;
    }

    protected String getDialogTitle() {
        return DIALOG_TITLE;
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            Window ancestor = SwingUtilities.getWindowAncestor(this.sketch);
            this.dialog = DialogFactory.createDialog(ancestor, this.getDialogTitle());
            this.dialog.addHierarchyListener(this.getHierarchyListener());
            this.dialog.setContentPane(this.getMainPanel());
            if (this.dialog instanceof DialogFactory.CustomDialog) {
                ((DialogFactory.CustomDialog)this.dialog).forcePack();
            }
            this.dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this.sketch));
            this.dialog.setModal(true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    CheckerRunnerDisplay.this.canceled = true;
                }
            });
        }
        return this.dialog;
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            this.mainPanel.add(this.getMessageLabel());
            this.mainPanel.add(Box.createVerticalStrut(10));
            this.mainPanel.add(this.getProgressBar());
            this.mainPanel.add(Box.createVerticalStrut(10));
            this.mainPanel.add(this.getCloseButton());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.mainPanel;
    }

    protected JLabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setAlignmentX(0.5f);
        }
        return this.messageLabel;
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setAlignmentX(0.5f);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    protected JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = -7882721598648888573L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CheckerRunnerDisplay.this.runMode) {
                        CheckerRunnerDisplay.this.canceled = true;
                    }
                    CheckerRunnerDisplay.this.stop();
                    CheckerRunnerDisplay.this.hideDialog();
                }
            });
            this.closeButton.setAlignmentX(0.5f);
        }
        return this.closeButton;
    }

    protected void progressCheckPerformed() {
        if (this.getRunner() != null) {
            if (this.getRunner().isChecking()) {
                int percent = (int)((float)this.getRunner().getCurrent() / (float)this.getRunner().getProgessLength() * 100.0f);
                this.getProgressBar().setValue(percent);
                this.getProgressBar().setString("Processing: " + this.getRunner().getCurrentCheckerName());
            } else {
                this.stop();
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

