/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.fixers.StructureFixer;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerResultWrapper;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerRunnerDisplay;
import chemaxon.marvin.sketch.swing.modules.checker.DialogFactory;
import chemaxon.marvin.sketch.swing.modules.checker.FixAllRunnerDisplay;
import chemaxon.marvin.sketch.swing.modules.checker.FixerSelectionPanel;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.StereoConstants;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class CheckerStatusbarComponent
extends JPanel {
    private static final long serialVersionUID = 7124433789220634935L;
    public static final String PROPERTY_KEY_CHECKER_RUNNING = "StructureCheckerRunning";
    private static final String CLIENT_PROPERTY_KEY = "SketchPanel.checkerStatusbarComponent";
    private static final String RESULT_DIALOG_TITLE = "Structure Checker";
    private static final String DISABLED_TOOLTIP_TEXT = "<html>Structure Checking is <b>disabled</b><br>Click to check manually<br>Right-Click to enable automatic checking</html>";
    private static final String ENABLED_TOOLTIP_TEXT = "<html>Structure Checking is <b>enabled</b><br>Click to check manually<br>Right-Click to disable automatic checking</html>";
    private static final String PROBLEM_TOOLTIP_TEXT = "<html>Structure Checker found some problems.<br>Click for problem list<br>Right-Click to disable automatic checking</html>";
    private static final String FIXER_RUNNING_TOOLTIP_TEXT = "<html>Structure Checker is <b>fixing</b></html>";
    private static final String AUTOCHECK_RUNNING_TOOLTIP_TEXT = "<html>Structure Checker is <b>running</b></html>";
    private static final String NO_PROBLEMS_FOUND = "<html><font style='font-weight:normal;'>No Problems</font></html>";
    private static final String PROBLEMS_FOUND = "<html><font style='font-weight:normal;'>Problems: %i</font></html>";
    private static final String FIXER_RUNNING = "<html><font style='font-weight:normal;'>Fixing</font></html>";
    private static final String EMPTY_TEXT = " ";
    private static final Dimension SMALL_LABEL_DIMENSION = new Dimension(16, 16);
    private static final Dimension LARGE_LABEL_DIMENSION = new Dimension(120, 16);
    private static final Color NO_PROBLEMS_COLOR = Color.GREEN.darker();
    private static final Color PROBLEMS_COLOR = Color.RED;
    private static final Color DISABLED_COLOR = Color.DARK_GRAY;
    private static final Color FIXER_RUNNING_COLOR = Color.DARK_GRAY;
    private static final int PROGRESS_CHECK_INTERVAL = 200;
    private static final int PROGRESS_CHECK_INITIAL = 1000;
    private static final int RECHECK_TIMER_INTERVAL = 1000;
    private static final Color LIGHTBG_LIGHTMARK = new Color(255, 220, 220);
    private static final Color LIGHTBG_DARKMARK = new Color(255, 175, 175);
    private static final Color DARKBG_LIGHTMARK = new Color(100, 0, 0);
    private static final Color DARKBG_DARKMARK = new Color(255, 0, 0);
    private static final Color PROGRESS_FGCOLOR = UIManager.getColor("ProgressBar.selectionForeground") != null ? UIManager.getColor("ProgressBar.selectionForeground") : Color.BLACK;
    private static final Color PROGRESS_BGCOLOR = UIManager.getColor("ProgressBar.selectionBackground") != null ? UIManager.getColor("ProgressBar.selectionBackground") : Color.LIGHT_GRAY;
    private static final Icon ENABLED_ICON;
    private static final Icon DISABLED_ICON;
    private static final Icon ERROR_ICON;
    private static final Icon WARNING_ICON;
    private static final Icon PROGRESS_ICON;
    private final SketchPanel sketchPanel;
    private JLabel messageLabel = null;
    private long lastCheckedGrinvCC = -1L;
    private boolean autocheckEnabled = false;
    private boolean fixRunning = false;
    private boolean progressBarIsDelayed = true;
    private FixerSelectionPanel fixerPanel = null;
    private JDialog fixerDialog = null;
    private CheckerRunnerDisplay checkerRunnerDisplay = null;
    private FixAllRunnerDisplay fixerRunnerDisplay = null;
    private int progressPercent = 0;
    private final Timer recheckTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckerStatusbarComponent.this.recheckTimer.stop();
            CheckerStatusbarComponent.this.startAutoChecking();
        }
    });
    private final Timer progressTimer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckerStatusbarComponent.this.timerEvent();
        }
    });
    private final PropertyChangeListener sketchChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("mol")) {
                CheckerStatusbarComponent.this.lastCheckedGrinvCC = -1L;
                if (!CheckerStatusbarComponent.this.fixRunning && CheckerStatusbarComponent.this.isAutoCheckEnabled()) {
                    CheckerStatusbarComponent.this.setAutoCheckEnabled(false);
                    CheckerStatusbarComponent.this.setAutoCheckEnabled(true);
                }
                CheckerStatusbarComponent.this.invalidateProblemsList(!CheckerStatusbarComponent.this.fixRunning && !CheckerStatusbarComponent.this.isAutoCheckEnabled());
            } else if (evt.getPropertyName().equalsIgnoreCase("objectAtPointer")) {
                CheckerStatusbarComponent.this.getFixerPanel().updateObjectAtPointer(evt.getNewValue());
            } else if (evt.getPropertyName().equalsIgnoreCase("autoCheckStructure")) {
                CheckerStatusbarComponent.this.setAutoCheckEnabled(Boolean.parseBoolean(evt.getNewValue().toString()));
            }
        }
    };

    public static synchronized CheckerStatusbarComponent getInstance(SketchPanel sketchPanel) {
        CheckerStatusbarComponent component = (CheckerStatusbarComponent)sketchPanel.getClientProperty(CLIENT_PROPERTY_KEY);
        if (component == null) {
            component = new CheckerStatusbarComponent(sketchPanel);
            sketchPanel.putClientProperty(CLIENT_PROPERTY_KEY, component);
        }
        return component;
    }

    public static JMenu getFixerMenu(MolAtom atom, SketchPanel sketchPanel) {
        return CheckerStatusbarComponent.getInstance(sketchPanel).getLocalFixMenu(atom);
    }

    public static JMenu getFixerMenu(MolBond bond, SketchPanel sketchPanel) {
        return CheckerStatusbarComponent.getInstance(sketchPanel).getLocalFixMenu(bond);
    }

    private CheckerStatusbarComponent(SketchPanel sketchPanel) {
        this.sketchPanel = sketchPanel;
        this.sketchPanel.addPropertyChangeListener(this.sketchChangeListener);
        this.sketchPanel.getCanvas().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckerStatusbarComponent.this.getFixerPanel().updateObjectAtPointer(CheckerStatusbarComponent.this.sketchPanel.getObjectAtPointer());
            }
        });
        this.progressTimer.setInitialDelay(1000);
        this.add(this.getMessageLabel());
        this.setOpaque(false);
        this.setAutoCheckEnabled(this.sketchPanel.isAutoCheckStructure());
    }

    private synchronized void timerEvent() {
        if (this.getRunner().isChecking()) {
            this.progressBarIsDelayed = false;
            this.progressPercent = (int)((float)this.getRunner().getCurrent() / (float)this.getRunner().getProgessLength() * 100.0f);
            this.getMessageLabel().repaint();
        } else {
            this.lastCheckedGrinvCC = this.sketchPanel.getMol().getGrinvCC();
            this.progressTimer.stop();
            this.paintProblems();
            this.getFixerPanel().setCheckerResultList(this.getRunner());
            this.getFixerPanel().updateObjectAtPointer(this.sketchPanel.getObjectAtPointer());
            if (Environment.APPLET && this.fixerDialog != null && this.fixerDialog.isVisible()) {
                try {
                    this.fixerDialog.setAlwaysOnTop(true);
                    this.fixerDialog.setAlwaysOnTop(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sketchPanel.firePropertyChange(PROPERTY_KEY_CHECKER_RUNNING, true, false);
        }
    }

    private boolean isChecking() {
        return this.checkerRunnerDisplay != null && this.getRunner().isChecking();
    }

    private JLabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel(){
                private static final long serialVersionUID = -8859646293320272935L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (!CheckerStatusbarComponent.this.fixRunning && CheckerStatusbarComponent.this.isChecking() && !CheckerStatusbarComponent.this.progressBarIsDelayed) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(CheckerStatusbarComponent.this.messageLabel.getBackground());
                        g2.fillRect(20, 0, CheckerStatusbarComponent.this.messageLabel.getWidth(), CheckerStatusbarComponent.this.messageLabel.getHeight());
                        g2.setColor(PROGRESS_BGCOLOR);
                        g2.drawRect(20, 0, CheckerStatusbarComponent.this.messageLabel.getWidth() - 21, CheckerStatusbarComponent.this.messageLabel.getHeight() - 1);
                        g2.fillRect(20, 0, (int)((float)(CheckerStatusbarComponent.this.messageLabel.getWidth() - 21) / 100.0f * (float)CheckerStatusbarComponent.this.progressPercent), CheckerStatusbarComponent.this.messageLabel.getHeight());
                        g2.setColor(PROGRESS_FGCOLOR);
                        g2.setXORMode(PROGRESS_BGCOLOR);
                        g2.setFont(g2.getFont().deriveFont(0));
                        g2.drawString("Checking: " + CheckerStatusbarComponent.this.progressPercent + "%", 22, 13);
                        g2.dispose();
                    }
                }
            };
            this.messageLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        CheckerStatusbarComponent.this.performCheck();
                    } else if (e.getButton() == 3) {
                        CheckerStatusbarComponent.this.setAutoCheckEnabled(!CheckerStatusbarComponent.this.isAutoCheckEnabled());
                    }
                }
            });
            this.updateMessageLabel();
        }
        return this.messageLabel;
    }

    public void paintProblem(StructureCheckerResult result) {
        MDocument doc;
        MolAtom[] atoms = null;
        MolBond[] bonds = null;
        if (result != null) {
            atoms = result.getAtoms().toArray(new MolAtom[result.getAtoms().size()]);
            bonds = result.getBonds().toArray(new MolBond[result.getBonds().size()]);
        }
        if ((doc = this.sketchPanel.getDocument(0)) != null) {
            doc.addCheckerMark(new MDocument.CheckerMark(atoms, bonds, CheckerStatusbarComponent.getInstance(this.sketchPanel).getCheckerMarkColor(false)));
        }
        this.sketchPanel.repaint();
    }

    public void paintProblems() {
        ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
        ArrayList<MolBond> bondList = new ArrayList<MolBond>();
        CheckerRunner runner = this.getRunner();
        List<StructureCheckerResult> resultList = runner.getResultList();
        if (resultList != null) {
            for (StructureCheckerResult result : resultList) {
                if (result == null) continue;
                atomList.addAll(result.getAtoms());
                bondList.addAll(result.getBonds());
            }
        }
        MolAtom[] atoms = new MolAtom[atomList.size()];
        MolBond[] bonds = new MolBond[bondList.size()];
        MDocument doc = this.sketchPanel.getDocument(0);
        if (doc != null) {
            doc.clearCheckerMarks();
            doc.addCheckerMark(new MDocument.CheckerMark(atomList.toArray(atoms), bondList.toArray(bonds), this.getCheckerMarkColor(true)));
        }
        this.paintProblem(this.getFixerPanel().getSelectedResult());
        this.updateMessageLabel();
    }

    Color getCheckerMarkColor(boolean lightMode) {
        Color bg = this.sketchPanel.getBackground();
        if (bg.equals(Color.WHITE)) {
            return lightMode ? LIGHTBG_LIGHTMARK : LIGHTBG_DARKMARK;
        }
        if (bg.equals(Color.BLACK)) {
            return lightMode ? DARKBG_LIGHTMARK : DARKBG_DARKMARK;
        }
        float[] hsb = Color.RGBtoHSB(bg.getRed(), bg.getGreen(), bg.getBlue(), null);
        hsb[2] = (hsb[2] + (float)(lightMode ? 64 : 128)) % 256.0f;
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAutoChecking() {
        CheckerStatusbarComponent checkerStatusbarComponent = this;
        synchronized (checkerStatusbarComponent) {
            Molecule mol = this.sketchPanel.getMol();
            if (mol.getGrinvCC() != this.lastCheckedGrinvCC) {
                if (this.getRunner().isChecking()) {
                    this.getRunner().cancel();
                }
                this.getFixerPanel().showWaitView();
                this.progressPercent = 0;
                this.getRunner().setMolecule(mol);
                this.getRunner().check();
                this.progressBarIsDelayed = true;
                this.progressTimer.start();
                this.updateMessageLabel();
                this.sketchPanel.firePropertyChange(PROPERTY_KEY_CHECKER_RUNNING, false, true);
                this.getMessageLabel().repaint();
            }
        }
    }

    public CheckerRunner getRunner() {
        return this.getCheckerRunnerDisplay().getRunner();
    }

    public void forceCheckerConfigReload() {
        this.getCheckerRunnerDisplay().resetRunner();
        if (this.isAutoCheckEnabled()) {
            this.lastCheckedGrinvCC = -1L;
            this.startAutoChecking();
        } else {
            this.invalidateProblemsList(true);
            this.sketchPanel.getDocument(0).clearCheckerMarks();
            this.sketchPanel.repaint();
        }
    }

    public boolean isAutoCheckEnabled() {
        return this.autocheckEnabled;
    }

    public void setAutoCheckEnabled(boolean enabled) {
        this.autocheckEnabled = enabled;
        this.sketchPanel.setAutoCheckStructure(enabled);
        this.updateMessageLabel();
        if (enabled) {
            if (!this.fixRunning) {
                this.startAutoChecking();
            }
        } else {
            this.recheckTimer.stop();
            if (this.isChecking()) {
                this.getRunner().cancel();
            }
            this.sketchPanel.getDocument(0).clearCheckerMarks();
            this.sketchPanel.repaint();
        }
    }

    public void performCheck() {
        final Cursor oldCursor = this.sketchPanel.getCurrentCursor();
        this.sketchPanel.setCursor(Cursor.getPredefinedCursor(3));
        if (this.lastCheckedGrinvCC != this.sketchPanel.getMol().getGrinvCC()) {
            this.sketchPanel.firePropertyChange(PROPERTY_KEY_CHECKER_RUNNING, false, true);
            this.getFixerPanel().showWaitView();
            this.getCheckerRunnerDisplay().start();
            this.sketchPanel.firePropertyChange(PROPERTY_KEY_CHECKER_RUNNING, true, false);
            this.lastCheckedGrinvCC = this.sketchPanel.getMol().getGrinvCC();
        }
        this.getFixerPanel().setCheckerResultList(this.getCheckerRunnerDisplay().getRunner());
        this.sketchPanel.showWindow(this.getFixerDialog());
        this.getFixerDialog().setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Environment.APPLET && CheckerStatusbarComponent.this.fixerDialog != null && CheckerStatusbarComponent.this.fixerDialog.isVisible()) {
                    try {
                        CheckerStatusbarComponent.this.fixerDialog.setAlwaysOnTop(true);
                        CheckerStatusbarComponent.this.fixerDialog.setAlwaysOnTop(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                CheckerStatusbarComponent.this.paintProblems();
                CheckerStatusbarComponent.this.sketchPanel.setCursor(oldCursor);
            }
        });
    }

    public void cancelCheck() {
        this.getCheckerRunnerDisplay().stop();
    }

    public void performFix(CheckerResultWrapper result) {
        List<StructureFixer> fixers;
        this.fixRunning = true;
        this.getFixerPanel().showWaitView();
        this.updateMessageLabel();
        Cursor oldCursor = this.sketchPanel.getCurrentCursor();
        this.sketchPanel.setCursor(Cursor.getPredefinedCursor(3));
        if (result != null && !(fixers = this.getRunner().getFixers(result)).isEmpty()) {
            this.sketchPanel.getEditor().historize();
            fixers.get(result.getSelectedIndex()).fix(result.getResult());
            this.sketchPanel.repaint();
        }
        this.sketchPanel.repaint();
        this.sketchPanel.setCursor(oldCursor);
        if (this.isAutoCheckEnabled()) {
            this.startAutoChecking();
        } else {
            this.getFixerPanel().showInvalidatedView();
        }
        this.fixRunning = false;
        this.updateMessageLabel();
    }

    public void performFixAll() {
        this.fixRunning = true;
        this.updateMessageLabel();
        Cursor oldCursor = this.sketchPanel.getCurrentCursor();
        boolean oldAutoCheckState = this.isAutoCheckEnabled();
        this.autocheckEnabled = false;
        this.sketchPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.getFixerRunnerDisplay().setFixerList(this.getFixerPanel().getCurrentFixers());
        this.getFixerRunnerDisplay().start();
        this.paintProblems();
        this.sketchPanel.repaint();
        this.sketchPanel.setCursor(oldCursor);
        this.setAutoCheckEnabled(oldAutoCheckState);
        this.lastCheckedGrinvCC = this.sketchPanel.getMol().getGrinvCC();
        this.fixRunning = false;
        this.updateMessageLabel();
        this.performCheck();
    }

    private void invalidateProblemsList(boolean showView) {
        if (this.fixerPanel == null) {
            return;
        }
        this.getFixerPanel().setDirty(true);
        if (showView) {
            this.getFixerPanel().showInvalidatedView();
        }
    }

    private void updateMessageLabel() {
        if (this.fixRunning) {
            this.getMessageLabel().setIcon(PROGRESS_ICON);
            this.getMessageLabel().setToolTipText(FIXER_RUNNING_TOOLTIP_TEXT);
            this.getMessageLabel().setForeground(FIXER_RUNNING_COLOR);
            this.getMessageLabel().setText(FIXER_RUNNING);
            this.getMessageLabel().setPreferredSize(LARGE_LABEL_DIMENSION);
        } else if (this.progressTimer.isRunning()) {
            this.getMessageLabel().setIcon(PROGRESS_ICON);
            this.getMessageLabel().setToolTipText(AUTOCHECK_RUNNING_TOOLTIP_TEXT);
            this.getMessageLabel().setForeground(DISABLED_COLOR);
            this.getMessageLabel().setText(EMPTY_TEXT);
            this.getMessageLabel().setPreferredSize(LARGE_LABEL_DIMENSION);
        } else if (this.isAutoCheckEnabled()) {
            if (this.getRunner().getResultList() != null && this.getRunner().getResultList().size() > 0) {
                boolean isError = false;
                for (int i = 0; i < this.getRunner().getResultList().size() && !isError; ++i) {
                    isError = this.getRunner().getResultList().get(i).getSource().getDescriptor().getSeverity().equals((Object)CheckerSeverity.ERROR);
                }
                this.getMessageLabel().setIcon(isError ? ERROR_ICON : WARNING_ICON);
                this.getMessageLabel().setToolTipText(PROBLEM_TOOLTIP_TEXT);
                this.getMessageLabel().setForeground(PROBLEMS_COLOR);
                this.getMessageLabel().setText(PROBLEMS_FOUND.replaceFirst("%i", String.valueOf(this.getRunner().getResultList().size())));
                this.getMessageLabel().setPreferredSize(LARGE_LABEL_DIMENSION);
            } else {
                this.getMessageLabel().setIcon(ENABLED_ICON);
                this.getMessageLabel().setToolTipText(ENABLED_TOOLTIP_TEXT);
                this.getMessageLabel().setForeground(NO_PROBLEMS_COLOR);
                this.getMessageLabel().setText(NO_PROBLEMS_FOUND);
                this.getMessageLabel().setPreferredSize(LARGE_LABEL_DIMENSION);
            }
        } else {
            this.getMessageLabel().setIcon(DISABLED_ICON);
            this.getMessageLabel().setToolTipText(DISABLED_TOOLTIP_TEXT);
            this.getMessageLabel().setForeground(DISABLED_COLOR);
            this.getMessageLabel().setText(EMPTY_TEXT);
            this.getMessageLabel().setPreferredSize(SMALL_LABEL_DIMENSION);
        }
    }

    private CheckerRunnerDisplay getCheckerRunnerDisplay() {
        if (this.checkerRunnerDisplay == null) {
            this.checkerRunnerDisplay = new CheckerRunnerDisplay(this.sketchPanel);
        }
        return this.checkerRunnerDisplay;
    }

    private FixAllRunnerDisplay getFixerRunnerDisplay() {
        if (this.fixerRunnerDisplay == null) {
            this.fixerRunnerDisplay = new FixAllRunnerDisplay(this.sketchPanel);
            this.fixerRunnerDisplay.setRunner(this.getRunner());
        }
        return this.fixerRunnerDisplay;
    }

    private FixerSelectionPanel getFixerPanel() {
        if (this.fixerPanel == null) {
            this.fixerPanel = new FixerSelectionPanel(this);
            this.fixerPanel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CheckerStatusbarComponent.this.paintProblems();
                }
            });
        }
        return this.fixerPanel;
    }

    private JDialog getFixerDialog() {
        if (this.fixerDialog == null) {
            Window ancestor = SwingUtilities.getWindowAncestor(this.sketchPanel);
            this.fixerDialog = DialogFactory.createDialog(ancestor, this.getFixerPanel(), RESULT_DIALOG_TITLE, this.sketchPanel, true);
            this.fixerDialog.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    Window window;
                    if ((e.getChangeFlags() & 4L) != 0L && e.getSource() instanceof Window && !(window = (Window)e.getSource()).isShowing() && CheckerStatusbarComponent.this.fixerDialog != null) {
                        CheckerStatusbarComponent.this.fixerDialog.removeHierarchyListener(this);
                        CheckerStatusbarComponent.this.fixerDialog.dispose();
                        CheckerStatusbarComponent.this.fixerDialog = null;
                        if (CheckerStatusbarComponent.this.isAutoCheckEnabled()) {
                            CheckerStatusbarComponent.this.getFixerPanel().clearSelection();
                            CheckerStatusbarComponent.this.paintProblems();
                        } else {
                            CheckerStatusbarComponent.this.sketchPanel.getDocument(0).clearCheckerMarks();
                        }
                    }
                }
            });
            this.fixerDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CheckerStatusbarComponent.this.sketchPanel.hideWindow(CheckerStatusbarComponent.this.fixerDialog);
                }
            });
            this.fixerDialog.setTitle(RESULT_DIALOG_TITLE);
        }
        return this.fixerDialog;
    }

    protected JMenu getLocalFixMenu(Object object) {
        JMenu fixMenu = new JMenu("Fix");
        if (this.lastCheckedGrinvCC == this.sketchPanel.getMol().getGrinvCC()) {
            List<StructureCheckerResult> resultList = this.getRunner().getResultList();
            if (object != null && (object instanceof MolAtom || object instanceof MolBond)) {
                for (final StructureCheckerResult result : resultList) {
                    List<StereoConstants> list = object instanceof MolAtom ? result.getAtoms() : result.getBonds();
                    boolean found = false;
                    for (int j = 0; j < list.size() && !found; ++j) {
                        if (list.get(j) != object) continue;
                        found = true;
                        final List<StructureFixer> fixerList = this.getRunner().getFixers(result);
                        if (fixerList == null || fixerList.isEmpty()) continue;
                        if (fixerList.size() == 1) {
                            JMenuItem fixer = new JMenuItem(new AbstractAction(){
                                private static final long serialVersionUID = 2254741152344930452L;

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    CheckerStatusbarComponent.this.sketchPanel.getEditor().historize();
                                    ((StructureFixer)fixerList.get(0)).fix(result);
                                    CheckerStatusbarComponent.this.sketchPanel.repaint();
                                }
                            });
                            fixer.setText(result.getLocalMenuName());
                            fixMenu.add(fixer);
                            continue;
                        }
                        JMenu fixerMenu = new JMenu();
                        for (final StructureFixer fixerItem : fixerList) {
                            JMenuItem fixer = new JMenuItem(new AbstractAction(){
                                private static final long serialVersionUID = 2254741152344930452L;

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    CheckerStatusbarComponent.this.sketchPanel.getEditor().historize();
                                    fixerItem.fix(result);
                                    CheckerStatusbarComponent.this.sketchPanel.repaint();
                                }
                            });
                            fixer.setText(fixerItem.getName());
                            ((Container)fixerMenu).add(fixer);
                        }
                        fixerMenu.setText(result.getLocalMenuName());
                        fixMenu.add(fixerMenu);
                    }
                }
                return fixMenu;
            }
        }
        return null;
    }

    static {
        DISABLED_ICON = new ImageIcon(CheckerStatusbarComponent.class.getResource("/chemaxon/icons/marvin/checker/statusbar-checker-disabled.png"));
        ENABLED_ICON = new ImageIcon(CheckerStatusbarComponent.class.getResource("/chemaxon/icons/marvin/checker/statusbar-checker-enabled.png"));
        ERROR_ICON = new ImageIcon(CheckerStatusbarComponent.class.getResource("/chemaxon/icons/marvin/checker/statusbar-checker-error.png"));
        WARNING_ICON = new ImageIcon(CheckerStatusbarComponent.class.getResource("/chemaxon/icons/marvin/checker/statusbar-checker-warning.png"));
        PROGRESS_ICON = new ImageIcon(CheckerStatusbarComponent.class.getResource("/chemaxon/icons/marvin/checker/statusbar-checker-progress.png"));
    }
}

