/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerCellRenderer;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerEditorWrapper;
import chemaxon.marvin.sketch.swing.modules.checker.ResultCellRenderer;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerResultEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CheckerTable
extends JPanel {
    private static final long serialVersionUID = -9205064658562395057L;
    private static final String DEFAULT_TOOLTIP_EXTRA_FOR_EDITOR_SUPPORT = "<i>Click to configure this item.</i>";
    private static final String DEFAULT_TOOLTIP_EXTRA_FOR_NO_EDITOR_SUPPORT = "<i>This checker does not have any special configuration.</i>";
    public static final int DEFAULT_EDITOR_ROW_HEIGHT = 120;
    static final int CHECKER_COLUMN_INDEX = 0;
    static final int DEFAULT_ROW_HEIGHT = 55;
    private JTable table = null;
    private JScrollPane scrollPane = null;
    private DefaultTableModel tableModel = null;
    private int lastSelectedRow = -1;
    private final String COLUMN_HEADER;
    private final String EMPTY_MESSAGE;
    private String tooltipExtraForEditorSupport = "<i>Click to configure this item.</i>";
    private String tooltipExtraForNoEditorSupport = "<i>This checker does not have any special configuration.</i>";
    private final PropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private final PropertyChangeListener itemChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CheckerTable.this.propertyChangeSupport.firePropertyChange(evt);
        }
    };

    public CheckerTable(String columnHeader, String emptyMessage) {
        this.COLUMN_HEADER = columnHeader;
        this.EMPTY_MESSAGE = emptyMessage;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrollPane(), "Center");
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            JViewport viewport = new JViewport(){
                private static final long serialVersionUID = 511201830030055204L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (CheckerTable.this.getModel().getRowCount() == 0) {
                        String[] text = CheckerTable.this.EMPTY_MESSAGE.split("\n");
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.LIGHT_GRAY);
                        float height = this.getFontMetrics(this.getFont()).getLineMetrics(CheckerTable.this.EMPTY_MESSAGE, g2).getHeight() + 5.0f;
                        float top = ((float)this.getHeight() - (float)text.length * height) / 2.0f;
                        for (int i = 0; i < text.length; ++i) {
                            float left = (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(text[i])) / 2;
                            g2.drawString(text[i], left, top + (float)i * height);
                        }
                        g2.dispose();
                    }
                }
            };
            viewport.setBackground(Color.WHITE);
            this.scrollPane.setViewport(viewport);
            this.scrollPane.setViewportView(this.getTable());
        }
        return this.scrollPane;
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new JTable(this.getModel()){
                private static final long serialVersionUID = 5925279038908969609L;
                private final TableCellEditor structureCheckerEditor;
                private final TableCellRenderer structureCheckerRenderer;
                private final TableCellRenderer checkerResultRenderer;
                {
                    this.structureCheckerEditor = new CheckerEditorWrapper();
                    this.structureCheckerRenderer = new CheckerCellRenderer(){
                        private static final long serialVersionUID = 8802905545457122885L;

                        @Override
                        protected String getToolTipForItem(StructureChecker checker) {
                            return 1.getToolTip(checker, checker.getDescriptor().getEditorClassName() == null ? CheckerTable.this.getTooltipExtraForNoEditorSupport() : CheckerTable.this.getTooltipExtraForEditorSupport());
                        }
                    };
                    this.checkerResultRenderer = new ResultCellRenderer();
                }

                @Override
                public TableCellEditor getCellEditor(int row, int column) {
                    if (this.getValueAt(row, column) instanceof StructureChecker) {
                        return ((StructureChecker)this.getValueAt(row, column)).isAvailable() ? this.structureCheckerEditor : null;
                    }
                    if (this.getValueAt(row, column) instanceof StructureCheckerResult) {
                        return this.structureCheckerEditor;
                    }
                    return null;
                }

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    if (this.getValueAt(row, column) instanceof StructureChecker) {
                        return this.structureCheckerRenderer;
                    }
                    if (this.getValueAt(row, column) instanceof StructureCheckerResult) {
                        return this.checkerResultRenderer;
                    }
                    return super.getCellRenderer(row, column);
                }
            };
            this.table.setRowHeight(55);
            this.table.setRowMargin(5);
            this.table.getSelectionModel().setSelectionMode(0);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (CheckerTable.this.lastSelectedRow != -1) {
                        CheckerTable.this.table.setRowHeight(CheckerTable.this.lastSelectedRow, 55);
                    }
                    CheckerTable.this.lastSelectedRow = CheckerTable.this.table.getSelectedRow();
                    if (CheckerTable.this.lastSelectedRow != -1 && CheckerTable.this.getModel().isCellEditable(CheckerTable.this.lastSelectedRow, 0)) {
                        if (CheckerTable.this.table.editCellAt(CheckerTable.this.lastSelectedRow, 0)) {
                            if (CheckerTable.this.table.getCellEditor().getCellEditorValue() instanceof StructureChecker) {
                                ((StructureChecker)CheckerTable.this.table.getCellEditor().getCellEditorValue()).addPropertyChangeListener(CheckerTable.this.itemChangeListener);
                            }
                            if (CheckerTable.this.table.getCellEditor() instanceof CheckerEditorWrapper) {
                                CheckerTable.this.table.setRowHeight(CheckerTable.this.lastSelectedRow, ((CheckerEditorWrapper)CheckerTable.this.table.getCellEditor()).getPreferredHeight());
                            } else if (CheckerTable.this.table.getCellEditor() instanceof DefaultCheckerResultEditor) {
                                CheckerTable.this.table.setRowHeight(CheckerTable.this.lastSelectedRow, ((DefaultCheckerResultEditor)((Object)CheckerTable.this.table.getCellEditor())).getPreferredHeight());
                            } else {
                                CheckerTable.this.table.setRowHeight(CheckerTable.this.lastSelectedRow, 120);
                            }
                        } else {
                            CheckerTable.this.table.setRowHeight(CheckerTable.this.lastSelectedRow, 120);
                        }
                    } else if (CheckerTable.this.table.getCellEditor() != null) {
                        if (CheckerTable.this.table.getCellEditor().getCellEditorValue() instanceof StructureChecker) {
                            ((StructureChecker)CheckerTable.this.table.getCellEditor().getCellEditorValue()).removePropertyChangeListener(CheckerTable.this.itemChangeListener);
                        }
                        CheckerTable.this.table.getCellEditor().stopCellEditing();
                    }
                }
            });
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setTableHeader(null);
        }
        return this.table;
    }

    public DefaultTableModel getModel() {
        if (this.tableModel == null) {
            this.tableModel = new DefaultTableModel(new String[]{this.COLUMN_HEADER}, 0);
            this.tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    CheckerTable.this.getScrollPane().getViewport().repaint();
                }
            });
        }
        return this.tableModel;
    }

    public TableCellEditor getCellEditor() {
        return this.getTable().getCellEditor();
    }

    public TableCellEditor getCellEditor(int row, int column) {
        return this.getTable().getCellEditor(row, column);
    }

    public int getSelectedRow() {
        return this.getTable().getSelectedRow();
    }

    public void setSelectedRow(int row) {
        this.getTable().getSelectionModel().setValueIsAdjusting(true);
        this.getTable().getSelectionModel().setSelectionInterval(row, row);
        this.getTable().getSelectionModel().setValueIsAdjusting(false);
    }

    public void scrollToRow(int row) {
        Rectangle rect = this.getTable().getCellRect(row, 0, true);
        this.getTable().scrollRectToVisible(rect);
    }

    public ListSelectionModel getSelectionModel() {
        return this.getTable().getSelectionModel();
    }

    public int getRowCount() {
        return this.getTable().getRowCount();
    }

    public JViewport getViewport() {
        return this.getScrollPane().getViewport();
    }

    public void clear() {
        if (this.getTable().getCellEditor() != null && !this.getTable().getCellEditor().stopCellEditing()) {
            this.getTable().getCellEditor().cancelCellEditing();
        }
        this.getModel().setRowCount(0);
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void setTooltipExtraForEditorSupport(String text) {
        this.tooltipExtraForEditorSupport = text;
    }

    public void setTooltipExtraForNoEditorSupport(String text) {
        this.tooltipExtraForNoEditorSupport = text;
    }

    public String getTooltipExtraForEditorSupport() {
        return this.tooltipExtraForEditorSupport;
    }

    public String getTooltipExtraForNoEditorSupport() {
        return this.tooltipExtraForNoEditorSupport;
    }
}

