/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.marvin.sketch.swing.SketchPanel;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DialogFactory {
    public static JDialog createDialog(Window parent, String title) {
        return DialogFactory.createDialog(parent, title, null, false);
    }

    public static JDialog createDialog(Window parent, String title, SketchPanel sketch) {
        return DialogFactory.createDialog(parent, title, sketch, false);
    }

    public static JDialog createDialog(Window parent, String title, SketchPanel sketch, boolean customLocator) {
        return DialogFactory.createDialog(parent, null, title, sketch, customLocator);
    }

    public static JDialog createDialog(Window parent, JComponent content, String title, SketchPanel sketch, boolean customLocator) {
        JDialog dialog;
        JFrame frame = parent instanceof JFrame ? (JFrame)parent : null;
        JDialog jDialog = dialog = parent instanceof JDialog ? (JDialog)parent : null;
        if (dialog != null) {
            return new CustomDialog(dialog, content, title, sketch, customLocator);
        }
        return new CustomDialog(frame, content, title, sketch, customLocator);
    }

    static class CustomDialog
    extends JDialog {
        private static final long serialVersionUID = -6872577096023535712L;
        private final SketchPanel panel;
        private final boolean customLocator;
        private final JComponent content;

        private CustomDialog(JDialog parent, JComponent content, String title, SketchPanel sketch, boolean customLocator) {
            super((Dialog)parent, title);
            this.panel = sketch;
            this.customLocator = customLocator;
            this.content = content;
            if (content != null) {
                this.setContentPane(content);
            }
        }

        private CustomDialog(JFrame parent, JComponent content, String title, SketchPanel sketch, boolean customLocator) {
            super((Frame)parent, title);
            this.panel = sketch;
            this.customLocator = customLocator;
            this.content = content;
            if (content != null) {
                this.setContentPane(content);
            }
        }

        @Override
        public void setVisible(boolean b) {
            if (this.isVisible() == b) {
                return;
            }
            if (this.customLocator && b && this.panel != null) {
                Window ancestor = SwingUtilities.getWindowAncestor(this.panel);
                Rectangle bounds = ancestor.getBounds();
                if (bounds != null) {
                    int w = 2 * bounds.width / 3;
                    int h = bounds.height;
                    if (this.content != null) {
                        int prefW = this.content.getPreferredSize().width + ancestor.getInsets().left + ancestor.getInsets().right;
                        int prefH = this.content.getPreferredSize().height + ancestor.getInsets().top + ancestor.getInsets().bottom;
                        w = prefW;
                        if (prefH > h) {
                            h = prefH;
                        }
                    }
                    this.setBounds(Math.max(0, bounds.x - w), bounds.y, w, h);
                } else {
                    this.setLocationRelativeTo(null);
                    super.pack();
                }
            }
            super.setVisible(b);
        }

        @Override
        public void pack() {
        }

        public void forcePack() {
            super.pack();
        }
    }
}

