/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.fixers.StructureFixer;
import chemaxon.license.LicenseThread;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerRunnerDisplay;
import java.util.List;

public class FixAllRunnerDisplay
extends CheckerRunnerDisplay {
    private static final String IN_PROGRESS_MESSAGE = "Structure fixing in progress, please wait...";
    private static final String PROGRESS_COMPLETED = "Fixing completed.";
    private static final String DIALOG_TITLE = "Structure Fixer";
    private List<StructureFixer> fixerList = null;
    private boolean completed = false;
    private int initialFixerSize = 0;
    private final Runnable recheckRunnable = new Runnable(){

        @Override
        public void run() {
            StructureFixer fixer;
            StructureCheckerResult result;
            if (!FixAllRunnerDisplay.this.fixerList.isEmpty() && (result = FixAllRunnerDisplay.this.getResultForFixer(fixer = (StructureFixer)FixAllRunnerDisplay.this.fixerList.remove(0))) != null) {
                FixAllRunnerDisplay.this.sketch.getEditor().historize();
                fixer.fix(result);
                FixAllRunnerDisplay.this.sketch.repaint();
            }
            FixAllRunnerDisplay.this.progressCheckTimer.start();
            FixAllRunnerDisplay.this.getRunner().setMolecule(FixAllRunnerDisplay.this.sketch.getMol());
            FixAllRunnerDisplay.this.getRunner().check();
        }
    };

    public FixAllRunnerDisplay(SketchPanel sketch) {
        super(sketch);
    }

    public void setFixerList(List<StructureFixer> fixerList) {
        this.initialFixerSize = fixerList.size();
        this.fixerList = fixerList;
    }

    @Override
    public synchronized void start() {
        this.getRunner().setMolecule(this.sketch.getMol());
        this.canceled = false;
        this.completed = false;
        this.setRunMode(true);
        this.getRunner().check();
        new Thread(this.getDialogDisplayerRunnable()).start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.completed || !this.runMode) {
            this.getDialog().setVisible(true);
        }
    }

    @Override
    protected void setRunMode(boolean runMode) {
        this.runMode = runMode;
        this.getCloseButton().setText(runMode ? "Cancel" : "Close");
        this.getProgressBar().setVisible(runMode);
        this.getMessageLabel().setText(runMode ? IN_PROGRESS_MESSAGE : PROGRESS_COMPLETED);
    }

    private StructureCheckerResult getResultForFixer(StructureFixer fixer) {
        if (!this.getRunner().isChecking()) {
            for (StructureCheckerResult result : this.getRunner().getResultList()) {
                List<StructureFixer> fixers = this.getRunner().getFixers(result);
                for (StructureFixer newFixer : fixers) {
                    if (!newFixer.getName().equalsIgnoreCase(fixer.getName())) continue;
                    return result;
                }
            }
        }
        return null;
    }

    @Override
    protected synchronized void stop() {
        if (this.getRunner().isChecking()) {
            this.getRunner().cancel();
        }
        if (this.progressCheckTimer != null) {
            this.progressCheckTimer.stop();
        }
        this.setRunMode(false);
        this.completed = true;
        this.resultList = this.getRunner().getResultList();
        if (this.canceled) {
            this.resultList = null;
        }
        this.hideDialog();
        this.notify();
    }

    @Override
    protected String getDialogTitle() {
        return DIALOG_TITLE;
    }

    @Override
    protected Runnable getDialogDisplayerRunnable() {
        if (this.dialogDisplayerRunnable == null) {
            this.dialogDisplayerRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FixAllRunnerDisplay fixAllRunnerDisplay = FixAllRunnerDisplay.this;
                    synchronized (fixAllRunnerDisplay) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            if (!FixAllRunnerDisplay.this.completed) {
                                FixAllRunnerDisplay.this.progressCheckTimer.start();
                                FixAllRunnerDisplay.this.notify();
                            } else {
                                FixAllRunnerDisplay.this.stop();
                            }
                        }
                    }
                }
            };
        }
        return this.dialogDisplayerRunnable;
    }

    @Override
    protected void progressCheckPerformed() {
        if (this.getRunner().isChecking()) {
            int blockSize = 100 / (this.initialFixerSize + 1);
            int currentBlockpercent = (int)((float)this.getRunner().getCurrent() / (float)this.getRunner().getProgessLength() * 100.0f);
            int percent = (this.initialFixerSize - this.fixerList.size()) * blockSize + (int)((float)blockSize / 100.0f * (float)currentBlockpercent);
            this.getProgressBar().setValue(percent);
            this.getProgressBar().setString("Processing: " + (this.fixerList.isEmpty() ? "Update molecule" : this.fixerList.get(0).getName()));
        } else if (this.fixerList.isEmpty()) {
            this.stop();
        } else {
            new LicenseThread(this.recheckRunnable).start();
        }
    }

    public void setRunner(CheckerRunner runner) {
        this.runner = runner;
    }
}

