/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.AtomTypeChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AtomTypeCheckerEditor
extends DefaultCheckerEditor {
    private JPanel textHolder = null;
    private JTextField textArea = null;
    private AtomTypeChecker checker = null;

    @Override
    protected Component getCustomComponent() {
        if (this.textHolder == null) {
            this.textHolder = new JPanel();
            this.textHolder.setLayout(new BorderLayout());
            this.textHolder.add((Component)this.getAtomTypeListTextArea(), "Center");
        }
        return this.textHolder;
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof AtomTypeChecker) {
            this.checker = (AtomTypeChecker)checker;
            List<String> values = ((AtomTypeChecker)checker).getTypes();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                builder.append(values.get(i));
                if (i + 1 >= values.size()) continue;
                builder.append(',');
            }
            this.getAtomTypeListTextArea().setText(builder.toString());
        }
        return super.getEditorComponent(checker);
    }

    private JTextField getAtomTypeListTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextField();
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    AtomTypeCheckerEditor.this.handleChanges();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    AtomTypeCheckerEditor.this.handleChanges();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    AtomTypeCheckerEditor.this.handleChanges();
                }
            });
        }
        return this.textArea;
    }

    private void handleChanges() {
        String[] values = this.getAtomTypeListTextArea().getText().split(",");
        this.checker.setTypes(Arrays.asList(values));
    }
}

