/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.BondLengthChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BondLengthCheckerEditor
extends DefaultCheckerEditor {
    private BondLengthChecker checker = null;
    private JPanel controlPanel = null;
    private JRadioButton shortOption = null;
    private JRadioButton longOption = null;
    private JRadioButton bothOption = null;
    private final Action UPDATE_ITEM = new AbstractAction(){
        private static final long serialVersionUID = -4202713533761800941L;

        @Override
        public void actionPerformed(ActionEvent e) {
            BondLengthCheckerEditor.this.checker.setDetectTooShortBonds(BondLengthCheckerEditor.this.getShortOption().isSelected() || BondLengthCheckerEditor.this.getBothOption().isSelected());
            BondLengthCheckerEditor.this.checker.setDetectTooLongBonds(BondLengthCheckerEditor.this.getLongOption().isSelected() || BondLengthCheckerEditor.this.getBothOption().isSelected());
        }
    };

    public BondLengthCheckerEditor() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getShortOption());
        group.add(this.getLongOption());
        group.add(this.getBothOption());
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof BondLengthChecker) {
            this.checker = (BondLengthChecker)checker;
            if (this.checker.isDetectTooShortBonds() && !this.checker.isDetectTooLongBonds()) {
                this.getShortOption().setSelected(true);
            } else if (this.checker.isDetectTooLongBonds() && !this.checker.isDetectTooShortBonds()) {
                this.getLongOption().setSelected(true);
            } else {
                this.getBothOption().setSelected(true);
            }
        }
        return super.getEditorComponent(checker);
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, fill:pref:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getShortOption(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getLongOption(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getBothOption(), CC.xy(2, 6));
        }
        return this.controlPanel;
    }

    private JRadioButton getShortOption() {
        if (this.shortOption == null) {
            this.shortOption = new JRadioButton(this.UPDATE_ITEM);
            this.shortOption.setOpaque(false);
            this.shortOption.setText("Detect short bonds");
        }
        return this.shortOption;
    }

    private JRadioButton getLongOption() {
        if (this.longOption == null) {
            this.longOption = new JRadioButton(this.UPDATE_ITEM);
            this.longOption.setOpaque(false);
            this.longOption.setText("Detect long bonds");
        }
        return this.longOption;
    }

    private JRadioButton getBothOption() {
        if (this.bothOption == null) {
            this.bothOption = new JRadioButton(this.UPDATE_ITEM);
            this.bothOption.setOpaque(false);
            this.bothOption.setText("Detect both bonds");
        }
        return this.bothOption;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        BondLengthChecker bondChecker = null;
        if (checker instanceof BondLengthChecker) {
            bondChecker = (BondLengthChecker)checker;
        }
        if (bondChecker != null) {
            if (bondChecker.isDetectTooShortBonds() && !bondChecker.isDetectTooLongBonds()) {
                return this.getShortOption().getText();
            }
            if (bondChecker.isDetectTooLongBonds() && !bondChecker.isDetectTooShortBonds()) {
                return this.getLongOption().getText();
            }
            if (bondChecker.isDetectTooShortBonds() && bondChecker.isDetectTooLongBonds()) {
                return this.getBothOption().getText();
            }
        }
        return null;
    }
}

