/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.checker.editor.CheckerEditor;
import chemaxon.marvin.sketch.swing.modules.checker.editors.BasicCheckerEditor;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class DefaultCheckerEditor
extends BasicCheckerEditor
implements CheckerEditor {
    private StructureChecker checker = null;
    private boolean validating = true;
    protected final PropertyChangeListener validationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("VALID".equals(evt.getPropertyName())) {
                DefaultCheckerEditor.this.updateValidationStatus();
            }
        }
    };

    public DefaultCheckerEditor() {
        this(false);
    }

    public DefaultCheckerEditor(boolean renamable) {
        super(renamable);
    }

    protected void updateValidationStatus() {
        if (this.isValidating() && this.checker != null && !this.checker.isValid()) {
            this.getCaptionLabel().setText("<html><body><b>(!)</b></body></html>");
            this.getNameText().setForeground(Color.RED);
        } else {
            this.getCaptionLabel().setText("");
            this.getNameText().setForeground(Color.BLACK);
        }
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        this.getCaptionLabel().setIcon(checker.getDescriptor().getIcon());
        if (checker.getDescriptor().getCustomName() != null) {
            this.getNameText().setText(checker.getDescriptor().getCustomName());
        } else {
            this.getNameText().setText(checker.getDescriptor().getName());
        }
        this.getCaptionLabel().setEnabled(checker.isAvailable());
        this.getNameText().setEnabled(checker.isAvailable());
        this.getDescriptionLabel().setEnabled(checker.isAvailable());
        this.getDescriptionLabel().setText(checker.getDescriptor().getDescription());
        if (this.checker != null) {
            this.checker.removePropertyChangeListener(this.validationListener);
        }
        this.checker = checker;
        this.checker.addPropertyChangeListener(this.validationListener);
        this.updateValidationStatus();
        return this.getComponent();
    }
}

