/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.ExplicitHydrogenChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ExplicitHydrogenCheckerEditor
extends DefaultCheckerEditor {
    private ExplicitHydrogenChecker checker = null;
    private JPanel controlPanel = null;
    private JCheckBox lonelyCheck;
    private JCheckBox chargedCheck = null;
    private JCheckBox mappedCheck = null;
    private JCheckBox isotopicCheck = null;
    private JCheckBox radicalCheck = null;
    private JCheckBox wedgedCheck = null;

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof ExplicitHydrogenChecker) {
            this.checker = (ExplicitHydrogenChecker)checker;
            this.getLonelyCheck().setSelected(this.checker.isSearchLonely());
            this.getChargedCheck().setSelected(this.checker.isSearchCharged());
            this.getMappedCheck().setSelected(this.checker.isSearchMapped());
            this.getIsotopicCheck().setSelected(this.checker.isSearchIsotopic());
            this.getRadicalCheck().setSelected(this.checker.isSearchRadical());
            this.getWedgedCheck().setSelected(this.checker.isSearchWedged());
        }
        return super.getEditorComponent(checker);
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, min, 2dlu, min, 2dlu, min, 4dlu", "4dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getLonelyCheck(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getChargedCheck(), CC.xy(4, 2));
            this.controlPanel.add((Component)this.getMappedCheck(), CC.xy(6, 2));
            this.controlPanel.add((Component)this.getIsotopicCheck(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getRadicalCheck(), CC.xy(4, 4));
            this.controlPanel.add((Component)this.getWedgedCheck(), CC.xy(6, 4));
        }
        return this.controlPanel;
    }

    private JCheckBox getLonelyCheck() {
        if (this.lonelyCheck == null) {
            this.lonelyCheck = new JCheckBox(new AbstractAction(){
                private static final long serialVersionUID = 1020686758596288257L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplicitHydrogenCheckerEditor.this.checker.setSearchLonely(ExplicitHydrogenCheckerEditor.this.getLonelyCheck().isSelected());
                }
            });
            this.lonelyCheck.setOpaque(false);
            this.lonelyCheck.setText("Lonely");
        }
        return this.lonelyCheck;
    }

    private JCheckBox getChargedCheck() {
        if (this.chargedCheck == null) {
            this.chargedCheck = new JCheckBox(new AbstractAction(){
                private static final long serialVersionUID = -9098205727209038039L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplicitHydrogenCheckerEditor.this.checker.setSearchCharged(ExplicitHydrogenCheckerEditor.this.getChargedCheck().isSelected());
                }
            });
            this.chargedCheck.setOpaque(false);
            this.chargedCheck.setText("Charged");
        }
        return this.chargedCheck;
    }

    private JCheckBox getMappedCheck() {
        if (this.mappedCheck == null) {
            this.mappedCheck = new JCheckBox(new AbstractAction(){
                private static final long serialVersionUID = 4651978575353717940L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplicitHydrogenCheckerEditor.this.checker.setSearchMapped(ExplicitHydrogenCheckerEditor.this.getMappedCheck().isSelected());
                }
            });
            this.mappedCheck.setOpaque(false);
            this.mappedCheck.setText("Mapped");
        }
        return this.mappedCheck;
    }

    private JCheckBox getIsotopicCheck() {
        if (this.isotopicCheck == null) {
            this.isotopicCheck = new JCheckBox(new AbstractAction(){
                private static final long serialVersionUID = -9034287536532689119L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplicitHydrogenCheckerEditor.this.checker.setSearchIsotopic(ExplicitHydrogenCheckerEditor.this.getIsotopicCheck().isSelected());
                }
            });
            this.isotopicCheck.setOpaque(false);
            this.isotopicCheck.setText("Isotopic");
        }
        return this.isotopicCheck;
    }

    private JCheckBox getRadicalCheck() {
        if (this.radicalCheck == null) {
            this.radicalCheck = new JCheckBox(new AbstractAction(){
                private static final long serialVersionUID = -8828073191920935935L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplicitHydrogenCheckerEditor.this.checker.setSearchRadical(ExplicitHydrogenCheckerEditor.this.getRadicalCheck().isSelected());
                }
            });
            this.radicalCheck.setOpaque(false);
            this.radicalCheck.setText("Radical");
        }
        return this.radicalCheck;
    }

    private JCheckBox getWedgedCheck() {
        if (this.wedgedCheck == null) {
            this.wedgedCheck = new JCheckBox(new AbstractAction(){
                private static final long serialVersionUID = 7571213398638885074L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExplicitHydrogenCheckerEditor.this.checker.setSearchWedged(ExplicitHydrogenCheckerEditor.this.getWedgedCheck().isSelected());
                }
            });
            this.wedgedCheck.setOpaque(false);
            this.wedgedCheck.setText("Wedged");
        }
        return this.wedgedCheck;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        ExplicitHydrogenChecker hydroChecker = null;
        if (checker instanceof ExplicitHydrogenChecker) {
            hydroChecker = (ExplicitHydrogenChecker)checker;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (hydroChecker != null) {
            if (hydroChecker.isSearchCharged()) {
                items.add(this.getChargedCheck().getText());
            }
            if (hydroChecker.isSearchIsotopic()) {
                items.add(this.getIsotopicCheck().getText());
            }
            if (hydroChecker.isSearchLonely()) {
                items.add(this.getLonelyCheck().getText());
            }
            if (hydroChecker.isSearchMapped()) {
                items.add(this.getMappedCheck().getText());
            }
            if (hydroChecker.isSearchRadical()) {
                items.add(this.getRadicalCheck().getText());
            }
            if (hydroChecker.isSearchWedged()) {
                items.add(this.getWedgedCheck().getText());
            }
        }
        if (items.isEmpty()) {
            return "No options selected.";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            builder.append((String)items.get(i));
            if (i < items.size() - 2) {
                builder.append(", ");
                continue;
            }
            if (i >= items.size() - 1) continue;
            builder.append(" and ");
        }
        return builder.toString();
    }
}

