/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.RatomChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RatomCheckerEditor
extends DefaultCheckerEditor {
    private RatomChecker checker = null;
    private JPanel controlPanel = null;
    private JCheckBox allCheck = null;
    private JCheckBox disconnectedCheck = null;
    private JCheckBox genericCheck = null;
    private JCheckBox linkerCheck = null;
    private JCheckBox nestedCheck = null;

    private JCheckBox getAllCheck() {
        if (this.allCheck == null) {
            this.allCheck = new JCheckBox(new AbstractAction("All"){
                private static final long serialVersionUID = 4817030532065635436L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RatomCheckerEditor.this.checker.setSearchAll(RatomCheckerEditor.this.getAllCheck().isSelected());
                }
            });
            this.allCheck.setOpaque(false);
        }
        return this.allCheck;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        RatomChecker rChecker = null;
        if (checker instanceof RatomChecker) {
            rChecker = (RatomChecker)checker;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (rChecker != null) {
            if (rChecker.isSearchAll()) {
                items.add(this.getAllCheck().getText());
            }
            if (rChecker.isSearchDisconnected()) {
                items.add(this.getDisconnectedCheck().getText());
            }
            if (rChecker.isSearchGeneric()) {
                items.add(this.getGenericCheck().getText());
            }
            if (rChecker.isSearchLinker()) {
                items.add(this.getLinkerCheck().getText());
            }
            if (rChecker.isSearchNested()) {
                items.add(this.getNestedCheck().getText());
            }
        }
        if (items.isEmpty()) {
            return "No options selected.";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            builder.append((String)items.get(i));
            if (i < items.size() - 2) {
                builder.append(", ");
                continue;
            }
            if (i >= items.size() - 1) continue;
            builder.append(" and ");
        }
        return builder.toString();
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, min, 2dlu, min, 2dlu, min, 4dlu", "4dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getAllCheck(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getDisconnectedCheck(), CC.xy(4, 2));
            this.controlPanel.add((Component)this.getGenericCheck(), CC.xy(6, 2));
            this.controlPanel.add((Component)this.getLinkerCheck(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getNestedCheck(), CC.xy(4, 4));
        }
        return this.controlPanel;
    }

    private JCheckBox getDisconnectedCheck() {
        if (this.disconnectedCheck == null) {
            this.disconnectedCheck = new JCheckBox(new AbstractAction("Disconnected"){
                private static final long serialVersionUID = 7588029683068321843L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RatomCheckerEditor.this.checker.setSearchDisconnected(RatomCheckerEditor.this.getDisconnectedCheck().isSelected());
                }
            });
            this.disconnectedCheck.setOpaque(false);
        }
        return this.disconnectedCheck;
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof RatomChecker) {
            this.checker = (RatomChecker)checker;
            this.getAllCheck().setSelected(this.checker.isSearchAll());
            this.getDisconnectedCheck().setSelected(this.checker.isSearchDisconnected());
            this.getGenericCheck().setSelected(this.checker.isSearchGeneric());
            this.getLinkerCheck().setSelected(this.checker.isSearchLinker());
            this.getNestedCheck().setSelected(this.checker.isSearchNested());
        }
        return super.getEditorComponent(checker);
    }

    private JCheckBox getGenericCheck() {
        if (this.genericCheck == null) {
            this.genericCheck = new JCheckBox(new AbstractAction("Generic"){
                private static final long serialVersionUID = -6970080807389729820L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RatomCheckerEditor.this.checker.setSearchGeneric(RatomCheckerEditor.this.getGenericCheck().isSelected());
                }
            });
            this.genericCheck.setOpaque(false);
        }
        return this.genericCheck;
    }

    private JCheckBox getLinkerCheck() {
        if (this.linkerCheck == null) {
            this.linkerCheck = new JCheckBox(new AbstractAction("Linker"){
                private static final long serialVersionUID = 1023344719484104484L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RatomCheckerEditor.this.checker.setSearchLinker(RatomCheckerEditor.this.getLinkerCheck().isSelected());
                }
            });
            this.linkerCheck.setOpaque(false);
        }
        return this.linkerCheck;
    }

    private JCheckBox getNestedCheck() {
        if (this.nestedCheck == null) {
            this.nestedCheck = new JCheckBox(new AbstractAction("Nested"){
                private static final long serialVersionUID = -160085376126299678L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RatomCheckerEditor.this.checker.setSearchNested(RatomCheckerEditor.this.getNestedCheck().isSelected());
                }
            });
            this.nestedCheck.setOpaque(false);
        }
        return this.nestedCheck;
    }
}

