/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.RingStrainErrorChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RingStrainErrorCheckerEditor
extends DefaultCheckerEditor {
    private RingStrainErrorChecker checker = null;
    private JPanel controlPanel = null;
    private JCheckBox transDoubleBondCheck = null;
    private JCheckBox cumulatedDoubleBondCheck = null;
    private JCheckBox tripleBondCheck = null;

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof RingStrainErrorChecker) {
            this.checker = (RingStrainErrorChecker)checker;
            this.getTransDoubleBondCheck().setSelected(this.checker.isDetectTransDoubleBonds());
            this.getCumulatedDoubleBondCheck().setSelected(this.checker.isDetectCumulatedDoubleBonds());
            this.getTripleBondCheck().setSelected(this.checker.isDetectTripleBonds());
        }
        return super.getEditorComponent(checker);
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, fill:pref:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getTransDoubleBondCheck(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getCumulatedDoubleBondCheck(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getTripleBondCheck(), CC.xy(2, 6));
        }
        return this.controlPanel;
    }

    private JCheckBox getTransDoubleBondCheck() {
        if (this.transDoubleBondCheck == null) {
            this.transDoubleBondCheck = new JCheckBox(new AbstractAction("Detect trans double bonds"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RingStrainErrorCheckerEditor.this.checker.setDetectTransDoubleBonds(RingStrainErrorCheckerEditor.this.getTransDoubleBondCheck().isSelected());
                }
            });
            this.transDoubleBondCheck.setOpaque(false);
        }
        return this.transDoubleBondCheck;
    }

    private JCheckBox getCumulatedDoubleBondCheck() {
        if (this.cumulatedDoubleBondCheck == null) {
            this.cumulatedDoubleBondCheck = new JCheckBox(new AbstractAction("Detect cumulated double bonds"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RingStrainErrorCheckerEditor.this.checker.setDetectCumulatedDoubleBonds(RingStrainErrorCheckerEditor.this.getCumulatedDoubleBondCheck().isSelected());
                }
            });
            this.cumulatedDoubleBondCheck.setOpaque(false);
        }
        return this.cumulatedDoubleBondCheck;
    }

    private JCheckBox getTripleBondCheck() {
        if (this.tripleBondCheck == null) {
            this.tripleBondCheck = new JCheckBox(new AbstractAction("Detect triple bonds"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RingStrainErrorCheckerEditor.this.checker.setDetectTripleBonds(RingStrainErrorCheckerEditor.this.getTripleBondCheck().isSelected());
                }
            });
            this.tripleBondCheck.setOpaque(false);
        }
        return this.tripleBondCheck;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        RingStrainErrorChecker ringChecker = null;
        if (checker instanceof RingStrainErrorChecker) {
            ringChecker = (RingStrainErrorChecker)checker;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (ringChecker != null) {
            if (ringChecker.isDetectTransDoubleBonds()) {
                items.add("Trans double bonds");
            }
            if (ringChecker.isDetectCumulatedDoubleBonds()) {
                items.add("Cumulated double bonds");
            }
            if (ringChecker.isDetectTripleBonds()) {
                items.add("Triple bonds");
            }
        }
        if (items.isEmpty()) {
            return "No options selected.";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            builder.append((String)items.get(i));
            if (i < items.size() - 2) {
                builder.append(", ");
                continue;
            }
            if (i >= items.size() - 1) continue;
            builder.append(" and ");
        }
        return builder.toString();
    }
}

