/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.ValencePropertyChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ValencePropertyCheckerEditor
extends DefaultCheckerEditor {
    private ValencePropertyChecker checker = null;
    private JPanel controlPanel = null;
    private JRadioButton defaultValenceOption = null;
    private JRadioButton nonDefaultValenceOption = null;
    private JRadioButton bothOptions = null;
    private final Action UPDATE_ITEM = new AbstractAction(){
        private static final long serialVersionUID = -4202713533761800941L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ValencePropertyCheckerEditor.this.checker.setSearchDefaultValence(ValencePropertyCheckerEditor.this.getDefaultValenceCheckingOption().isSelected() || ValencePropertyCheckerEditor.this.getBothOptions().isSelected());
            ValencePropertyCheckerEditor.this.checker.setSearchNonDefaultValence(ValencePropertyCheckerEditor.this.getNonDefaultValenceCheckingOption().isSelected() || ValencePropertyCheckerEditor.this.getBothOptions().isSelected());
        }
    };

    public ValencePropertyCheckerEditor() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getNonDefaultValenceCheckingOption());
        group.add(this.getDefaultValenceCheckingOption());
        group.add(this.getBothOptions());
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof ValencePropertyChecker) {
            this.checker = (ValencePropertyChecker)checker;
            if (this.checker.isSearchDefaultValence() && !this.checker.isSearchNonDefaultValence()) {
                this.getDefaultValenceCheckingOption().setSelected(true);
            } else if (this.checker.isSearchNonDefaultValence() && !this.checker.isSearchDefaultValence()) {
                this.getNonDefaultValenceCheckingOption().setSelected(true);
            } else {
                this.getBothOptions().setSelected(true);
            }
        }
        return super.getEditorComponent(checker);
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, fill:pref:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getDefaultValenceCheckingOption(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getNonDefaultValenceCheckingOption(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getBothOptions(), CC.xy(2, 6));
        }
        return this.controlPanel;
    }

    private JRadioButton getDefaultValenceCheckingOption() {
        if (this.defaultValenceOption == null) {
            this.defaultValenceOption = new JRadioButton(this.UPDATE_ITEM);
            this.defaultValenceOption.setOpaque(false);
            this.defaultValenceOption.setText("Detect default valence properties");
        }
        return this.defaultValenceOption;
    }

    private JRadioButton getNonDefaultValenceCheckingOption() {
        if (this.nonDefaultValenceOption == null) {
            this.nonDefaultValenceOption = new JRadioButton(this.UPDATE_ITEM);
            this.nonDefaultValenceOption.setOpaque(false);
            this.nonDefaultValenceOption.setText("Detect non-default valence properties");
        }
        return this.nonDefaultValenceOption;
    }

    private JRadioButton getBothOptions() {
        if (this.bothOptions == null) {
            this.bothOptions = new JRadioButton(this.UPDATE_ITEM);
            this.bothOptions.setOpaque(false);
            this.bothOptions.setText("Detect All Valence Properties");
        }
        return this.bothOptions;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        ValencePropertyChecker valenceChecker = null;
        if (checker instanceof ValencePropertyChecker) {
            valenceChecker = (ValencePropertyChecker)checker;
        }
        if (valenceChecker != null) {
            if (valenceChecker.isSearchDefaultValence() && !valenceChecker.isSearchNonDefaultValence()) {
                return this.getDefaultValenceCheckingOption().getText();
            }
            if (valenceChecker.isSearchNonDefaultValence() && !valenceChecker.isSearchDefaultValence()) {
                return this.getNonDefaultValenceCheckingOption().getText();
            }
            if (valenceChecker.isSearchDefaultValence() && valenceChecker.isSearchNonDefaultValence()) {
                return this.getBothOptions().getText();
            }
        }
        return null;
    }
}

