/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.periodic;

import chemaxon.marvin.sketch.swing.modules.periodic.CustomPropertyBuilder;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class RGroupBuilder
implements CustomPropertyBuilder {
    @Override
    public Molecule buildMolecule(String input, int dim) {
        if (input.length() > 0 && "r".equals(input.substring(0, 1).toLowerCase())) {
            input = input.substring(1);
        }
        if ("".equals(input)) {
            return new Molecule();
        }
        try {
            int n = Integer.parseInt(input);
            if (n >= 0 && n <= Short.MAX_VALUE) {
                MolAtom ra = new MolAtom(134);
                ra.setRgroup(n);
                return new Molecule(null, ra);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Molecule buildRepresentativeMolecule() {
        return this.buildMolecule("1", 2);
    }
}

