/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.services;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.services.ChemicalTermsArgument;
import chemaxon.marvin.services.DynamicArgument;
import chemaxon.marvin.services.MoleculeExporterArgument;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDialogProvider;
import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.ui.AbstractServiceDialogPanel;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.services.SketchBasedDocumentArgument;
import chemaxon.marvin.sketch.swing.modules.services.SketchBasedMoleculeArgument;
import chemaxon.marvin.sketch.swing.modules.services.SketchBasedSelectionArgument;
import chemaxon.marvin.swing.moleculeview.MoleculeViewComponent;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;

public class SketchBasedServiceDialogProvider
implements ServiceDialogProvider {
    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return SketchBasedServiceDialogProvider.getWindowForComponent(parentComponent.getParent());
    }

    @Override
    public Dialog getDialog(Component parent, ServiceDescriptor descriptor) {
        Window parentWindow = SketchBasedServiceDialogProvider.getWindowForComponent(parent);
        final ServicePanel panel = new ServicePanel(parent instanceof SketchPanel ? (SketchPanel)parent : null, descriptor);
        JDialog dialog = new JDialog(parentWindow, descriptor.getName()){

            @Override
            public void dispose() {
                panel.releaseSketch();
                super.dispose();
            }
        };
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                panel.doLayout();
            }
        });
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.setDefaultCloseOperation(2);
        if (parentWindow != null) {
            dialog.setSize(new Dimension(2 * parentWindow.getWidth() / 3, parentWindow.getHeight()));
            dialog.setPreferredSize(new Dimension(2 * parentWindow.getWidth() / 3, parentWindow.getHeight()));
            int prefX = parentWindow.getX() + parentWindow.getWidth();
            int prefY = parentWindow.getY();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            if ((double)(prefX + dialog.getWidth()) > dim.getWidth()) {
                prefX = (int)(dim.getWidth() - (double)dialog.getWidth());
            }
            if ((double)(prefY + dialog.getHeight()) > dim.getHeight()) {
                prefY = (int)(dim.getHeight() - (double)dialog.getHeight());
            }
            if (prefX < 0) {
                prefX = 0;
            }
            if (prefY < 0) {
                prefY = 0;
            }
            dialog.setLocation(prefX, prefY);
        } else {
            dialog.pack();
            dialog.setLocationRelativeTo(null);
        }
        return dialog;
    }

    private static final class ServicePanel
    extends AbstractServiceDialogPanel {
        private static final long serialVersionUID = -6011366195300928798L;
        private static final String RESULT_STRUCT = "struct";
        private static final String RESULT_HTML = "html";
        private JPanel resultsPanel = null;
        private MoleculeViewComponent moleculeView = null;
        private MoleculeViewComponent structureResultView = null;
        private JTabbedPane resultViewHolder = null;
        private JTextPane resultSourceView = null;
        private JTextPane htmlResultView = null;
        private final SketchPanel sketch;
        private final PropertyChangeListener sketchChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (("selectionChanged".equals(evt.getPropertyName()) || "mol".equals(evt.getPropertyName())) && ServicePanel.this.getAutoCallCheck().isSelected()) {
                    ServicePanel.this.updateAction.actionPerformed(null);
                    if (ServicePanel.this.callService.isEnabled()) {
                        ServicePanel.this.callService.actionPerformed(null);
                    } else {
                        ServicePanel.this.updateResults(null);
                    }
                }
            }
        };

        private ServicePanel(SketchPanel sketch, ServiceDescriptor descriptor) {
            super(descriptor);
            this.sketch = sketch;
            if (sketch != null) {
                sketch.addPropertyChangeListener(this.sketchChangeListener);
            }
            this.initUI();
            this.updateInput();
            this.updateManualArguments();
            this.getArgumentsLabel().setVisible(descriptor.getArgumentCount() > 0);
            this.getTablePanel().setVisible(descriptor.getArgumentCount() > 0);
            if (this.canCallService()) {
                this.callService.actionPerformed(null);
            } else {
                this.callService.setEnabled(false);
            }
        }

        public void releaseSketch() {
            if (this.sketch != null) {
                this.sketch.removePropertyChangeListener(this.sketchChangeListener);
            }
        }

        @Override
        protected MoleculeViewComponent getInputView() {
            if (this.moleculeView == null) {
                this.moleculeView = new MoleculeViewComponent();
                this.moleculeView.setFitOnResize(true);
                this.moleculeView.setPreferredSize(new Dimension(200, 200));
            }
            return this.moleculeView;
        }

        @Override
        protected boolean canCallService() {
            return super.canCallService() && !this.sketch.getMol().isEmpty();
        }

        private MoleculeViewComponent getStructureResultView() {
            if (this.structureResultView == null) {
                this.structureResultView = new MoleculeViewComponent();
            }
            return this.structureResultView;
        }

        private JTextPane getResultSourceView() {
            if (this.resultSourceView == null) {
                this.resultSourceView = new JTextPane();
                this.resultSourceView.setEditable(false);
            }
            return this.resultSourceView;
        }

        private JTextPane getHtmlResultView() {
            if (this.htmlResultView == null) {
                this.htmlResultView = new JTextPane();
                this.htmlResultView.setContentType("text/html");
                this.htmlResultView.setEditable(false);
            }
            return this.htmlResultView;
        }

        private JTabbedPane getResultViewHolder() {
            if (this.resultViewHolder == null) {
                this.resultViewHolder = new JTabbedPane();
                this.resultViewHolder.addTab("Structure", this.getStructureResultView());
                this.resultViewHolder.addTab("Source", this.getResultSourceView());
            }
            return this.resultViewHolder;
        }

        @Override
        protected JPanel getResultsView() {
            if (this.resultsPanel == null) {
                CardLayout layout = new CardLayout();
                this.resultsPanel = new JPanel(layout);
                this.resultsPanel.add((Component)this.getResultViewHolder(), RESULT_STRUCT);
                this.resultsPanel.add((Component)this.getHtmlResultView(), RESULT_HTML);
                layout.show(this.resultsPanel, RESULT_HTML);
                this.resultsPanel.setAlignmentX(0.5f);
            }
            return this.resultsPanel;
        }

        @Override
        protected void updateInput() {
            Molecule molecule;
            Molecule molecule2 = molecule = this.sketch != null ? this.sketch.getMol().cloneMolecule() : new Molecule();
            if (molecule.getDocument() != null) {
                molecule.getDocument().clearCheckerMarks();
            }
            this.getInputView().setMolecule(molecule);
            for (int i = 0; i < this.evaluated.length; ++i) {
                if (!(this.arguments.get(i) instanceof DynamicArgument)) continue;
                if (this.arguments.get(i) instanceof SketchBasedDocumentArgument || this.arguments.get(i) instanceof SketchBasedMoleculeArgument || this.arguments.get(i) instanceof SketchBasedSelectionArgument) {
                    this.evaluated[i] = ((DynamicArgument)this.arguments.get(i)).evaluate(this.sketch);
                    continue;
                }
                if (this.arguments.get(i) instanceof ChemicalTermsArgument) {
                    this.evaluated[i] = ((ChemicalTermsArgument)this.arguments.get(i)).evaluate(this.sketch.getMol());
                    continue;
                }
                if (this.arguments.get(i) instanceof MoleculeExporterArgument) {
                    this.evaluated[i] = ((MoleculeExporterArgument)this.arguments.get(i)).evaluate(this.sketch.getMol());
                    continue;
                }
                this.sketch.getErrorDisplay().error("Can not evaluate argument " + this.arguments.get(i), new IllegalArgumentException("Not supported argument type: " + ((ServiceArgument)this.arguments.get(i)).getClass().getName()));
            }
        }

        @Override
        protected void callFailed(ServiceException exception) {
            super.callFailed(exception);
            if (this.sketch != null) {
                this.sketch.getErrorDisplay().error("Service call failed.", exception);
            } else {
                exception.printStackTrace();
            }
        }

        @Override
        public void updateResults(Object result) {
            if (result == null) {
                this.getHtmlResultView().setText("");
                ((CardLayout)this.getResultsView().getLayout()).show(this.getResultsView(), RESULT_HTML);
            } else if (result instanceof Molecule) {
                this.getStructureResultView().setMolecule((Molecule)result);
                ((CardLayout)this.getResultsView().getLayout()).show(this.getResultsView(), RESULT_STRUCT);
                this.getResultViewHolder().setSelectedIndex(0);
                this.getResultViewHolder().setEnabledAt(1, false);
            } else if (result instanceof MDocument) {
                this.getStructureResultView().setMolecule(((MDocument)result).getPrimaryMolecule());
                ((CardLayout)this.getResultsView().getLayout()).show(this.getResultsView(), RESULT_STRUCT);
                this.getResultViewHolder().setSelectedIndex(0);
                this.getResultViewHolder().setEnabledAt(1, false);
            } else {
                Molecule mol = null;
                try {
                    mol = MolImporter.importMol(String.valueOf(result), "nod2s");
                    if (mol.getDim() == 0) {
                        Cleaner.clean(mol, 2, null);
                    }
                    this.getStructureResultView().setMolecule(mol);
                    this.getResultSourceView().setText(String.valueOf(result));
                    ((CardLayout)this.getResultsView().getLayout()).show(this.getResultsView(), RESULT_STRUCT);
                    this.getResultViewHolder().setEnabledAt(1, true);
                }
                catch (MolFormatException e1) {
                    StringBuffer buffer = new StringBuffer();
                    this.createHTMLRepresentationOf(buffer, result, 0);
                    this.getHtmlResultView().setText(buffer.toString());
                    if (this.getHtmlResultView().getDocument() instanceof HTMLDocument) {
                        try {
                            URL url = new URL(this.descriptor.getURL());
                            ((HTMLDocument)this.getHtmlResultView().getDocument()).setBase(url);
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                    ((CardLayout)this.getResultsView().getLayout()).show(this.getResultsView(), RESULT_HTML);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServicePanel.this.repaint();
                    ServicePanel.this.getResultsScrollPane().resize();
                    ServicePanel.this.getResultsScrollPane().invalidate();
                    ServicePanel.this.validate();
                    ServicePanel.this.repaint();
                }
            });
        }
    }
}

