/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl;

import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.CharacterMap;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.Editable;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.Symbol;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;

final class CharacterModel {
    private final Editable editor;
    private Character.UnicodeBlock block;
    private CharacterMap map;
    private Symbol symbol;
    private final Deque<Symbol> lru;

    public CharacterModel(Editable editor, Collection<Symbol> symbols) {
        this.editor = editor;
        this.lru = new LinkedList<Symbol>(symbols);
        if (!this.lru.isEmpty()) {
            this.symbol = this.lru.getFirst();
        }
        this.setFont(this.symbol != null ? this.symbol.getFontFamily() : editor.getDefaultFontFamily());
    }

    public Font getFont() {
        return this.map.getFont();
    }

    public Collection<Symbol> getSymbols() {
        return Collections.unmodifiableCollection(this.lru);
    }

    public String getFontFamily() {
        return this.map.getFont() != null ? this.map.getFont().getFamily() : null;
    }

    public void setFont(String family) {
        this.map = CharacterMap.lookup(family);
        if (this.symbol == null || !this.map.getFont().canDisplay(this.symbol.getCharacter())) {
            this.setSymbol(new Symbol(this.getFontFamily(), this.map.getCharacter(0)));
        } else {
            this.setSymbol(new Symbol(this.getFontFamily(), this.symbol.getCharacter()));
        }
    }

    public CharacterMap getMap() {
        return this.map;
    }

    public int getCharacterIndex() {
        return this.symbol != null && CharacterModel.equals(this.getFontFamily(), this.symbol.getFontFamily()) ? this.map.indexOf(this.symbol.getCharacter()) : -1;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol symbol) {
        Symbol symbol2 = this.symbol = symbol != null ? new Symbol(symbol.getFontFamily(), symbol.getCharacter()) : null;
        if (symbol != null && symbol.getCharacter() != -1) {
            this.block = Character.UnicodeBlock.of(this.symbol.getCharacter());
        }
    }

    public void setCharacter(int codePoint) {
        this.setSymbol(new Symbol(this.getFontFamily(), codePoint));
    }

    public Character.UnicodeBlock getBlock() {
        return this.block;
    }

    public void setBlock(Character.UnicodeBlock selectedBlock) {
        this.block = selectedBlock;
        if (this.symbol == null || !selectedBlock.equals(Character.UnicodeBlock.of(this.symbol.getCharacter()))) {
            this.symbol = new Symbol(this.getFontFamily(), this.map.getCharacter(this.map.getBlockStart(selectedBlock)), Symbol.Source.USER);
        }
    }

    public void insert() {
        if (this.symbol == null) {
            return;
        }
        this.lru.remove(this.symbol);
        this.lru.addFirst(this.symbol);
        this.editor.insert(this.symbol);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

