/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl;

import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.CharacterModel;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.SymbolsDialog;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.SymbolsPM;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.Symbol;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public final class LRUModel {
    private final CharacterModel model;
    private final Component component;
    private final int maxActionCount;
    private Collection<Action> actions;
    private Action moreSymbolsAction;

    public LRUModel(CharacterModel model, Component owner, int maxActionCount) {
        this.model = model;
        this.component = owner;
        this.maxActionCount = maxActionCount;
        this.initSwingModels();
    }

    private void initSwingModels() {
        this.moreSymbolsAction = new MoreSymbolsAction();
        this.actions = new ArrayList<Action>();
        for (Symbol symbol : LRUModel.head(this.model.getSymbols(), this.maxActionCount)) {
            this.actions.add(new SymbolAction(symbol));
        }
    }

    private static <E> Collection<E> head(Collection<E> c, int size) {
        if (c.size() <= size) {
            return c;
        }
        return new ArrayList<E>(c).subList(0, size);
    }

    protected void openSymbolsDialog() {
        new SymbolsDialog(SwingUtilities.getWindowAncestor(this.component), new SymbolsPM(this.model)).open();
    }

    protected void insert(Symbol symbol) {
        this.model.setSymbol(symbol);
        this.model.insert();
    }

    public Action[] getSymbolActions() {
        return this.actions.toArray(new Action[this.actions.size()]);
    }

    public Action getMoreSymbolsAction() {
        return this.moreSymbolsAction;
    }

    private class MoreSymbolsAction
    extends AbstractAction {
        public MoreSymbolsAction() {
            super("More Symbols...");
            this.putValue("SmallIcon", new ImageIcon(LRUModel.class.getResource("/chemaxon/icons/marvin/font/symbol16.png")));
            this.putValue("MnemonicKey", 77);
            this.putValue("ShortDescription", "Insert Symbol");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LRUModel.this.openSymbolsDialog();
        }
    }

    private class SymbolAction
    extends AbstractAction {
        private final Symbol symbol;

        public SymbolAction(Symbol symbol) {
            this.symbol = symbol;
            this.putValue("Name", "<html><font face=" + symbol.getFontFamily() + " style=\"font-size:12px\">" + Symbol.newString(symbol.getCharacter()) + "</font>" + "</html>");
            this.putValue("ShortDescription", symbol.toString());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LRUModel.this.insert(this.symbol);
        }
    }
}

