/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl;

import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.AbstractTableAdapter;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.CharacterMap;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.CharacterModel;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.ListDataAdapter;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.Symbol;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

final class SymbolsPM {
    private static final int COLUMN_COUNT = 16;
    private CharacterModel model;
    private Document characterCode;
    private ComboBoxModel fonts;
    private DefaultComboBoxModel subsets;
    private CharacterMapAdapter characters;
    private SymbolListAdapter lruSymbols;
    private ListSelectionModel rowSelection;
    private ListSelectionModel columnSelection;
    private ListSelectionModel lruColumnSelection;
    private ListSelectionModel lruRowSelection;
    private Action insertAction;
    private DoubleClickHandler doubleClickHandler;
    private InputVerifier verifier;
    private InputVerifier lruVerifier;
    private boolean updating;

    public SymbolsPM(CharacterModel model) {
        this.model = model;
        this.initSwingModels();
    }

    private void initSwingModels() {
        String[] fontFamilyNames = SymbolsPM.getFontFamilyNames();
        this.fonts = new DefaultComboBoxModel<String>(fontFamilyNames);
        this.subsets = new DefaultComboBoxModel();
        this.characters = new CharacterMapAdapter(new CharacterMap(null));
        this.lruSymbols = new SymbolListAdapter();
        this.rowSelection = this.createSelection();
        this.rowSelection.addListSelectionListener(new ListSelectionHandler());
        this.columnSelection = this.createSelection();
        this.columnSelection.addListSelectionListener(new ListSelectionHandler());
        this.lruRowSelection = this.createSelection();
        this.lruRowSelection.addListSelectionListener(new LRUSelectionHandler());
        this.lruColumnSelection = this.createSelection();
        this.lruColumnSelection.addListSelectionListener(new LRUSelectionHandler());
        this.insertAction = new InsertAction();
        this.doubleClickHandler = new DoubleClickHandler();
        this.verifier = new Verifier();
        this.lruVerifier = new LRUVerifier();
        this.subsets.addListDataListener(new SectionChangeHandler());
        this.fonts.addListDataListener(new FontChangeHandler());
        this.characterCode = new PlainDocument();
        this.characterCode.addDocumentListener(new DocumentHandler());
        this.updateSwingModels(true);
    }

    private void updateSwingModels() {
        this.updateSwingModels(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSwingModels(boolean fontChanged) {
        this.updating = true;
        try {
            if (fontChanged) {
                this.fonts.setSelectedItem(this.model.getFontFamily());
                this.subsets.removeAllElements();
                for (Character.UnicodeBlock block : this.model.getMap().getSupportedBlocks()) {
                    this.subsets.addElement(block);
                }
                this.characters.setMap(this.model.getMap());
            }
            this.subsets.setSelectedItem(this.model.getBlock());
            this.updateLRUSelection();
            if (!this.hasLRUSelection()) {
                this.updateLRUSymbols();
            }
            this.updateSelection();
            this.updateCharacterCodeIfNeeded();
            this.insertAction.setEnabled(this.hasSelectedSymbol());
        }
        finally {
            this.updating = false;
        }
    }

    private void updateLRUSymbols() {
        this.lruSymbols.setSymbols(this.model.getSymbols());
        this.updateLRUSelection();
    }

    private void updateSelection() {
        this.updateSelection(this.rowSelection, this.columnSelection, this.characters, this.model.getCharacterIndex());
    }

    private void updateLRUSelection() {
        this.updateSelection(this.lruRowSelection, this.lruColumnSelection, this.lruSymbols, this.lruSymbols.indexOf(this.model.getSymbol()));
    }

    private void updateSelection(ListSelectionModel rowModel, ListSelectionModel columnModel, AbstractTableAdapter adapter, int index) {
        rowModel.setValueIsAdjusting(true);
        columnModel.setValueIsAdjusting(true);
        this.updateIfNeeded(rowModel, adapter.toModelRow(index));
        this.updateIfNeeded(columnModel, adapter.toModelColumn(index));
        rowModel.setValueIsAdjusting(false);
        columnModel.setValueIsAdjusting(false);
    }

    private boolean hasSelectedSymbol() {
        return this.model.getSymbol() != null;
    }

    private boolean hasLRUSelection() {
        return SymbolsPM.hasSelection(this.lruRowSelection, this.lruColumnSelection);
    }

    private static boolean hasSelection(ListSelectionModel rowSelection, ListSelectionModel columnSelection) {
        return !rowSelection.isSelectionEmpty() && !columnSelection.isSelectionEmpty();
    }

    public void updateCharacterCode() {
        this.update(this.characterCode, this.getCharacterCodeString());
    }

    private void updateIfNeeded(ListSelectionModel selection, int index) {
        if (index == -1 && selection.isSelectionEmpty() || selection.isSelectedIndex(index)) {
            return;
        }
        if (index != -1) {
            selection.setSelectionInterval(index, index);
        } else {
            selection.clearSelection();
        }
    }

    private void updateCharacterCodeIfNeeded() {
        try {
            int code = Integer.parseInt(SymbolsPM.getText(this.characterCode), 16);
            if (this.hasSelectedSymbol() && this.model.getSymbol().getCharacter() == code) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.updateCharacterCode();
    }

    private void update(Document document, String text) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public ComboBoxModel getFonts() {
        return this.fonts;
    }

    public ComboBoxModel getSubsets() {
        return this.subsets;
    }

    public TableModel getCharacters() {
        return this.characters;
    }

    public TableModel getLRUSymbols() {
        return this.lruSymbols;
    }

    public ListModel getLRUList() {
        final ArrayList<Symbol> symbols = new ArrayList<Symbol>(this.model.getSymbols());
        return new AbstractListModel(){

            @Override
            public int getSize() {
                return 16;
            }

            @Override
            public Object getElementAt(int index) {
                return symbols.get(index);
            }
        };
    }

    public ListSelectionModel getLRUColumnSelection() {
        return this.lruColumnSelection;
    }

    public ListSelectionModel getLRURowSelection() {
        return this.lruRowSelection;
    }

    public ListSelectionModel getColumnSelection() {
        return this.columnSelection;
    }

    public ListSelectionModel getRowSelection() {
        return this.rowSelection;
    }

    public MouseListener getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public InputVerifier getCharacterCodeVerifier() {
        return this.verifier;
    }

    public InputVerifier getLRUVerifier() {
        return this.lruVerifier;
    }

    public Action getInsertAction() {
        return this.insertAction;
    }

    public Document getCharacterCode() {
        return this.characterCode;
    }

    private void fontChanged() {
        if (this.updating) {
            return;
        }
        this.model.setFont((String)this.fonts.getSelectedItem());
        this.updateSwingModels(true);
    }

    private void insert() {
        this.model.insert();
        this.updateSwingModels(false);
    }

    private void infoChanged() {
        if (this.updating) {
            return;
        }
        try {
            int code = Integer.parseInt(SymbolsPM.getText(this.characterCode), 16);
            if (this.model.getMap().indexOf(code) != -1) {
                this.model.setCharacter(code);
                this.updateSwingModels();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void lruSelectionChanged() {
        if (this.updating) {
            return;
        }
        Symbol newValue = !this.lruColumnSelection.isSelectionEmpty() ? (Symbol)this.lruSymbols.getValueAt(0, this.lruColumnSelection.getMinSelectionIndex()) : null;
        this.model.setSymbol(newValue);
        this.updateSwingModels();
    }

    private void selectionChanged() {
        if (this.updating) {
            return;
        }
        Symbol newValue = null;
        if (!this.rowSelection.isSelectionEmpty() && !this.columnSelection.isSelectionEmpty()) {
            newValue = (Symbol)this.characters.getValueAt(this.rowSelection.getMinSelectionIndex(), this.columnSelection.getMinSelectionIndex());
        }
        this.model.setSymbol(newValue);
        this.updateSwingModels();
    }

    private void sectionChanged() {
        if (this.updating) {
            return;
        }
        this.model.setBlock((Character.UnicodeBlock)this.subsets.getSelectedItem());
        this.updateSwingModels();
    }

    private String getCharacterCodeString() {
        return this.hasSelectedSymbol() ? Symbol.toHexString(this.model.getSymbol().getCharacter()) : "";
    }

    private DefaultListSelectionModel createSelection() {
        DefaultListSelectionModel result = new DefaultListSelectionModel();
        result.setSelectionMode(0);
        return result;
    }

    private static String getText(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private static String[] getFontFamilyNames() {
        Object[] fontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(fontFamilyNames);
        return fontFamilyNames;
    }

    private final class LRUVerifier
    extends InputVerifier {
        @Override
        public boolean shouldYieldFocus(JComponent input) {
            if (!SymbolsPM.this.hasLRUSelection()) {
                SymbolsPM.this.updateLRUSymbols();
            }
            return true;
        }

        @Override
        public boolean verify(JComponent input) {
            return false;
        }
    }

    private final class Verifier
    extends InputVerifier {
        @Override
        public boolean shouldYieldFocus(JComponent input) {
            SymbolsPM.this.updateCharacterCode();
            return true;
        }

        @Override
        public boolean verify(JComponent input) {
            return true;
        }
    }

    private final class DocumentHandler
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            SymbolsPM.this.infoChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SymbolsPM.this.infoChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private static final class CharacterMapAdapter
    extends AbstractTableAdapter {
        private CharacterMap map;

        public CharacterMapAdapter(CharacterMap map) {
            super(16, Symbol.class);
            this.map = map;
        }

        @Override
        protected int getListSize() {
            return this.map != null ? this.map.getCharacterCount() : 0;
        }

        @Override
        protected Object get(int index) {
            return this.map != null ? new Symbol(this.map.getFont().getFamily(), this.map.getCharacter(index)) : null;
        }

        public void setMap(CharacterMap map) {
            this.map = map;
            this.fireTableDataChanged();
        }
    }

    private static final class SymbolListAdapter
    extends AbstractTableAdapter {
        private List<Symbol> symbols = Collections.emptyList();

        public SymbolListAdapter() {
            super(16, Symbol.class);
        }

        public void setSymbols(Collection<Symbol> symbols) {
            this.symbols = new ArrayList<Symbol>(symbols);
            if (this.symbols.size() > 16) {
                this.symbols = this.symbols.subList(0, 16);
            }
            this.fireTableStructureChanged();
        }

        public int indexOf(Object o) {
            return this.symbols.indexOf(o);
        }

        @Override
        protected Object get(int index) {
            return this.symbols.get(index);
        }

        @Override
        protected int getListSize() {
            return this.symbols.size();
        }

        @Override
        public int getRowCount() {
            return 1;
        }
    }

    private class FontChangeHandler
    extends ListDataAdapter {
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() == -1) {
                SymbolsPM.this.fontChanged();
            }
        }
    }

    private class SectionChangeHandler
    extends ListDataAdapter {
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() == -1) {
                SymbolsPM.this.sectionChanged();
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            SymbolsPM.this.selectionChanged();
        }
    }

    private class LRUSelectionHandler
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            SymbolsPM.this.lruSelectionChanged();
        }
    }

    private class DoubleClickHandler
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                SymbolsPM.this.insert();
            }
        }
    }

    private class InsertAction
    extends AbstractAction {
        public InsertAction() {
            super("Insert");
            this.putValue("MnemonicKey", 73);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SymbolsPM.this.insert();
        }
    }
}

