/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;

public class Symbol {
    private static final Collection<Symbol> DEFAULTS;
    private final String fontFamily;
    private final int character;
    private final Source source;

    public Symbol(String fontFamily, int character) {
        this(fontFamily, character, Source.USER);
    }

    public Symbol(String fontFamily, int character, Source source) {
        this.fontFamily = fontFamily;
        this.character = character;
        this.source = source;
    }

    public static Collection<Symbol> getDefaults() {
        return DEFAULTS;
    }

    public static Symbol[] filter(Symbol[] symbols, Source source) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol symbol : symbols) {
            if (symbol.getSource() != source) continue;
            result.add(symbol);
        }
        return result.toArray(new Symbol[result.size()]);
    }

    public static Symbol[] filterDisplayable(Symbol[] symbols) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        HashMap<String, Font> fontCache = new HashMap<String, Font>();
        for (Symbol symbol : symbols) {
            Font font = (Font)fontCache.get(symbol.getFontFamily());
            if (font == null) {
                font = new Font(symbol.getFontFamily(), 0, 1);
                fontCache.put(font.getFamily(), font);
            }
            if (!font.canDisplay(symbol.getCharacter())) continue;
            result.add(symbol);
        }
        return result.toArray(new Symbol[result.size()]);
    }

    public String toString() {
        return this.fontFamily + ": " + Symbol.format(this.character);
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public int getCharacter() {
        return this.character;
    }

    public Source getSource() {
        return this.source;
    }

    private static String format(Symbol symbol) {
        return symbol.fontFamily + ":" + Symbol.format(symbol.character);
    }

    public static String formatSymbols(Symbol[] symbols) {
        String[] columns = new String[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            columns[i] = Symbol.format(symbols[i]);
        }
        return Symbol.concat(columns);
    }

    private static Symbol parse(String str, Source source) {
        String[] t = str.split(":");
        if (t.length != 2) {
            return null;
        }
        String codeStr = t[1].toUpperCase().startsWith("U+") ? t[1].substring(2) : t[1];
        try {
            return new Symbol(t[0], Integer.parseInt(codeStr, 16), source);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static Symbol[] parseSymbols(String str, Source source) {
        String[] columns = Symbol.split(str);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (int i = 0; i < columns.length; ++i) {
            Symbol symbol = Symbol.parse(columns[i], source);
            if (symbol == null) continue;
            result.add(symbol);
        }
        return result.toArray(new Symbol[result.size()]);
    }

    public static String format(int codePoint) {
        if (codePoint < 0 || codePoint > 0x10FFFF) {
            return "-";
        }
        return "U+" + Symbol.toHexString(codePoint);
    }

    public static String toHexString(int i) {
        StringBuilder result = new StringBuilder(Integer.toHexString(i));
        while (result.length() < 4) {
            result.insert(0, "0");
        }
        return result.toString().toUpperCase();
    }

    private static String[] split(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ',') {
                result.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            if (line.charAt(i) == '\\' && i < line.length() - 1) {
                ++i;
            }
            current.append(line.charAt(i));
        }
        if (current.length() != 0) {
            result.add(current.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private static String concat(String[] columns) {
        StringBuilder builder = new StringBuilder();
        for (String column : columns) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(Symbol.escape(column));
        }
        return builder.toString();
    }

    private static String escape(String str) {
        return str.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.character;
        result = 31 * result + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Symbol other = (Symbol)obj;
        if (this.character != other.character) {
            return false;
        }
        return !(this.fontFamily == null ? other.fontFamily != null : !this.fontFamily.equals(other.fontFamily));
    }

    public static String newString(int codePoint) {
        if (Character.charCount(codePoint) == 1) {
            return String.valueOf((char)codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle(Symbol.class.getName());
        String defaults = bundle.getString("defaults");
        Symbol[] preferredSymbols = Symbol.parseSymbols(defaults, Source.DEFAULT);
        DEFAULTS = Collections.unmodifiableCollection(Arrays.asList(Symbol.filterDisplayable(preferredSymbols)));
    }

    public static enum Source {
        DEFAULT,
        PARAMETER,
        USER;

    }
}

