/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.templates;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.TemplateDialogFactory;
import chemaxon.marvin.sketch.swing.templates.TemplateDisplayOption;
import chemaxon.marvin.sketch.swing.templates.TemplateLibraryManager;
import chemaxon.marvin.sketch.swing.templates.TemplatePresentationModel;
import chemaxon.marvin.sketch.swing.templates.TemplateToolBar;
import chemaxon.marvin.sketch.templates.Template;
import chemaxon.marvin.sketch.templates.TemplateLibrary;
import chemaxon.marvin.sketch.templates.TemplateSet;
import chemaxon.marvin.sketch.templates.TemplateSetLocation;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.text.MStringTokenizer;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;

public class TemplateHandler {
    public static final int AS_DEFINED = 0;
    public static final int PERFORM_2D_CLEAN = 1;
    public static final int PERFORM_3D_CLEAN = 2;
    public static final int MYTEMPLATES_GROUP_INDEX = 128;
    public static final String MYTEMPLATES_KEY = "tmpls" + String.valueOf(128);
    public static final String DEFAULT_MY_TEMPLATES_VALUE = "*My Templates*";
    public static boolean myTemplatesEnabled = true;
    private TemplatePresentationModel templatePresentationModel = null;
    private SketchPanel sketchPanel;
    private TemplateToolBar templateToolBar;
    private AbstractDialog templateLibraryManager;
    private Properties templateProperties;
    private boolean manualToolbarSetting = false;
    private boolean toolBarCustomizationEnabled = true;
    private int templateBehavior = 0;
    private int templateLabelSize = 100;
    private ArrayList<TemplateSet> clean2DTemplates = new ArrayList();
    private Molecule[] clean2DMolecules = null;
    private boolean clean2DUpdateNeeded = true;

    public TemplateHandler(SketchPanel sketchPanel) {
        this.sketchPanel = sketchPanel;
    }

    public void init() {
        if (this.templateProperties == null) {
            this.templatePresentationModel = new TemplatePresentationModel(this.sketchPanel);
            this.initTemplateSets(true);
            this.initTemplateSettings();
            this.initTemplatePresentationModel();
            if (this.sketchPanel.getParameter("template.2d") != null) {
                this.templateBehavior = 1;
            } else if (this.sketchPanel.getParameter("template.3d") != null) {
                this.templateBehavior = 2;
            }
        }
    }

    public int getTemplateBehavior() {
        return this.templateBehavior;
    }

    public void setTemplateBehavior(int templateBehavior) {
        this.templateBehavior = templateBehavior;
        this.templateProperties.setProperty("behavior", "" + templateBehavior);
        this.saveTemplateSettings();
    }

    public int getTemplateLabelSize() {
        return this.templateLabelSize;
    }

    public void setTemplateLabelSize(int templateLabelSize) {
        this.templateLabelSize = templateLabelSize;
        ((TemplateLibraryManager)((Object)this.templateLibraryManager)).setTemplateLabelSize(templateLabelSize);
        this.templateProperties.setProperty("labelSize", "" + templateLabelSize);
        this.saveTemplateSettings();
    }

    public void setMaxTemplateCount(int maxTemplateCount) {
        this.templatePresentationModel.setMaxTemplateCount(maxTemplateCount);
        this.templateProperties.setProperty("maxTemplateCount", "" + maxTemplateCount);
        this.saveTemplateSettings();
    }

    public void setMaxToolBarActionCount(int maxToolBarActionCount) {
        this.templatePresentationModel.setMaxToolBarActionCount(maxToolBarActionCount);
        this.templateProperties.setProperty("maxToolbarTemplateCount", "" + maxToolBarActionCount);
        this.saveTemplateSettings();
    }

    private int getIndex(TemplateSet set) {
        return TemplateLibrary.getInstance().getTemplateSetLocationIndex(set);
    }

    public boolean moveTemplateSetUp(TemplateSet templateSet) {
        TemplateLibrary library = TemplateLibrary.getInstance();
        int i = this.getIndex(templateSet);
        TemplateSetLocation tloc1 = library.getTemplateSetLocation(templateSet);
        if (i <= 0 || !tloc1.getName().equals(templateSet.getName())) {
            return false;
        }
        TemplateSetLocation tloc2 = library.getTemplateSetLocation(i - 1);
        library.replaceTemplateSets(i, i - 1);
        this.templateProperties.setProperty(tloc1.getName() + ".index", "" + tloc1.getIndex());
        this.templateProperties.setProperty(tloc2.getName() + ".index", "" + tloc2.getIndex());
        this.saveTemplateSettings();
        this.setToolbarTemplateActions();
        return true;
    }

    public boolean moveTemplateSetDown(TemplateSet templateSet) {
        TemplateLibrary library = TemplateLibrary.getInstance();
        int i = this.getIndex(templateSet);
        TemplateSetLocation tloc1 = library.getTemplateSetLocation(templateSet);
        if (i == library.getTemplateSetCount() - 1 || !tloc1.getName().equals(templateSet.getName())) {
            return false;
        }
        TemplateSetLocation tloc2 = library.getTemplateSetLocation(i + 1);
        library.replaceTemplateSets(i, i + 1);
        this.templateProperties.setProperty(tloc1.getName() + ".index", "" + tloc1.getIndex());
        this.templateProperties.setProperty(tloc2.getName() + ".index", "" + tloc2.getIndex());
        this.saveTemplateSettings();
        this.setToolbarTemplateActions();
        return true;
    }

    public Molecule[] getClean2DTemplates() {
        if (this.clean2DUpdateNeeded) {
            ArrayList<Template> templates = new ArrayList<Template>();
            for (TemplateSet set : this.clean2DTemplates) {
                templates.addAll(set.getTemplates(this.templatePresentationModel.getMaxTemplateCount()));
            }
            Collections.sort(templates, new Clean2DTemplateComparator());
            this.clean2DMolecules = new Molecule[templates.size()];
            int i = 0;
            for (Template t : templates) {
                this.clean2DMolecules[i++] = t.getMolecule();
            }
            this.clean2DUpdateNeeded = false;
        }
        return (Molecule[])this.clean2DMolecules.clone();
    }

    private void initTemplateSettings() {
        if (this.templateProperties.containsKey("labelSize")) {
            this.templateLabelSize = Integer.parseInt(this.templateProperties.get("labelSize").toString());
        }
        if (this.templateProperties.containsKey("behavior")) {
            this.templateBehavior = Integer.parseInt(this.templateProperties.get("behavior").toString());
        }
        if (this.templateProperties.containsKey("maxTemplateCount")) {
            this.templatePresentationModel.setMaxTemplateCount(Integer.parseInt(this.templateProperties.get("maxTemplateCount").toString()));
        }
        if (this.templateProperties.containsKey("maxToolbarTemplateCount")) {
            this.templatePresentationModel.setMaxToolBarActionCount(Integer.parseInt(this.templateProperties.get("maxToolbarTemplateCount").toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTemplateSets(boolean userPropertiesAllowed) {
        this.templateProperties = new Properties(TemplateHandler.getDefaultTemplateSets());
        if (userPropertiesAllowed && !Environment.UNTRUSTED) {
            try {
                InputStream is = DotfileUtil.open("marvin.templates.properties");
                this.templateProperties.load(is);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Set<String> keys = this.templateProperties.stringPropertyNames();
        String s = this.sketchPanel.getParameter("isMyTemplatesEnabled");
        if (s != null && s.equals("false")) {
            keys.remove("My Templates.name");
            myTemplatesEnabled = false;
        }
        Iterator<String> i = keys.iterator();
        TemplateLibrary templateLibrary = TemplateLibrary.getInstance();
        synchronized (templateLibrary) {
            while (i.hasNext()) {
                String key = i.next();
                if (!key.endsWith(".name")) continue;
                String name = this.templateProperties.getProperty(key);
                key = key.substring(0, key.length() - ".name".length());
                String path = this.templateProperties.getProperty(key + ".location");
                String index = this.templateProperties.getProperty(key + ".index");
                int idx = index == null ? -1 : Integer.parseInt(index);
                TemplateLibrary.getInstance().addCustomTemplateSet(name, path, idx);
            }
            TemplateLibrary.getInstance().sortTemplateSets();
            this.initClean2DTemplates();
        }
    }

    private static Properties getDefaultTemplateSets() {
        Properties props = new Properties();
        props.setProperty("Generic.name", "Generic");
        props.setProperty("Generic.location", "/chemaxon/marvin/templates/generic.csmol");
        props.setProperty("Generic.toolbar", "true");
        props.setProperty("Generic.index", "1");
        props.setProperty("Rings.name", "Rings");
        props.setProperty("Rings.location", "/chemaxon/marvin/templates/rings.t");
        props.setProperty("Rings.toolbar", "false");
        props.setProperty("Rings.index", "2");
        props.setProperty("Amino Acids.name", "Amino Acids");
        props.setProperty("Amino Acids.location", "/chemaxon/marvin/templates/aminoacids.t");
        props.setProperty("Amino Acids.toolbar", "false");
        props.setProperty("Amino Acids.index", "3");
        props.setProperty("Aromatics.name", "Aromatics");
        props.setProperty("Aromatics.location", "/chemaxon/marvin/templates/aromatics.t");
        props.setProperty("Aromatics.toolbar", "false");
        props.setProperty("Aromatics.index", "4");
        props.setProperty("Bicyclics.name", "Bicyclics");
        props.setProperty("Bicyclics.location", "/chemaxon/marvin/templates/bicycles.t");
        props.setProperty("Bicyclics.toolbar", "false");
        props.setProperty("Bicyclics.index", "5");
        props.setProperty("Bridged Polycyclics.name", "Bridged Polycyclics");
        props.setProperty("Bridged Polycyclics.location", "/chemaxon/marvin/templates/bridged_polycycles.t");
        props.setProperty("Bridged Polycyclics.toolbar", "false");
        props.setProperty("Bridged Polycyclics.index", "6");
        props.setProperty("Crown Ethers.name", "Crown Ethers");
        props.setProperty("Crown Ethers.location", "/chemaxon/marvin/templates/crown_ethers.t");
        props.setProperty("Crown Ethers.toolbar", "false");
        props.setProperty("Crown Ethers.index", "7");
        props.setProperty("Cycloalkanes.name", "Cycloalkanes");
        props.setProperty("Cycloalkanes.location", "/chemaxon/marvin/templates/cycloalkanes.t");
        props.setProperty("Cycloalkanes.toolbar", "false");
        props.setProperty("Cycloalkanes.index", "8");
        props.setProperty("Heterocycles.name", "Heterocycles");
        props.setProperty("Heterocycles.location", "/chemaxon/marvin/templates/heterocycles.t");
        props.setProperty("Heterocycles.toolbar", "false");
        props.setProperty("Heterocycles.index", "9");
        props.setProperty("Polycyclics.name", "Polycyclics");
        props.setProperty("Polycyclics.location", "/chemaxon/marvin/templates/polycyclics.t");
        props.setProperty("Polycyclics.toolbar", "false");
        props.setProperty("Polycyclics.index", "10");
        props.setProperty("Homology Groups.name", "Homology Groups");
        props.setProperty("Homology Groups.location", "/chemaxon/marvin/templates/homologyGroups.mrv");
        props.setProperty("Homology Groups.toolbar", "false");
        props.setProperty("Homology Groups.index", "11");
        props.setProperty("Alpha D sugars.name", "Alpha D sugars");
        props.setProperty("Alpha D sugars.location", "/chemaxon/marvin/templates/sugars_alpha_D.mrv");
        props.setProperty("Alpha D sugars.toolbar", "false");
        props.setProperty("Alpha D sugars.index", "12");
        props.setProperty("Beta D sugars.name", "Beta D sugars");
        props.setProperty("Beta D sugars.location", "/chemaxon/marvin/templates/sugars_beta_D.mrv");
        props.setProperty("Beta D sugars.toolbar", "false");
        props.setProperty("Beta D sugars.index", "13");
        props.setProperty("Deoxynucleosides.name", "Deoxynucleosides");
        props.setProperty("Deoxynucleosides.location", "/chemaxon/marvin/templates/deoxynucleosides.mrv");
        props.setProperty("Deoxynucleosides.toolbar", "false");
        props.setProperty("Deoxynucleosides.index", "14");
        props.setProperty("Flavonoids.name", "Flavonoids");
        props.setProperty("Flavonoids.location", "/chemaxon/marvin/templates/flavonoids.mrv");
        props.setProperty("Flavonoids.toolbar", "false");
        props.setProperty("Flavonoids.index", "15");
        props.setProperty("Nucleobases.name", "Nucleobases");
        props.setProperty("Nucleobases.location", "/chemaxon/marvin/templates/nucleobases.mrv");
        props.setProperty("Nucleobases.toolbar", "false");
        props.setProperty("Nucleobases.index", "16");
        props.setProperty("Nucleosides.name", "Nucleosides");
        props.setProperty("Nucleosides.location", "/chemaxon/marvin/templates/nucleosides.mrv");
        props.setProperty("Nucleosides.toolbar", "false");
        props.setProperty("Nucleosides.index", "17");
        props.setProperty("Protoalkaloids.name", "Protoalkaloids");
        props.setProperty("Protoalkaloids.location", "/chemaxon/marvin/templates/protoalkaloids.mrv");
        props.setProperty("Protoalkaloids.toolbar", "false");
        props.setProperty("Protoalkaloids.index", "18");
        props.setProperty("True Alkaloids.name", "True Alkaloids");
        props.setProperty("True Alkaloids.location", "/chemaxon/marvin/templates/true_alkaloids.mrv");
        props.setProperty("True Alkaloids.toolbar", "false");
        props.setProperty("True Alkaloids.index", "19");
        props.setProperty("Vitamins.name", "Vitamins");
        props.setProperty("Vitamins.location", "/chemaxon/marvin/templates/vitamins.mrv");
        props.setProperty("Vitamins.toolbar", "false");
        props.setProperty("Vitamins.index", "20");
        props.setProperty("My Templates.name", "My Templates");
        props.setProperty("My Templates.location", "marvin.mytemplates");
        props.setProperty("My Templates.toolbar", "true");
        props.setProperty("My Templates.index", "21");
        return props;
    }

    public TemplateToolBar getTemplateToolBar() {
        return this.templateToolBar;
    }

    public TemplateDisplayOption getToolBarDisplayOptions() {
        return this.templateToolBar.getDisplayOptions();
    }

    public AbstractDialog getTemplateLibraryManager() {
        return this.templateLibraryManager;
    }

    public boolean isTemplateLibraryManagerVisible() {
        return this.templateLibraryManager != null && this.templateLibraryManager.isVisible();
    }

    public void setTemplateLibraryManagerVisible(boolean b) {
        if (b) {
            TemplateDialogFactory df = (TemplateDialogFactory)MarvinModule.load("sketch.swing.TemplateDialogFactoryImpl", this.sketchPanel);
            if (df != null) {
                df.setSketchPanel(this.sketchPanel);
                this.templateLibraryManager = (AbstractDialog)df.createTemplateLibraryDialog();
                ((TemplateLibraryManager)((Object)this.templateLibraryManager)).setTemplateLabelSize(this.templateLabelSize);
                this.templateLibraryManager.open();
            }
        } else {
            this.templateLibraryManager.close();
            this.templateLibraryManager = null;
        }
    }

    public void addToMyTemplates(Molecule m) {
        if (!myTemplatesEnabled) {
            return;
        }
        TemplateLibrary templateLibrary = TemplateLibrary.getInstance();
        templateLibrary.addToMyTemplates(m);
        this.setToolbarTemplateActions();
        if (Template.getAbbreviation(m) != null) {
            this.setUserAbbreviations();
        }
    }

    public void removeMyTemplate(Template t) {
        if (!myTemplatesEnabled) {
            return;
        }
        TemplateLibrary.getInstance().removeMyTemplate(t);
        this.setToolbarTemplateActions();
        if (Template.getAbbreviation(t.getMolecule()) != null) {
            this.setUserAbbreviations();
        }
    }

    public void resetMyTemplates() {
        if (!myTemplatesEnabled) {
            return;
        }
        TemplateLibrary.getInstance().resetMyTemplates();
        this.setToolbarTemplateActions();
        this.setUserAbbreviations();
    }

    public TemplatePresentationModel getTemplatePresentationModel() {
        if (this.templatePresentationModel == null) {
            this.initTemplatePresentationModel();
        }
        return this.templatePresentationModel;
    }

    private void setToolbarTemplateActions() {
        this.templatePresentationModel.clearToolbarTemplates();
        this.validateToolbarActions();
    }

    private void validateToolbarActions() {
        Thread myThread = new Thread(new ToolBarActionValidator());
        myThread.setPriority(5);
        myThread.start();
    }

    private void saveTemplateSettings() {
        if (Environment.UNTRUSTED) {
            return;
        }
        try {
            Properties props = (Properties)this.templateProperties.clone();
            props.remove("Extra Templates.name");
            props.remove("Extra Templates.location");
            props.remove("Extra Templates.toolbar");
            props.remove("Extra Templates.index");
            props.store(DotfileUtil.create("marvin.templates.properties"), "Marvin Templates");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initTemplatePresentationModel() {
        TemplateLibrary templateLibrary = TemplateLibrary.getInstance();
        this.templateToolBar = new TemplateToolBar(this.sketchPanel);
        this.templatePresentationModel.addListener(this.templateToolBar);
        this.templateToolBar.setName("Advanced Templates");
        this.sketchPanel.getGUIModule().addCustomToolBar("mytemplates", this.templateToolBar);
        this.sketchPanel.getGUIModule().addPropertyChangeListener(this.templateToolBar);
        String myTemplates = this.sketchPanel.getParameter(MYTEMPLATES_KEY);
        if (myTemplates != null && myTemplates.startsWith(DEFAULT_MY_TEMPLATES_VALUE)) {
            myTemplates = myTemplates.substring(DEFAULT_MY_TEMPLATES_VALUE.length());
        }
        if (myTemplates == null) {
            myTemplates = "";
        }
        if (myTemplates.equals("chemaxon/marvin/templates/custom.t")) {
            myTemplates = "";
        }
        templateLibrary.setMyTemplatesProperty(myTemplates);
    }

    public boolean isTemplateSetVisibleOnToolbar(TemplateSet set) {
        if (set == null) {
            return false;
        }
        TemplateSetLocation templateSetLocation = TemplateLibrary.getInstance().getTemplateSetLocation(set);
        if (templateSetLocation.getName().equals(set.getName())) {
            return Boolean.parseBoolean(this.templateProperties.getProperty(set.getName() + ".toolbar"));
        }
        String s = this.templateProperties.getProperty(templateSetLocation.getName() + ".extratoolbar." + set.getName());
        return s != null && s.equals(set.getLocation());
    }

    private boolean setTemplateProperties(TemplateSet set, boolean displayOnToolBar) {
        return this.setTemplateProperties(set, displayOnToolBar, this.isClean2DTemplates(set));
    }

    private boolean setTemplateProperties(TemplateSet set, boolean displayOnToolBar, boolean clean2DTemplates) {
        TemplateSetLocation templateSetLocation = TemplateLibrary.getInstance().getTemplateSetLocation(set);
        if (templateSetLocation == null) {
            return false;
        }
        String key = templateSetLocation.getName();
        if (templateSetLocation.getName().equals(set.getName())) {
            this.templateProperties.setProperty(key + ".name", key);
            this.templateProperties.setProperty(key + ".location", templateSetLocation.getLocation());
            this.templateProperties.setProperty(key + ".toolbar", Boolean.toString(displayOnToolBar));
            this.templateProperties.setProperty(key + ".index", "" + templateSetLocation.getIndex());
            this.templateProperties.setProperty(key + ".clean2D", Boolean.toString(clean2DTemplates));
        } else {
            if (displayOnToolBar) {
                this.templateProperties.setProperty(key + ".extratoolbar." + set.getName(), set.getLocation());
            } else {
                this.templateProperties.remove(key + ".extratoolbar." + set.getName());
            }
            if (clean2DTemplates) {
                this.templateProperties.setProperty(key + ".extraclean2D." + set.getName(), set.getLocation());
            } else {
                this.templateProperties.remove(key + ".extraclean2D." + set.getName());
            }
        }
        return true;
    }

    public void setTemplateSetVisibleOnToolbar(TemplateSet set, boolean b, boolean save) {
        if (this.setTemplateProperties(set, b) && save) {
            this.saveTemplateSettings();
        }
        this.setToolbarTemplateActions();
    }

    public boolean isClean2DTemplates(TemplateSet set) {
        if (set == null) {
            return false;
        }
        TemplateSetLocation templateSetLocation = TemplateLibrary.getInstance().getTemplateSetLocation(set);
        if (templateSetLocation.getName().equals(set.getName())) {
            return Boolean.parseBoolean(this.templateProperties.getProperty(set.getName() + ".clean2D"));
        }
        String s = this.templateProperties.getProperty(templateSetLocation.getName() + ".extraclean2D." + set.getName());
        return s != null && s.equals(set.getLocation());
    }

    public void setClean2DTemplates(TemplateSet set, boolean b) {
        if (this.setTemplateProperties(set, this.isTemplateSetVisibleOnToolbar(set), b)) {
            this.saveTemplateSettings();
        }
        if (b) {
            this.clean2DTemplates.add(set);
        } else {
            this.clean2DTemplates.remove(set);
        }
        this.clean2DUpdateNeeded = true;
    }

    private void initClean2DTemplates() {
        ArrayList<TemplateSet> sets = TemplateLibrary.getInstance().getTemplateSets();
        Set<String> keys = this.templateProperties.stringPropertyNames();
        this.initClean2DTemplates(sets, keys);
        this.clean2DUpdateNeeded = true;
    }

    private void initClean2DTemplates(ArrayList<TemplateSet> sets, Set<String> keys) {
        for (TemplateSet set : sets) {
            String key;
            TemplateSet parentSet = TemplateLibrary.getInstance().getTemplateSetLocation(set).getTemplateSet();
            if (parentSet.getName().equals(set.getName())) {
                key = set.getName() + ".clean2D";
                if (keys != null && keys.contains(key) && Boolean.parseBoolean(this.templateProperties.getProperty(key))) {
                    this.clean2DTemplates.add(set);
                }
            } else {
                key = parentSet.getName() + ".extraclean2D." + set.getName();
                if (keys != null && keys.contains(key)) {
                    String identifier = this.templateProperties.getProperty(key);
                    this.clean2DTemplates.add(parentSet.getTemplateSet(identifier));
                }
            }
            this.initClean2DTemplates(set.getTemplateSets(), keys);
        }
    }

    public void setTemplateSetProperties(TemplateSet set, boolean displayOntoolBar, boolean clean2D, boolean save) {
        if (this.setTemplateProperties(set, displayOntoolBar, clean2D) && save) {
            this.saveTemplateSettings();
        }
    }

    public void reloadTemplateSet(TemplateSet set) {
        TemplateLibrary.getInstance().refreshTemplates(set);
    }

    private void setUserAbbreviations() {
        Molecule[] molecules = this.getMoleculesWithAbbreviations();
        this.sketchPanel.setUsrAbbrevGroups(0, molecules);
    }

    public Molecule[] getMoleculesWithAbbreviations() {
        TemplateSetLocation homologyLocation;
        TemplateLibrary templateLibrary = TemplateLibrary.getInstance();
        TemplateSet mytemplates = templateLibrary.getMyTemplates();
        ArrayList<Molecule> abbrevMols = new ArrayList<Molecule>();
        if (mytemplates != null) {
            ArrayList<Template> mytemplateslist = mytemplates.getTemplates(this.templatePresentationModel.getMaxTemplateCount());
            if (mytemplateslist.isEmpty()) {
                templateLibrary.setMyTemplates(mytemplateslist, true);
            }
            abbrevMols.addAll(this.getMoleculesFromTemplates(mytemplateslist));
        }
        if ((homologyLocation = templateLibrary.getTemplateSetLocation("Homology Groups")) != null) {
            ArrayList<Template> homology = homologyLocation.getTemplateSet().getTemplates();
            abbrevMols.addAll(this.getMoleculesFromTemplates(homology));
        }
        return abbrevMols.toArray(new Molecule[abbrevMols.size()]);
    }

    private ArrayList<Molecule> getMoleculesFromTemplates(ArrayList<Template> templates) {
        ArrayList<Molecule> templateMols = new ArrayList<Molecule>(templates.size());
        for (Template t : templates) {
            if (t.getLeftAbbreviation() == null) continue;
            templateMols.add(t.getMolecule());
        }
        return templateMols;
    }

    private void reinit() {
        TemplateLibrary.getInstance().clear();
        this.initTemplateSets(false);
    }

    public void setProperties() {
        boolean parameterSet = false;
        for (int i = 0; i < 128; ++i) {
            String prop = this.sketchPanel.getParameter("tmpls" + i);
            if (prop != null) {
                if (!parameterSet) {
                    parameterSet = true;
                    this.reinit();
                }
                this.setTemplateParameter("tmpls" + i, prop);
            }
            if ((prop = this.sketchPanel.getParameter("ttmpls" + i)) == null) continue;
            if (!parameterSet) {
                parameterSet = true;
                this.reinit();
            }
            this.setToolbarTemplateParameter("ttmpls" + i, prop);
        }
        String s = this.sketchPanel.getParameter("templateToolbarCustomizable");
        if (s != null) {
            this.setToolbarCustomizationEnabled(Boolean.valueOf(s));
        }
        if ((s = this.sketchPanel.getParameter("xtmpls")) != null) {
            this.setTemplateParameter("xtmpls", "*Extra Templates*" + s);
        }
        this.templatePresentationModel.clearToolbarTemplates();
        this.validateToolbarActions();
        this.templatePresentationModel.setTemplateLibrary(TemplateLibrary.getInstance());
    }

    public void setProperties(Properties p) {
        this.init();
        Enumeration<?> e = p.propertyNames();
        TemplateLibrary library = TemplateLibrary.getInstance();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            if (key.equals(MYTEMPLATES_KEY)) {
                String v = value.substring(DEFAULT_MY_TEMPLATES_VALUE.length());
                library.setMyTemplatesProperty(v);
                continue;
            }
            if (key.startsWith("tmpls")) {
                this.setTemplateParameter(key, value);
                continue;
            }
            if (key.startsWith("ttmpls")) {
                this.setToolbarTemplateParameter(key, value);
                continue;
            }
            if ("xtmpls".equals(key)) {
                this.setTemplateParameter(key, "*Extra Templates*" + value);
                continue;
            }
            if (!key.startsWith("templateToolbarCustomizable".toLowerCase())) continue;
            this.setToolbarCustomizationEnabled(Boolean.valueOf(value));
        }
    }

    public void setToolbarTemplateParameter(String name, String value) {
        MStringTokenizer mst = new MStringTokenizer(value);
        String templateSetName = mst.nextToken();
        String path = mst.nextToken();
        boolean setToToolbar = false;
        TemplateLibrary library = TemplateLibrary.getInstance();
        int index = TemplateHandler.getTemplateSetIndex(name);
        TemplateSetLocation loc = null;
        if (index >= 0 && index < library.getTemplateSetCount()) {
            loc = library.getTemplateSetLocation(index);
        }
        if (path != null && !"".equals(path.trim()) && loc != null && !loc.getLocation().equals(path)) {
            library.setTemplateSet(index, templateSetName, path);
            setToToolbar = true;
        }
        if (!this.manualToolbarSetting) {
            this.manualToolbarSetting = true;
            for (int i = 0; i < library.getTemplateSetCount(); ++i) {
                this.setTemplateProperties(library.getTemplateSet(i), false);
            }
        }
        this.setTemplateProperties(library.getTemplateSet(index), setToToolbar);
    }

    public void setTemplateParameter(String name, String value) {
        MStringTokenizer mst = new MStringTokenizer(value);
        String templateSetName = mst.nextToken();
        String path = mst.nextToken();
        TemplateLibrary library = TemplateLibrary.getInstance();
        int index = TemplateHandler.getTemplateSetIndex(name);
        TemplateSetLocation loc = null;
        if (index >= 0 && index < library.getTemplateSetCount()) {
            loc = library.getTemplateSetLocation(index);
        }
        if (path != null && !"".equals(path.trim()) && loc != null && !loc.getLocation().equals(path)) {
            library.setTemplateSet(index, templateSetName, path);
        } else if (loc != null) {
            library.removeTemplateSet(index);
        }
    }

    public boolean isToolBarCustomizationEnabled() {
        return this.toolBarCustomizationEnabled;
    }

    public void setToolbarCustomizationEnabled(boolean b) {
        this.toolBarCustomizationEnabled = b;
    }

    private static int getTemplateSetIndex(String param) {
        if (param.startsWith("tmpls")) {
            return Integer.valueOf(param.substring("tmpls".length()));
        }
        if (param.startsWith("ttmpls")) {
            return Integer.valueOf(param.substring("ttmpls".length()));
        }
        if (param.equals("xtmpls")) {
            TemplateSetLocation loc = TemplateLibrary.getInstance().getTemplateSetLocation("Extra Templates");
            return loc == null ? TemplateLibrary.getInstance().getTemplateSetCount() : loc.getIndex();
        }
        return TemplateLibrary.getInstance().getTemplateSetCount();
    }

    public void addTemplateSet(String name, String path) {
        if (this.checkExistingTemplateSets(path) != 0) {
            return;
        }
        TemplateLibrary.getInstance().addCustomTemplateSet(name, path, -1);
        TemplateLibrary.getInstance().sortTemplateSets();
        this.templateProperties.put(name + ".name", name);
        this.templateProperties.put(name + ".location", path);
        this.templateProperties.put(name + ".toolbar", "false");
        this.templateProperties.put(name + ".index", "-1");
        this.saveTemplateSettings();
    }

    private int checkExistingTemplateSets(String path) {
        path = TemplateSetLocation.getValidPath(path);
        ArrayList<TemplateSet> templateSets = TemplateLibrary.getInstance().getTemplateSets();
        for (TemplateSet set : templateSets) {
            if (set.getLocation().startsWith(path)) {
                int i = this.confirmReplaceTemplateSet(set, path);
                if (i == 0) {
                    this.removeTemplateSet(set);
                }
                return i;
            }
            if (!path.startsWith(set.getLocation())) continue;
            this.notifyTemplateSetAlreadyExists(set);
            return -1;
        }
        return 0;
    }

    private int confirmReplaceTemplateSet(TemplateSet set, String path) {
        int i = JOptionPane.showConfirmDialog(this.templateLibraryManager, "The Library already contains a template set that resides under the selected location.\nYou need to remove it before you can add the new template set.\n\nDo you wish to replace the template set located at '" + set.getLocation() + "' " + "with the new template set located at '" + path + "'?", "Confirm replace template set", 0);
        return i == 0 ? 0 : -1;
    }

    private void notifyTemplateSetAlreadyExists(TemplateSet set) {
        JOptionPane.showMessageDialog(this.templateLibraryManager, "A template set named '" + set.getName() + "' containing the selected path already exists in the Library.", "Cannot add template set", 2);
    }

    public synchronized void removeTemplateSet(TemplateSet set) {
        TemplateLibrary.getInstance().removeTemplateSet(set);
        this.templateProperties.remove(set.getName() + ".name");
        this.templateProperties.remove(set.getName() + ".location");
        this.templateProperties.remove(set.getName() + ".toolbar");
        this.templateProperties.remove(set.getName() + ".index");
        this.saveTemplateSettings();
    }

    private static class Clean2DTemplateComparator
    implements Comparator<Template> {
        private Clean2DTemplateComparator() {
        }

        @Override
        public int compare(Template o1, Template o2) {
            Integer a1 = o1.getMolecule().getAtomCount();
            Integer a2 = o2.getMolecule().getAtomCount();
            return -1 * a1.compareTo(a2);
        }
    }

    private class ToolBarActionValidator
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TemplateLibrary templateLibrary = TemplateLibrary.getInstance();
            synchronized (templateLibrary) {
                ArrayList<TemplateSet> sets = TemplateLibrary.getInstance().getTemplateSets();
                Set<String> keys = TemplateHandler.this.templateProperties.stringPropertyNames();
                this.validateToolbarActions(sets, keys);
            }
        }

        private void validateToolbarActions(ArrayList<TemplateSet> sets, Set<String> keys) {
            for (TemplateSet set : sets) {
                String key;
                TemplateSet parentSet = TemplateLibrary.getInstance().getTemplateSetLocation(set).getTemplateSet();
                if (parentSet.getName().equals(set.getName())) {
                    key = set.getName() + ".toolbar";
                    if (keys != null && keys.contains(key) && Boolean.parseBoolean(TemplateHandler.this.templateProperties.getProperty(key))) {
                        this.addTemplatesToToolBar(set);
                    }
                } else {
                    key = parentSet.getName() + ".extratoolbar." + set.getName();
                    if (keys != null && keys.contains(key)) {
                        String identifier = TemplateHandler.this.templateProperties.getProperty(key);
                        this.addTemplatesToToolBar(parentSet.getTemplateSet(identifier));
                    }
                }
                this.validateToolbarActions(set.getTemplateSets(), keys);
            }
        }

        private void addTemplatesToToolBar(TemplateSet set) {
            ArrayList<Template> templates = set.getTemplates(TemplateHandler.this.templatePresentationModel.getMaxTemplateCount());
            TemplateHandler.this.templatePresentationModel.addToolbarTemplates(templates);
        }
    }
}

